/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.RegistryPropertiesAnnotatorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "PLUGIN_GROUP_NAMES", "", "", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "ShowEPDeclarationIntention", "AddDescriptionKeyIntention", "intellij.devkit.core"})
public final class RegistryPropertiesAnnotator
implements Annotator,
DumbAware {
    @NonNls
    @NotNull
    private final Set<String> PLUGIN_GROUP_NAMES;

    public RegistryPropertiesAnnotator() {
        Object[] objectArray = new String[]{"appcode", "cidr", "clion", "cvs", "git", "github", "svn", "hg4idea", "tfs", "dart", "markdown", "java", "javac", "uast", "junit4", "dsm", "js", "javascript", "typescript", "nodejs", "eslint", "jest", "ruby", "rubymine", "groovy", "grails", "python", "php", "kotlin"};
        this.PLUGIN_GROUP_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PropertiesFile propertiesFile;
        IProperty descriptionProperty;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (!RegistryPropertiesAnnotatorKt.isRegistryPropertiesFile(file)) {
            return;
        }
        String string = ((PropertyKeyImpl)element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String propertyName = string;
        if (RegistryPropertiesAnnotatorKt.isImplicitUsageKey(propertyName)) {
            return;
        }
        String string2 = StringsKt.substringBefore$default((String)propertyName, (char)'.', null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String groupName = string3;
        if (this.PLUGIN_GROUP_NAMES.contains(groupName) || StringsKt.startsWith$default((String)propertyName, (String)"editor.config.", (boolean)false, (int)2, null)) {
            holder.newAnnotation(HighlightSeverity.ERROR, DevKitBundle.message("registry.properties.annotator.plugin.keys.use.ep", new Object[0])).withFix((IntentionAction)new ShowEPDeclarationIntention(propertyName)).create();
        }
        if ((descriptionProperty = (propertiesFile = (PropertiesFile)file).findPropertyByKey(propertyName + ".description")) == null) {
            Object[] objectArray = new Object[]{propertyName};
            holder.newAnnotation(HighlightSeverity.WARNING, DevKitBundle.message("registry.properties.annotator.key.no.description.key", objectArray)).withFix((IntentionAction)new AddDescriptionKeyIntention(propertyName)).create();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0017J\b\u0010\b\u001a\u00020\u0004H\u0017J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\b\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$AddDescriptionKeyIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/project/DumbAware;", "myPropertyName", "", "<init>", "(Ljava/lang/String;)V", "getText", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "startInWriteAction", "intellij.devkit.core"})
    private static final class AddDescriptionKeyIntention
    implements IntentionAction,
    DumbAware {
        @NotNull
        private final String myPropertyName;

        public AddDescriptionKeyIntention(@NotNull String myPropertyName) {
            Intrinsics.checkNotNullParameter((Object)myPropertyName, (String)"myPropertyName");
            this.myPropertyName = myPropertyName;
        }

        @Nls
        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.myPropertyName};
            String string = DevKitBundle.message("registry.properties.annotator.add.description.text", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("registry.properties.annotator.add.description.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PropertiesFile propertiesFile = (PropertiesFile)file;
            PropertyImpl originalProperty = (PropertyImpl)propertiesFile.findPropertyByKey(this.myPropertyName);
            IProperty iProperty = propertiesFile.addPropertyAfter(this.myPropertyName + ".description", "Description", (IProperty)originalProperty);
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"addPropertyAfter(...)");
            IProperty descriptionProperty = iProperty;
            PsiElement psiElement = descriptionProperty.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.impl.PropertyImpl");
            ASTNode aSTNode = ((PropertyImpl)psiElement).getValueNode();
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode valueNode = aSTNode;
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)valueNode.getPsi())) {
                PsiNavigateUtil.navigate((PsiElement)valueNode.getPsi());
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J$\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$ShowEPDeclarationIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/project/DumbAware;", "propertyName", "", "<init>", "(Ljava/lang/String;)V", "startInWriteAction", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "isAvailable", "getText", "invoke", "", "intellij.devkit.core"})
    private static final class ShowEPDeclarationIntention
    implements IntentionAction,
    DumbAware {
        @NotNull
        private final String propertyName;

        public ShowEPDeclarationIntention(@NotNull String propertyName) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            this.propertyName = propertyName;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }

        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("registry.properties.annotator.show.ep.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return true;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.propertyName};
            String string = DevKitBundle.message("registry.properties.annotator.show.ep.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.PropertiesFile");
            PropertiesFile propertiesFile = (PropertiesFile)file;
            IProperty iProperty = propertiesFile.findPropertyByKey(this.propertyName);
            Intrinsics.checkNotNull((Object)iProperty);
            String defaultValue = iProperty.getValue();
            IProperty iProperty2 = propertiesFile.findPropertyByKey(this.propertyName + ".description");
            String description = iProperty2 != null ? iProperty2.getValue() : null;
            String restartRequiredText = "";
            if (propertiesFile.findPropertyByKey(this.propertyName + ".restartRequired") != null) {
                restartRequiredText = "restartRequired=\"true\"";
            }
            String epText = StringsKt.trimIndent((String)("\n        <registryKey key=\"" + this.propertyName + "\" defaultValue=\"" + defaultValue + "\" " + restartRequiredText + "\n                     description=\"" + description + "\"/>\n      "));
            Messages.showMultilineInputDialog((Project)project, (String)DevKitBundle.message("registry.properties.annotator.show.ep.message", new Object[0]), (String)DevKitBundle.message("registry.properties.annotator.show.ep.title", new Object[0]), (String)epText, null, null);
        }
    }
}

