/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0001\u0019B'\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ServiceRetrievingInspectionBase;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "additionalComponentManagerMethodNames", "", "", "additionalServiceKtFileMethodNames", "<init>", "([Ljava/lang/String;[Ljava/lang/String;)V", "serviceKtFileMethods", "Lcom/siyeh/ig/callMatcher/CallMatcher$Simple;", "getServiceKtFileMethods", "()Lcom/siyeh/ig/callMatcher/CallMatcher$Simple;", "componentManagerGetServiceMethods", "Lcom/siyeh/ig/callMatcher/CallMatcher;", "getComponentManagerGetServiceMethods", "()Lcom/siyeh/ig/callMatcher/CallMatcher;", "allGetServiceMethods", "getAllGetServiceMethods", "getServiceRetrievingInfo", "Lorg/jetbrains/idea/devkit/inspections/ServiceRetrievingInspectionBase$ServiceRetrievingInfo;", "node", "Lorg/jetbrains/uast/UCallExpression;", "howServiceRetrieved", "Lcom/intellij/openapi/components/Service$Level;", "getServiceCandidate", "ServiceRetrievingInfo", "intellij.devkit.core"})
public abstract class ServiceRetrievingInspectionBase
extends DevKitUastInspectionBase {
    @NotNull
    private final CallMatcher.Simple serviceKtFileMethods;
    @NotNull
    private final CallMatcher componentManagerGetServiceMethods;
    @NotNull
    private final CallMatcher allGetServiceMethods;

    public ServiceRetrievingInspectionBase(@NotNull String[] additionalComponentManagerMethodNames, @NotNull String[] additionalServiceKtFileMethodNames) {
        Intrinsics.checkNotNullParameter((Object)additionalComponentManagerMethodNames, (String)"additionalComponentManagerMethodNames");
        Intrinsics.checkNotNullParameter((Object)additionalServiceKtFileMethodNames, (String)"additionalServiceKtFileMethodNames");
        CallMatcher[] callMatcherArray = new SpreadBuilder(2);
        callMatcherArray.add((Object)"service");
        callMatcherArray.addSpread((Object)additionalServiceKtFileMethodNames);
        CallMatcher.Simple simple = CallMatcher.staticCall((String)"com.intellij.openapi.components.ServiceKt", (String[])((String[])callMatcherArray.toArray((Object[])new String[callMatcherArray.size()]))).parameterCount(0);
        Intrinsics.checkNotNullExpressionValue((Object)simple, (String)"parameterCount(...)");
        this.serviceKtFileMethods = simple;
        callMatcherArray = new CallMatcher[2];
        String string = ComponentManager.class.getCanonicalName();
        String[] stringArray = new SpreadBuilder(2);
        stringArray.add((Object)"getService");
        stringArray.addSpread((Object)additionalComponentManagerMethodNames);
        CallMatcher.Simple simple2 = CallMatcher.instanceCall((String)string, (String[])((String[])stringArray.toArray((Object[])new String[stringArray.size()])));
        stringArray = new String[]{"java.lang.Class"};
        callMatcherArray[0] = simple2.parameterTypes(stringArray);
        stringArray = new SpreadBuilder(2);
        stringArray.add((Object)"service");
        stringArray.addSpread((Object)additionalServiceKtFileMethodNames);
        CallMatcher.Simple simple3 = CallMatcher.staticCall((String)"com.intellij.openapi.components.ServicesKt", (String[])((String[])stringArray.toArray((Object[])new String[stringArray.size()])));
        stringArray = new String[]{ComponentManager.class.getCanonicalName()};
        callMatcherArray[1] = simple3.parameterTypes(stringArray);
        simple = CallMatcher.anyOf((CallMatcher[])callMatcherArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple, (String)"anyOf(...)");
        this.componentManagerGetServiceMethods = simple;
        callMatcherArray = new CallMatcher[]{this.componentManagerGetServiceMethods, this.serviceKtFileMethods};
        CallMatcher callMatcher = CallMatcher.anyOf((CallMatcher[])callMatcherArray);
        Intrinsics.checkNotNullExpressionValue((Object)callMatcher, (String)"anyOf(...)");
        this.allGetServiceMethods = callMatcher;
    }

    public /* synthetic */ ServiceRetrievingInspectionBase(String[] stringArray, String[] stringArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            stringArray = new String[]{};
        }
        if ((n & 2) != 0) {
            stringArray2 = new String[]{};
        }
        this(stringArray, stringArray2);
    }

    @NotNull
    protected final CallMatcher.Simple getServiceKtFileMethods() {
        return this.serviceKtFileMethods;
    }

    @NotNull
    protected final CallMatcher getComponentManagerGetServiceMethods() {
        return this.componentManagerGetServiceMethods;
    }

    @NotNull
    protected final CallMatcher getAllGetServiceMethods() {
        return this.allGetServiceMethods;
    }

    @Nullable
    protected final ServiceRetrievingInfo getServiceRetrievingInfo(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.allGetServiceMethods.uCallMatches(node)) {
            return null;
        }
        Service.Level level = this.howServiceRetrieved(node);
        if (level == null) {
            return null;
        }
        Service.Level howServiceRetrieved = level;
        PsiType psiType = node.getReturnType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType serviceType = psiClassType;
        PsiClass psiClass = serviceType.resolve();
        if (psiClass == null || (psiClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)psiClass), UClass.class)) == null) {
            return null;
        }
        PsiClass serviceClass = psiClass;
        return new ServiceRetrievingInfo(howServiceRetrieved, (UClass)serviceClass);
    }

    private final Service.Level howServiceRetrieved(UCallExpression getServiceCandidate) {
        if (this.serviceKtFileMethods.uCallMatches(getServiceCandidate)) {
            return Service.Level.APP;
        }
        UExpression uExpression = getServiceCandidate.getReceiver();
        if (uExpression == null || (uExpression = uExpression.getExpressionType()) == null) {
            return null;
        }
        UExpression receiverType = uExpression;
        PsiClassType psiClassType = receiverType instanceof PsiClassType ? (PsiClassType)receiverType : null;
        if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
            return null;
        }
        PsiClassType aClass = psiClassType;
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)Application.class.getCanonicalName()) ? Service.Level.APP : (InheritanceUtil.isInheritor((PsiClass)aClass, (String)Project.class.getCanonicalName()) ? Service.Level.PROJECT : null);
    }

    public ServiceRetrievingInspectionBase() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ServiceRetrievingInspectionBase$ServiceRetrievingInfo;", "", "howServiceRetrieved", "Lcom/intellij/openapi/components/Service$Level;", "serviceClass", "Lorg/jetbrains/uast/UClass;", "<init>", "(Lcom/intellij/openapi/components/Service$Level;Lorg/jetbrains/uast/UClass;)V", "getHowServiceRetrieved", "()Lcom/intellij/openapi/components/Service$Level;", "getServiceClass", "()Lorg/jetbrains/uast/UClass;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.devkit.core"})
    protected static final class ServiceRetrievingInfo {
        @NotNull
        private final Service.Level howServiceRetrieved;
        @NotNull
        private final UClass serviceClass;

        public ServiceRetrievingInfo(@NotNull Service.Level howServiceRetrieved, @NotNull UClass serviceClass) {
            Intrinsics.checkNotNullParameter((Object)howServiceRetrieved, (String)"howServiceRetrieved");
            Intrinsics.checkNotNullParameter((Object)serviceClass, (String)"serviceClass");
            this.howServiceRetrieved = howServiceRetrieved;
            this.serviceClass = serviceClass;
        }

        @NotNull
        public final Service.Level getHowServiceRetrieved() {
            return this.howServiceRetrieved;
        }

        @NotNull
        public final UClass getServiceClass() {
            return this.serviceClass;
        }

        @NotNull
        public final Service.Level component1() {
            return this.howServiceRetrieved;
        }

        @NotNull
        public final UClass component2() {
            return this.serviceClass;
        }

        @NotNull
        public final ServiceRetrievingInfo copy(@NotNull Service.Level howServiceRetrieved, @NotNull UClass serviceClass) {
            Intrinsics.checkNotNullParameter((Object)howServiceRetrieved, (String)"howServiceRetrieved");
            Intrinsics.checkNotNullParameter((Object)serviceClass, (String)"serviceClass");
            return new ServiceRetrievingInfo(howServiceRetrieved, serviceClass);
        }

        public static /* synthetic */ ServiceRetrievingInfo copy$default(ServiceRetrievingInfo serviceRetrievingInfo, Service.Level level, UClass uClass, int n, Object object) {
            if ((n & 1) != 0) {
                level = serviceRetrievingInfo.howServiceRetrieved;
            }
            if ((n & 2) != 0) {
                uClass = serviceRetrievingInfo.serviceClass;
            }
            return serviceRetrievingInfo.copy(level, uClass);
        }

        @NotNull
        public String toString() {
            return "ServiceRetrievingInfo(howServiceRetrieved=" + this.howServiceRetrieved + ", serviceClass=" + this.serviceClass + ")";
        }

        public int hashCode() {
            int result = this.howServiceRetrieved.hashCode();
            result = result * 31 + this.serviceClass.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServiceRetrievingInfo)) {
                return false;
            }
            ServiceRetrievingInfo serviceRetrievingInfo = (ServiceRetrievingInfo)other;
            if (this.howServiceRetrieved != serviceRetrievingInfo.howServiceRetrieved) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.serviceClass, (Object)serviceRetrievingInfo.serviceClass);
        }
    }
}

