/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.AnalysisUastUtilKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.MethodNameProvider;
import org.jetbrains.idea.devkit.inspections.MethodNameProviders;
import org.jetbrains.idea.devkit.inspections.ServiceRetrievingInspectionBase;
import org.jetbrains.idea.devkit.inspections.SimplifiableServiceRetrievingInspectionKt;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u0018\u0010\u0019\u001a\u00020\t*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\t*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/SimplifiableServiceRetrievingInspection;", "Lorg/jetbrains/idea/devkit/inspections/ServiceRetrievingInspectionBase;", "<init>", "()V", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "findGetInstanceMethod", "Lorg/jetbrains/uast/UMethod;", "retrievingExpression", "Lorg/jetbrains/uast/UExpression;", "howServiceRetrieved", "Lcom/intellij/openapi/components/Service$Level;", "serviceClass", "Lorg/jetbrains/uast/UClass;", "registerProblem", "", "replacementMethod", "isGetInstanceProjectLevel", "method", "isGetInstanceApplicationLevel", "isApplicableForGetInstance", "isStaticOrJvmStatic", "(Lorg/jetbrains/uast/UMethod;)Z", "isNullable", "getReturnExpression", "Lorg/jetbrains/uast/UReturnExpression;", "ReplaceWithGetInstanceCallFix", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nSimplifiableServiceRetrievingInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifiableServiceRetrievingInspection.kt\norg/jetbrains/idea/devkit/inspections/SimplifiableServiceRetrievingInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class SimplifiableServiceRetrievingInspection
extends ServiceRetrievingInspectionBase {
    public SimplifiableServiceRetrievingInspection() {
        super(null, null, 3, null);
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ SimplifiableServiceRetrievingInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                ServiceRetrievingInspectionBase.ServiceRetrievingInfo serviceRetrievingInfo = this.this$0.getServiceRetrievingInfo(node);
                if (serviceRetrievingInfo == null) {
                    return true;
                }
                ServiceRetrievingInspectionBase.ServiceRetrievingInfo serviceRetrievingInfo2 = serviceRetrievingInfo;
                Service.Level howServiceRetrieved = serviceRetrievingInfo2.component1();
                UClass serviceClass = serviceRetrievingInfo2.component2();
                UExpression uExpression = SimplifiableServiceRetrievingInspectionKt.access$getRetrievingExpression(node);
                if (uExpression == null) {
                    return true;
                }
                UExpression retrievingExpression = uExpression;
                if (SimplifiableServiceRetrievingInspectionKt.access$isInitializerOfVariableAnnotatedAsNullable(retrievingExpression)) {
                    return true;
                }
                UMethod getInstanceMethod = SimplifiableServiceRetrievingInspection.access$findGetInstanceMethod(this.this$0, retrievingExpression, howServiceRetrieved, serviceClass);
                if (getInstanceMethod != null) {
                    SimplifiableServiceRetrievingInspection.access$registerProblem(this.this$0, getInstanceMethod, howServiceRetrieved, this.$holder, retrievingExpression);
                }
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final UMethod findGetInstanceMethod(UExpression retrievingExpression, Service.Level howServiceRetrieved, UClass serviceClass) {
        block13: {
            var5_4 = retrievingExpression.getUastParent();
            v0 = returnExpr = var5_4 instanceof UReturnExpression != false ? (UReturnExpression)var5_4 : null;
            var6_6 = v0 != null ? v0.getJumpTarget() : null;
            v1 = containingMethod = var6_6 instanceof UMethod != false ? (UMethod)var6_6 : null;
            if (containingMethod != null) {
                if (this.isNullable(containingMethod)) {
                    return null;
                }
                if (howServiceRetrieved == Service.Level.APP && this.isGetInstanceApplicationLevel(containingMethod)) {
                    return null;
                }
                if (howServiceRetrieved == Service.Level.PROJECT && this.isGetInstanceProjectLevel(containingMethod)) {
                    return null;
                }
            }
            var8_7 = serviceClass.getMethods();
            var10_9 = var8_7.length;
            for (var9_8 = 0; var9_8 < var10_9; ++var9_8) {
                it = var11_10 = var8_7[var9_8];
                $i$a$-find-SimplifiableServiceRetrievingInspection$findGetInstanceMethod$1 = false;
                v2 = containingMethod;
                if (it.getSourcePsi() == (v2 != null ? v2.getSourcePsi() : null)) ** GOTO lbl-1000
                switch (WhenMappings.$EnumSwitchMapping$0[howServiceRetrieved.ordinal()]) {
                    case 1: {
                        v3 = this.isGetInstanceApplicationLevel(it);
                        break;
                    }
                    case 2: {
                        v3 = this.isGetInstanceProjectLevel(it);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if (v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                v5 = var11_10;
                break block13;
            }
            v5 = var6_6 = null;
        }
        if (var6_6 != null) {
            method = var7_13 = var6_6;
            $i$a$-takeIf-SimplifiableServiceRetrievingInspection$findGetInstanceMethod$2 = false;
            v6 /* !! */  = Intrinsics.areEqual((Object)method.getReturnType(), (Object)retrievingExpression.getExpressionType()) ? var7_13 : null;
        } else {
            v6 /* !! */  = null;
        }
        return v6 /* !! */ ;
    }

    private final void registerProblem(UMethod replacementMethod, Service.Level howServiceRetrieved, ProblemsHolder holder, UExpression retrievingExpression) {
        Object object = UastUtils.getContainingUClass((UElement)((UElement)replacementMethod));
        if (object == null || (object = object.getQualifiedName()) == null) {
            return;
        }
        Object qualifiedServiceName = object;
        String string = StringUtil.getShortName((String)qualifiedServiceName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        String shortServiceName = string;
        MethodNameProvider methodNameProvider = (MethodNameProvider)MethodNameProviders.INSTANCE.forLanguage(retrievingExpression.getLang());
        Object object2 = methodNameProvider;
        if (object2 == null || (object2 = object2.getName(replacementMethod)) == null) {
            object2 = replacementMethod.getName();
        }
        Object methodName = object2;
        Object[] objectArray = new Object[]{shortServiceName, methodName};
        String message = DevKitBundle.message("inspection.simplifiable.service.retrieving.can.be.replaced.with", objectArray);
        ReplaceWithGetInstanceCallFix fix = new ReplaceWithGetInstanceCallFix((String)qualifiedServiceName, shortServiceName, (String)methodName, howServiceRetrieved);
        UExpression uExpression = retrievingExpression;
        if (uExpression instanceof UQualifiedReferenceExpression) {
            UReferenceExpression uReferenceExpression = (UReferenceExpression)retrievingExpression;
            Intrinsics.checkNotNull((Object)message);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UReferenceExpression)uReferenceExpression, (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
        } else if (uExpression instanceof UCallExpression) {
            UCallExpression uCallExpression = (UCallExpression)retrievingExpression;
            Intrinsics.checkNotNull((Object)message);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UCallExpression)uCallExpression, (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
        } else if (_Assertions.ENABLED) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGetInstanceProjectLevel(UMethod method) {
        UExpression uExpression;
        if (!this.isApplicableForGetInstance(method)) return false;
        if (method.getUastParameters().size() != 1) {
            return false;
        }
        UParameter param = (UParameter)method.getUastParameters().get(0);
        if (!Intrinsics.areEqual((Object)param.getType().getCanonicalText(), (Object)Project.class.getCanonicalName())) {
            return false;
        }
        UReturnExpression uReturnExpression = this.getReturnExpression(method);
        UExpression uExpression2 = uReturnExpression != null ? uReturnExpression.getReturnExpression() : null;
        if (!(uExpression2 instanceof UQualifiedReferenceExpression)) return false;
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)uExpression2;
        if (uQualifiedReferenceExpression == null) {
            return false;
        }
        UQualifiedReferenceExpression qualifiedRef = uQualifiedReferenceExpression;
        if (!this.getAllGetServiceMethods().uCallMatches((uExpression = qualifiedRef.getSelector()) instanceof UCallExpression ? (UCallExpression)uExpression : null)) return false;
        uExpression2 = qualifiedRef.getReceiver();
        USimpleNameReferenceExpression uSimpleNameReferenceExpression = uExpression2 instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)uExpression2 : null;
        if (!Intrinsics.areEqual((Object)(uSimpleNameReferenceExpression != null ? UResolvableKt.resolveToUElement((UResolvable)((UResolvable)uSimpleNameReferenceExpression)) : null), (Object)param)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGetInstanceApplicationLevel(UMethod method) {
        UExpression returnExpression;
        if (!this.isApplicableForGetInstance(method)) return false;
        if (!((Collection)method.getUastParameters()).isEmpty()) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        UReturnExpression uReturnExpression = this.getReturnExpression(method);
        Object object = returnExpression = uReturnExpression != null ? uReturnExpression.getReturnExpression() : null;
        if (returnExpression instanceof UQualifiedReferenceExpression) {
            UExpression uExpression;
            if (!this.getComponentManagerGetServiceMethods().uCallMatches((uExpression = ((UQualifiedReferenceExpression)returnExpression).getSelector()) instanceof UCallExpression ? (UCallExpression)uExpression : null)) return false;
            PsiType psiType = ((UQualifiedReferenceExpression)returnExpression).getReceiver().getExpressionType();
            if (psiType == null) return false;
            String[] stringArray = new String[]{Application.class.getCanonicalName()};
            if (!AnalysisUastUtilKt.isInheritorOf((PsiType)psiType, (String[])stringArray)) return false;
            return true;
        }
        if (!(returnExpression instanceof UCallExpression)) return false;
        boolean bl2 = this.getServiceKtFileMethods().uCallMatches((UCallExpression)returnExpression);
        return bl2;
    }

    private final boolean isApplicableForGetInstance(UMethod method) {
        return this.isStaticOrJvmStatic(method) && method.getVisibility() == UastVisibility.PUBLIC && !this.isNullable(method);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStaticOrJvmStatic(UMethod $this$isStaticOrJvmStatic) {
        if ($this$isStaticOrJvmStatic.isStatic()) return true;
        String string = JvmStatic.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        if ($this$isStaticOrJvmStatic.findAnnotation(string) == null) return false;
        return true;
    }

    private final boolean isNullable(UMethod $this$isNullable) {
        return $this$isNullable.getJavaPsi().hasAnnotation(Nullable.class.getCanonicalName());
    }

    private final UReturnExpression getReturnExpression(UMethod method) {
        UExpression uExpression = method.getUastBody();
        Object object = uExpression instanceof UBlockExpression ? (UBlockExpression)uExpression : null;
        UExpression uExpression2 = object != null && (object = object.getExpressions()) != null ? (UExpression)CollectionsKt.singleOrNull((List)object) : null;
        return uExpression2 instanceof UReturnExpression ? (UReturnExpression)uExpression2 : null;
    }

    public static final /* synthetic */ UMethod access$findGetInstanceMethod(SimplifiableServiceRetrievingInspection $this, UExpression retrievingExpression, Service.Level howServiceRetrieved, UClass serviceClass) {
        return $this.findGetInstanceMethod(retrievingExpression, howServiceRetrieved, serviceClass);
    }

    public static final /* synthetic */ void access$registerProblem(SimplifiableServiceRetrievingInspection $this, UMethod replacementMethod, Service.Level howServiceRetrieved, ProblemsHolder holder, UExpression retrievingExpression) {
        $this.registerProblem(replacementMethod, howServiceRetrieved, holder, retrievingExpression);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/SimplifiableServiceRetrievingInspection$ReplaceWithGetInstanceCallFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "qualifiedServiceName", "", "shortServiceName", "methodName", "howServiceRetrieved", "Lcom/intellij/openapi/components/Service$Level;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/Service$Level;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.devkit.core"})
    @SourceDebugExtension(value={"SMAP\nSimplifiableServiceRetrievingInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifiableServiceRetrievingInspection.kt\norg/jetbrains/idea/devkit/inspections/SimplifiableServiceRetrievingInspection$ReplaceWithGetInstanceCallFix\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,153:1\n18#2:154\n229#3,6:155\n236#3:162\n14#4:161\n*S KotlinDebug\n*F\n+ 1 SimplifiableServiceRetrievingInspection.kt\norg/jetbrains/idea/devkit/inspections/SimplifiableServiceRetrievingInspection$ReplaceWithGetInstanceCallFix\n*L\n119#1:154\n136#1:155,6\n136#1:162\n136#1:161\n*E\n"})
    private static final class ReplaceWithGetInstanceCallFix
    implements LocalQuickFix {
        @NotNull
        private final String qualifiedServiceName;
        @NotNull
        private final String shortServiceName;
        @NotNull
        private final String methodName;
        @NotNull
        private final Service.Level howServiceRetrieved;

        public ReplaceWithGetInstanceCallFix(@NotNull String qualifiedServiceName, @NotNull String shortServiceName, @NotNull String methodName, @NotNull Service.Level howServiceRetrieved) {
            Intrinsics.checkNotNullParameter((Object)qualifiedServiceName, (String)"qualifiedServiceName");
            Intrinsics.checkNotNullParameter((Object)shortServiceName, (String)"shortServiceName");
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)howServiceRetrieved, (String)"howServiceRetrieved");
            this.qualifiedServiceName = qualifiedServiceName;
            this.shortServiceName = shortServiceName;
            this.methodName = methodName;
            this.howServiceRetrieved = howServiceRetrieved;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.shortServiceName, this.methodName};
            String string = DevKitBundle.message("inspection.simplifiable.service.retrieving.replace.with", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            List list;
            UElement uElement;
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    uElement = UastContextKt.toUElement((PsiElement)descriptor.getPsiElement());
                    if (uElement == null) break block13;
                    UElement $this$getParentOfType_u24default$iv = uElement;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    uElement = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
                    if (uElement != null) break block14;
                }
                return;
            }
            UElement call = uElement;
            UExpression uExpression = SimplifiableServiceRetrievingInspectionKt.access$getRetrievingExpression((UCallExpression)call);
            if (uExpression == null) {
                return;
            }
            UExpression oldRetrievingExpression = uExpression;
            Language language = descriptor.getPsiElement().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage(language);
            if (uastCodeGenerationPlugin == null) {
                return;
            }
            UastCodeGenerationPlugin generationPlugin = uastCodeGenerationPlugin;
            UastElementFactory factory = generationPlugin.getElementFactory(project);
            if (this.howServiceRetrieved == Service.Level.APP) {
                list = CollectionsKt.emptyList();
            } else if (this.howServiceRetrieved == Service.Level.PROJECT && oldRetrievingExpression instanceof UQualifiedReferenceExpression) {
                list = CollectionsKt.listOf((Object)((UQualifiedReferenceExpression)oldRetrievingExpression).getReceiver());
            } else {
                return;
            }
            List parameters = list;
            PsiElement context = oldRetrievingExpression.getSourcePsi();
            UQualifiedReferenceExpression uQualifiedReferenceExpression = factory.createQualifiedReference(this.qualifiedServiceName, context);
            UReferenceExpression receiver = uQualifiedReferenceExpression != null ? (UReferenceExpression)uQualifiedReferenceExpression : (UReferenceExpression)factory.createSimpleReference(this.qualifiedServiceName, context);
            UCallExpression uCallExpression = factory.createCallExpression((UExpression)receiver, this.methodName, parameters, oldRetrievingExpression.getExpressionType(), UastCallKind.METHOD_CALL, null);
            if (uCallExpression == null) {
                return;
            }
            UCallExpression newCall = uCallExpression;
            UElement $this$replace$iv = (UElement)oldRetrievingExpression;
            boolean $i$f$replace = false;
            if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)((UElement)newCall))) {
                UElement cfr_ignored_0 = (UElement)newCall;
            } else {
                UastCodeGenerationPlugin uastCodeGenerationPlugin2 = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin2 = uastCodeGenerationPlugin2 != null ? uastCodeGenerationPlugin2.replace($this$replace$iv, (UElement)newCall, UCallExpression.class) : null;
                boolean bl = false;
                if (it$iv == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("failed replacing the " + $this$replace$iv + " with " + (UElement)newCall);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Service.Level.values().length];
            try {
                nArray[Service.Level.APP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Service.Level.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

