/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u00012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ+\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0015\u0010\u001a\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0010H\u0002J\f\u0010\"\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010#\u001a\u00020\f*\u00020\u0010H\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001e2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0014H\u0002J&\u0010-\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0\u001eH\u0002J\u0018\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\fH\u0003R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u001e\u0010&\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010%\u0012\u0004\b'\u0010\u0003\u00a8\u00063\u00b2\u0006\n\u0010\u001c\u001a\u00020\fX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/idea/devkit/inspections/StatefulEpInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "<init>", "()V", "checkField", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "field", "Lorg/jetbrains/uast/UField;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UField;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkClass", "aClass", "Lorg/jetbrains/uast/UClass;", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "holderClasses", "", "", "kotlin.jvm.PlatformType", "isHoldingElement", "type", "Lcom/intellij/psi/PsiType;", "elementClass", "getMessage", "Lorg/jetbrains/annotations/Nls;", "isQuickFix", "getCapturedPoints", "", "Lorg/jetbrains/idea/devkit/inspections/StatefulEpInspection$CapturedDescriptor;", "uClass", "canCapture", "isLocalOrAnonymousClass", "isLocalClass", "localQuickFixFqn", "Ljava/lang/String;", "projectComponentFqn", "getProjectComponentFqn$annotations", "findEpCandidates", "Lcom/intellij/psi/xml/XmlTag;", "project", "Lcom/intellij/openapi/project/Project;", "className", "isProjectFieldAllowed", "targets", "message", "what", "quickFix", "CapturedDescriptor", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nStatefulEpInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatefulEpInspection.kt\norg/jetbrains/idea/devkit/inspections/StatefulEpInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ExtensionLocator.kt\norg/jetbrains/idea/devkit/util/ExtensionLocatorKt\n*L\n1#1,174:1\n1755#2,3:175\n1755#2,3:184\n12574#3,2:178\n84#4,4:180\n*S KotlinDebug\n*F\n+ 1 StatefulEpInspection.kt\norg/jetbrains/idea/devkit/inspections/StatefulEpInspection\n*L\n80#1:175,3\n160#1:184,3\n81#1:178,2\n146#1:180,4\n*E\n"})
public final class StatefulEpInspection
extends DevKitUastInspectionBase {
    @NotNull
    private final List<String> holderClasses;
    private final String localQuickFixFqn;
    private final String projectComponentFqn;

    public StatefulEpInspection() {
        Object[] objectArray = new Class[]{UField.class, UClass.class};
        super((Class<? extends UElement>[])objectArray);
        objectArray = new String[]{Collection.class.getCanonicalName(), Map.class.getCanonicalName(), Ref.class.getCanonicalName()};
        this.holderClasses = CollectionsKt.listOf((Object[])objectArray);
        this.localQuickFixFqn = LocalQuickFix.class.getCanonicalName();
        this.projectComponentFqn = ProjectComponent.class.getCanonicalName();
    }

    @NotNull
    public ProblemDescriptor[] checkField(@NotNull UField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)field));
        if (uClass == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        UClass uClass2 = uClass;
        String string = uClass2.getJavaPsi().getName();
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String className = string;
        Lazy isQuickFix$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> StatefulEpInspection.checkField$lambda$0(uClass2, this));
        Project project = manager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Collection<XmlTag> targets = this.findEpCandidates(project, className);
        if (targets.isEmpty() && !StatefulEpInspection.checkField$lambda$1((Lazy<Boolean>)isQuickFix$delegate)) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder problemsHolder = DevKitUastInspectionBase.createProblemsHolder((UElement)field, manager, isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)problemsHolder, (String)"createProblemsHolder(...)");
        ProblemsHolder holder = problemsHolder;
        PsiType psiType = field.getType();
        String string2 = PsiElement.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalName(...)");
        if (this.isHoldingElement(psiType, string2)) {
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UDeclaration)((UDeclaration)field), (String)this.getMessage(StatefulEpInspection.checkField$lambda$1((Lazy<Boolean>)isQuickFix$delegate)), (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
            return problemDescriptorArray;
        }
        PsiType psiType2 = field.getType();
        String string3 = PsiReference.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCanonicalName(...)");
        if (this.isHoldingElement(psiType2, string3)) {
            UDeclaration uDeclaration = (UDeclaration)field;
            String string4 = PsiReference.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSimpleName(...)");
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UDeclaration)uDeclaration, (String)this.message(string4, StatefulEpInspection.checkField$lambda$1((Lazy<Boolean>)isQuickFix$delegate)), (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
            return problemDescriptorArray;
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)field.getType());
        if (psiClass == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiClass fieldTypeClass = psiClass;
        if (!this.isProjectFieldAllowed(field, uClass2, targets) && InheritanceUtil.isInheritor((PsiClass)fieldTypeClass, (String)Project.class.getCanonicalName())) {
            UDeclaration uDeclaration = (UDeclaration)field;
            String string5 = Project.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getSimpleName(...)");
            ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)holder, (UDeclaration)uDeclaration, (String)this.message(string5, StatefulEpInspection.checkField$lambda$1((Lazy<Boolean>)isQuickFix$delegate)), (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
            ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
            return problemDescriptorArray;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ProblemsHolder problemsHolder = DevKitUastInspectionBase.createProblemsHolder((UElement)aClass, manager, isOnTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)problemsHolder, (String)"createProblemsHolder(...)");
        ProblemsHolder holder = problemsHolder;
        if (this.canCapture(aClass) && InheritanceUtil.isInheritor((PsiClass)aClass.getJavaPsi(), (String)this.localQuickFixFqn)) {
            for (CapturedDescriptor capturedElement : this.getCapturedPoints(aClass)) {
                PsiElement capturedElementPsi;
                if (!(capturedElement.getResolved() instanceof UVariable)) continue;
                PsiType psiType = ((UVariable)capturedElement.getResolved()).getType();
                String string = PsiElement.class.getCanonicalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
                if (!this.isHoldingElement(psiType, string) || capturedElement.getReference().getSourcePsi() == null) continue;
                holder.registerProblem(capturedElementPsi, this.getMessage(true), new LocalQuickFix[0]);
            }
        }
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
        return problemDescriptorArray;
    }

    private final boolean isHoldingElement(PsiType type, String elementClass) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (psiClass == null) {
            return false;
        }
        PsiClass typeClass = psiClass;
        if (InheritanceUtil.isInheritor((PsiClass)typeClass, (String)elementClass)) {
            return true;
        }
        PsiType[] psiTypeArray = type instanceof PsiClassType ? (PsiType[])type : null;
        if (psiTypeArray == null || (psiTypeArray = psiTypeArray.getParameters()) == null) {
            return false;
        }
        PsiType[] typeArguments = psiTypeArray;
        if (!(typeArguments.length == 0)) {
            boolean bl;
            boolean $i$f$any;
            PsiType[] $this$any$iv;
            block10: {
                $this$any$iv = (PsiType[])this.holderClasses;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : $this$any$iv) {
                        String it = (String)t;
                        boolean bl2 = false;
                        if (!InheritanceUtil.isInheritor((PsiClass)typeClass, (String)it)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                boolean bl2;
                block11: {
                    $this$any$iv = typeArguments;
                    $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        PsiType actualPsiType;
                        PsiType actualType;
                        PsiType element$iv;
                        PsiType it = element$iv = $this$any$iv[i];
                        boolean bl4 = false;
                        PsiWildcardType psiWildcardType = it instanceof PsiWildcardType ? (PsiWildcardType)it : null;
                        Object typeBound = psiWildcardType != null ? psiWildcardType.getBound() : null;
                        PsiType psiType = typeBound;
                        if (psiType == null) {
                            psiType = it;
                        }
                        if (!((actualType = psiType) == null ? false : this.isHoldingElement(actualPsiType, elementClass))) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
                return bl2;
            }
        }
        return false;
    }

    private final String getMessage(boolean isQuickFix) {
        Object message = DevKitBundle.message("inspections.stateful.extension.point.leak.psi.element", new Object[0]);
        if (isQuickFix) {
            message = (String)message + ". " + DevKitBundle.message("inspections.stateful.extension.point.leak.psi.element.quick.fix", new Object[0]);
        }
        String string = message;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final Collection<CapturedDescriptor> getCapturedPoints(UClass uClass) {
        List capturedPoints = new ArrayList();
        if (this.canCapture(uClass)) {
            Object object;
            if (uClass instanceof UAnonymousClass) {
                PsiClass psiClass = uClass.getJavaPsi();
                PsiAnonymousClass psiAnonymousClass = psiClass instanceof PsiAnonymousClass ? (PsiAnonymousClass)psiClass : null;
                object = psiAnonymousClass != null ? psiAnonymousClass.getArgumentList() : null;
            } else {
                object = null;
            }
            PsiExpressionList argumentList = object;
            uClass.accept((UastVisitor)new AbstractUastVisitor(argumentList, uClass, capturedPoints){
                final /* synthetic */ PsiExpressionList $argumentList;
                final /* synthetic */ UClass $uClass;
                final /* synthetic */ List<CapturedDescriptor> $capturedPoints;
                {
                    this.$argumentList = $argumentList;
                    this.$uClass = $uClass;
                    this.$capturedPoints = $capturedPoints;
                }

                public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    PsiElement psiElement = node.getSourcePsi();
                    if (psiElement == null) {
                        return super.visitSimpleNameReferenceExpression(node);
                    }
                    PsiElement expressionPsi = psiElement;
                    if (this.$argumentList == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)this.$argumentList), (PsiElement)expressionPsi, (boolean)true)) {
                        UResolvable $this$resolveToUElementOfType$iv = (UResolvable)node;
                        boolean $i$f$resolveToUElementOfType = false;
                        UElement uElement = UResolvableKt.resolveToUElement((UResolvable)$this$resolveToUElementOfType$iv);
                        if (!(uElement instanceof UVariable)) {
                            uElement = null;
                        }
                        UVariable uVariable = (UVariable)((UElement)((UVariable)uElement));
                        if (uVariable == null) {
                            return super.visitSimpleNameReferenceExpression(node);
                        }
                        UVariable refElement = uVariable;
                        PsiElement $this$getUastParentOfType_u24default$iv = (PsiElement)refElement;
                        boolean strict$iv = false;
                        boolean $i$f$getUastParentOfType = false;
                        UClass uClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
                        if (uClass == null) {
                            return super.visitSimpleNameReferenceExpression(node);
                        }
                        UClass containingClass = uClass;
                        if (UastUtils.isPsiAncestor((UElement)((UElement)containingClass), (UElement)((UElement)this.$uClass), (boolean)true)) {
                            this.$capturedPoints.add(new CapturedDescriptor((UElement)node, (UElement)refElement));
                        }
                    }
                    return super.visitSimpleNameReferenceExpression(node);
                }
            });
        }
        return capturedPoints;
    }

    private final boolean canCapture(UClass uClass) {
        return this.isLocalOrAnonymousClass(uClass);
    }

    private final boolean isLocalOrAnonymousClass(UClass $this$isLocalOrAnonymousClass) {
        return $this$isLocalOrAnonymousClass instanceof UAnonymousClass || this.isLocalClass($this$isLocalOrAnonymousClass);
    }

    private final boolean isLocalClass(UClass $this$isLocalClass) {
        UElement parent = $this$isLocalClass.getUastParent();
        if (parent instanceof UDeclarationsExpression && ((UDeclarationsExpression)parent).getUastParent() instanceof UBlockExpression) {
            return true;
        }
        UClass uClass = parent instanceof UClass ? (UClass)parent : null;
        return uClass != null ? this.isLocalOrAnonymousClass(uClass) : false;
    }

    private static /* synthetic */ void getProjectComponentFqn$annotations() {
    }

    private final Collection<XmlTag> findEpCandidates(Project project, String className) {
        List result = Collections.synchronizedList((List)new SmartList());
        boolean $i$f$processExtensionsByClassName = false;
        ExtensionLocatorKt.processExtensionDeclarations$default(className, project, false, (Function2)new Function2<Extension, XmlTag, Boolean>(className, result){
            final /* synthetic */ String $className$inlined;
            final /* synthetic */ List $result$inlined;
            {
                this.$className$inlined = string;
                this.$result$inlined = list;
            }

            public final Boolean invoke(Extension extension, XmlTag tag) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint != null) {
                    ExtensionPoint it = extensionPoint;
                    boolean bl2 = false;
                    XmlTag tag2 = tag;
                    boolean bl3 = false;
                    String string = tag2.getAttributeValue("forClass");
                    if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)this.$className$inlined, (boolean)false, (int)2, null) : false)) {
                        this.$result$inlined.add(tag2);
                    }
                    bl = true;
                } else {
                    bl = true;
                }
                return bl;
            }
        }, 4, null);
        Intrinsics.checkNotNull(result);
        return result;
    }

    private final boolean isProjectFieldAllowed(UField field, UClass uClass, Collection<? extends XmlTag> targets) {
        boolean bl;
        block4: {
            if (field.isFinal()) {
                return true;
            }
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String name;
                    XmlTag candidate = (XmlTag)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)candidate.getName(), (String)"getName(...)");
                    if (!(Intrinsics.areEqual((Object)"projectService", (Object)name) || Intrinsics.areEqual((Object)"projectConfigurable", (Object)name))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl || InheritanceUtil.isInheritor((PsiClass)uClass.getJavaPsi(), (String)this.projectComponentFqn);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private final String message(String what, boolean quickFix) {
        if (quickFix) {
            Object[] objectArray = new Object[]{what};
            String string = DevKitBundle.message("inspections.stateful.extension.point.do.not.use.in.quick.fix", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Object[] objectArray = new Object[]{what};
        String string = DevKitBundle.message("inspections.stateful.extension.point.do.not.use.in.extension", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final boolean checkField$lambda$0(UClass $uClass, StatefulEpInspection this$0) {
        return InheritanceUtil.isInheritor((PsiClass)$uClass.getJavaPsi(), (String)this$0.localQuickFixFqn);
    }

    private static final boolean checkField$lambda$1(Lazy<Boolean> $isQuickFix$delegate) {
        Lazy<Boolean> lazy = $isQuickFix$delegate;
        return (Boolean)lazy.getValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/inspections/StatefulEpInspection$CapturedDescriptor;", "", "reference", "Lorg/jetbrains/uast/UElement;", "resolved", "<init>", "(Lorg/jetbrains/uast/UElement;Lorg/jetbrains/uast/UElement;)V", "getReference", "()Lorg/jetbrains/uast/UElement;", "getResolved", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.devkit.core"})
    private static final class CapturedDescriptor {
        @NotNull
        private final UElement reference;
        @NotNull
        private final UElement resolved;

        public CapturedDescriptor(@NotNull UElement reference, @NotNull UElement resolved) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
            this.reference = reference;
            this.resolved = resolved;
        }

        @NotNull
        public final UElement getReference() {
            return this.reference;
        }

        @NotNull
        public final UElement getResolved() {
            return this.resolved;
        }

        @NotNull
        public final UElement component1() {
            return this.reference;
        }

        @NotNull
        public final UElement component2() {
            return this.resolved;
        }

        @NotNull
        public final CapturedDescriptor copy(@NotNull UElement reference, @NotNull UElement resolved) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)resolved, (String)"resolved");
            return new CapturedDescriptor(reference, resolved);
        }

        public static /* synthetic */ CapturedDescriptor copy$default(CapturedDescriptor capturedDescriptor, UElement uElement, UElement uElement2, int n, Object object) {
            if ((n & 1) != 0) {
                uElement = capturedDescriptor.reference;
            }
            if ((n & 2) != 0) {
                uElement2 = capturedDescriptor.resolved;
            }
            return capturedDescriptor.copy(uElement, uElement2);
        }

        @NotNull
        public String toString() {
            return "CapturedDescriptor(reference=" + this.reference + ", resolved=" + this.resolved + ")";
        }

        public int hashCode() {
            int result = this.reference.hashCode();
            result = result * 31 + this.resolved.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CapturedDescriptor)) {
                return false;
            }
            CapturedDescriptor capturedDescriptor = (CapturedDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.reference, (Object)capturedDescriptor.reference)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.resolved, (Object)capturedDescriptor.resolved);
        }
    }
}

