/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.StaticInitializationInExtensionsInspection;
import org.jetbrains.idea.devkit.inspections.StaticInitializationInExtensionsVisitorProvider;
import org.jetbrains.idea.devkit.inspections.StaticInitializationInExtensionsVisitorProviders;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/inspections/StaticInitializationInExtensionsInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "<init>", "()V", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getUastVisitor", "intellij.devkit.core"})
public final class StaticInitializationInExtensionsInspection
extends DevKitUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        StaticInitializationInExtensionsVisitorProvider visitorProvider = (StaticInitializationInExtensionsVisitorProvider)StaticInitializationInExtensionsVisitorProviders.INSTANCE.forLanguage(holder.getFile().getLanguage());
        StaticInitializationInExtensionsVisitorProvider staticInitializationInExtensionsVisitorProvider = visitorProvider;
        if (staticInitializationInExtensionsVisitorProvider == null || (staticInitializationInExtensionsVisitorProvider = staticInitializationInExtensionsVisitorProvider.getVisitor(holder)) == null) {
            staticInitializationInExtensionsVisitorProvider = this.getUastVisitor(holder);
        }
        return staticInitializationInExtensionsVisitorProvider;
    }

    private final PsiElementVisitor getUastVisitor(ProblemsHolder holder) {
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UClassInitializer.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public boolean visitInitializer(UClassInitializer node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!node.isStatic()) {
                    return true;
                }
                UElement $this$getParentOfType_u24default$iv = (UElement)node;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                UClass uClass = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
                if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
                    return true;
                }
                UClass psiClass = uClass;
                if (!ExtensionUtil.isExtensionPointImplementationCandidate((PsiClass)psiClass)) {
                    return true;
                }
                if (!ExtensionUtil.INSTANCE.isInstantiatedExtension((PsiClass)psiClass, (Function1<? super Extension, Boolean>)((Function1)getUastVisitor.1::visitInitializer$lambda$0))) {
                    return true;
                }
                PsiElement psiElement = node.getJavaPsi();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                PsiModifierList psiModifierList = ((PsiModifierListOwner)psiElement).getModifierList();
                Intrinsics.checkNotNull((Object)psiModifierList);
                PsiModifierList modifierList = psiModifierList;
                PsiElement psiElement2 = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)"static");
                Intrinsics.checkNotNull((Object)psiElement2);
                PsiElement anchor = psiElement2;
                this.$holder.registerProblem(anchor, DevKitBundle.message("inspections.static.initialization.in.extensions.message", new Object[0]), new LocalQuickFix[0]);
                return true;
            }

            private static final boolean visitInitializer$lambda$0(Extension it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExtensionUtil.INSTANCE.hasServiceBeanFqn(it);
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }
}

