/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.InlayHintsCollector;
import com.intellij.codeInsight.hints.declarative.InlayHintsProvider;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.SharedBypassCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.ThreadingStatus;
import org.jetbrains.idea.devkit.inspections.ThreadingStatusKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ThreadingInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsProvider;", "<init>", "()V", "createCollector", "Lcom/intellij/codeInsight/hints/declarative/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ThreadingCollector", "intellij.devkit.core"})
public final class ThreadingInlayHintsProvider
implements InlayHintsProvider {
    @Nullable
    public InlayHintsCollector createCollector(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!DevKitInspectionUtil.isAllowedIncludingTestSources(file)) {
            return null;
        }
        if (!IntelliJProjectUtil.isIntelliJPlatformProject((Project)file.getProject()) && !Registry.Companion.is("devkit.inlay.threading")) {
            return null;
        }
        if (JavaPsiFacade.getInstance((Project)file.getProject()).findClass(RequiresEdt.class.getCanonicalName(), file.getResolveScope()) == null) {
            return null;
        }
        return (InlayHintsCollector)new ThreadingCollector();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ThreadingInlayHintsProvider$ThreadingCollector;", "Lcom/intellij/codeInsight/hints/declarative/SharedBypassCollector;", "<init>", "()V", "collectFromElement", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "intellij.devkit.core"})
    @SourceDebugExtension(value={"SMAP\nThreadingInlayHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadingInlayHintsProvider.kt\norg/jetbrains/idea/devkit/inspections/ThreadingInlayHintsProvider$ThreadingCollector\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n19#2:48\n1863#3,2:49\n*S KotlinDebug\n*F\n+ 1 ThreadingInlayHintsProvider.kt\norg/jetbrains/idea/devkit/inspections/ThreadingInlayHintsProvider$ThreadingCollector\n*L\n34#1:48\n36#1:49,2\n*E\n"})
    private static final class ThreadingCollector
    implements SharedBypassCollector {
        public void collectFromElement(@NotNull PsiElement element, @NotNull InlayTreeSink sink) {
            UElement uElement;
            UCallExpression uCallExpression;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    UCallExpression uCallExpression2 = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
                    if (uCallExpression2 == null) {
                        return;
                    }
                    uCallExpression = uCallExpression2;
                    uElement = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)uCallExpression));
                    if (uElement == null) break block7;
                    UElement $this$asSafely$iv = uElement;
                    boolean $i$f$asSafely = false;
                    UElement uElement2 = $this$asSafely$iv;
                    if (!(uElement2 instanceof UMethod)) {
                        uElement2 = null;
                    }
                    if ((uElement = (UMethod)uElement2) != null) break block8;
                }
                return;
            }
            UElement resolvedMethod = uElement;
            Iterable $this$forEach$iv = ThreadingStatusKt.getThreadingStatuses((UMethod)resolvedMethod);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThreadingStatus threadingStatus = (ThreadingStatus)((Object)element$iv);
                boolean bl = false;
                UIdentifier uIdentifier = uCallExpression.getMethodIdentifier();
                if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null || (uIdentifier = uIdentifier.getTextRange()) == null) {
                    continue;
                }
                int offset = uIdentifier.getStartOffset();
                InlayTreeSink.addPresentation$default((InlayTreeSink)sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(offset, true, 0, 4, null)), null, (String)("@" + threadingStatus.getDisplayName()), (HintFormat)HintFormat.Companion.getDefault(), arg_0 -> ThreadingCollector.collectFromElement$lambda$1$lambda$0(threadingStatus, arg_0), (int)2, null);
            }
        }

        private static final Unit collectFromElement$lambda$1$lambda$0(ThreadingStatus $threadingStatus, PresentationTreeBuilder $this$addPresentation) {
            Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
            PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)("@" + $threadingStatus.getShortName()), null, (int)2, null);
            return Unit.INSTANCE;
        }
    }
}

