/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.uast.UastHintedVisitorAdapter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.references.PluginConfigReference;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@VisibleForTesting
@ApiStatus.Internal
public final class UnresolvedPluginConfigReferenceInspection
extends DevKitUastInspectionBase {
    private final Class<? extends UElement>[] HINTS = new Class[]{UInjectionHost.class};

    @Override
    protected PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnresolvedPluginConfigReferenceInspection.$$$reportNull$$$0(0);
        }
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitPolyadicExpression(@NotNull UPolyadicExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(node instanceof UInjectionHost)) {
                    return true;
                }
                UInjectionHost uInjectionHost = (UInjectionHost)node;
                this.processInjectionHost(uInjectionHost);
                return super.visitPolyadicExpression(node);
            }

            public boolean visitLiteralExpression(@NotNull ULiteralExpression uLiteralExpression) {
                if (uLiteralExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(uLiteralExpression instanceof UInjectionHost)) {
                    return true;
                }
                UInjectionHost uInjectionHost = (UInjectionHost)uLiteralExpression;
                this.processInjectionHost(uInjectionHost);
                return super.visitExpression((UExpression)uLiteralExpression);
            }

            private void processInjectionHost(@NotNull UInjectionHost node) {
                PsiElement element;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((element = node.getSourcePsi()) == null) {
                    return;
                }
                for (PsiReference reference : element.getReferences()) {
                    if (!(reference instanceof PluginConfigReference) || reference.isSoft()) continue;
                    if (reference instanceof PsiPolyVariantReference) {
                        PsiPolyVariantReference polyVariantReference = (PsiPolyVariantReference)reference;
                        if (polyVariantReference.multiResolve(false).length != 0) continue;
                        holder.registerProblem(reference);
                        continue;
                    }
                    if (reference.resolve() != null) continue;
                    holder.registerProblem(reference);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uLiteralExpression";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/UnresolvedPluginConfigReferenceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPolyadicExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processInjectionHost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Class[])this.HINTS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/UnresolvedPluginConfigReferenceInspection", "buildInternalVisitor"));
    }
}

