/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

final class UnspecifiedActionsPlaceInspection
extends DevKitUastInspectionBase {
    private static final boolean SKIP_CHILDREN = true;
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class};
    public static final String CREATE_ACTION_TOOLBAR_METHOD_NAME = "createActionToolbar";
    public static final String CREATE_ACTION_POPUP_MENU_METHOD_NAME = "createActionPopupMenu";

    UnspecifiedActionsPlaceInspection() {
    }

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnspecifiedActionsPlaceInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!node.isMethodNameOneOf(List.of(UnspecifiedActionsPlaceInspection.CREATE_ACTION_TOOLBAR_METHOD_NAME, UnspecifiedActionsPlaceInspection.CREATE_ACTION_POPUP_MENU_METHOD_NAME))) {
                    return true;
                }
                PsiMethod method = node.resolve();
                if (method != null && UnspecifiedActionsPlaceInspection.requiresSpecifiedActionPlace(method) && node.getValueArgumentCount() > 0) {
                    String methodName = method.getName();
                    UExpression parameter = node.getArgumentForParameter(0);
                    if (parameter != null && UnspecifiedActionsPlaceInspection.actionPlaceIsUnspecified(parameter)) {
                        PsiElement reportedElement = parameter.getSourcePsi();
                        if (reportedElement == null) {
                            return true;
                        }
                        String messageKey = UnspecifiedActionsPlaceInspection.CREATE_ACTION_TOOLBAR_METHOD_NAME.equals(methodName) ? "inspections.unspecified.actions.place.toolbar" : "inspections.unspecified.actions.place.popup.menu";
                        holder.registerProblem(reportedElement, DevKitBundle.message(messageKey, new Object[0]), new LocalQuickFix[0]);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/devkit/inspections/UnspecifiedActionsPlaceInspection$1", "visitCallExpression"));
            }
        }, (Class[])HINTS);
        if (psiElementVisitor == null) {
            UnspecifiedActionsPlaceInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static boolean requiresSpecifiedActionPlace(@NotNull PsiMethod method) {
        PsiType type;
        PsiParameter[] parameters;
        PsiClass aClass;
        if (method == null) {
            UnspecifiedActionsPlaceInspection.$$$reportNull$$$0(2);
        }
        return (aClass = method.getContainingClass()) != null && ActionManager.class.getName().equals(aClass.getQualifiedName()) && (parameters = method.getParameterList().getParameters()).length > 0 && parameters[0].getType() instanceof PsiClassType && Objects.equals(((PsiClassType)(type = parameters[0].getType())).getClassName(), "String") && "java.lang.String".equals(type.getCanonicalText(false));
    }

    private static boolean actionPlaceIsUnspecified(UExpression parameter) {
        String stringValue;
        Object evaluatedExpression = parameter.evaluate();
        return evaluatedExpression instanceof String && ((stringValue = (String)evaluatedExpression).isEmpty() || "unknown".equals(stringValue));
    }

    @NotNull
    public String getShortName() {
        return "UnspecifiedActionsPlace";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/UnspecifiedActionsPlaceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/UnspecifiedActionsPlaceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requiresSpecifiedActionPlace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

