/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@VisibleForTesting
@ApiStatus.Internal
public final class UseGrayInspection
extends DevKitUastInspectionBase
implements CleanupLocalInspectionTool {
    private static final String AWT_COLOR_CLASS_NAME = Color.class.getName();
    private static final String GRAY_CLASS_NAME = Gray.class.getName();
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class};

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseGrayInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                PsiElement sourcePsi;
                Integer grayValue;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (UseGrayInspection.isAwtRgbColorConstructor(expression) && (grayValue = UseGrayInspection.getGrayValue(expression)) != null && (sourcePsi = expression.getSourcePsi()) != null && DevKitInspectionUtil.isClassAvailable(holder, GRAY_CLASS_NAME)) {
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.gray.awt.color.used.name", new Object[0]), new LocalQuickFix[]{new ConvertToGrayQuickFix(grayValue)});
                }
                return super.visitCallExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/idea/devkit/inspections/UseGrayInspection$1", "visitCallExpression"));
            }
        }, (Class[])HINTS);
        if (psiElementVisitor == null) {
            UseGrayInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static boolean isAwtRgbColorConstructor(@NotNull UCallExpression call) {
        List callParams;
        if (call == null) {
            UseGrayInspection.$$$reportNull$$$0(2);
        }
        if ((callParams = call.getValueArguments()).size() != 3) {
            return false;
        }
        PsiMethod constructor = call.resolve();
        if (constructor == null || !constructor.isConstructor()) {
            return false;
        }
        PsiClass constructorClass = constructor.getContainingClass();
        if (constructorClass == null) {
            return false;
        }
        return AWT_COLOR_CLASS_NAME.equals(constructorClass.getQualifiedName());
    }

    @Nullable
    private static Integer getGrayValue(@NotNull UCallExpression constructorCall) {
        List constructorParams;
        UExpression redParam;
        Integer red;
        if (constructorCall == null) {
            UseGrayInspection.$$$reportNull$$$0(3);
        }
        if ((red = UseGrayInspection.evaluateColorValue(redParam = (UExpression)(constructorParams = constructorCall.getValueArguments()).get(0))) == null) {
            return null;
        }
        UExpression greenParam = (UExpression)constructorParams.get(1);
        UExpression blueParam = (UExpression)constructorParams.get(2);
        return 0 <= red && red < 256 && red.equals(UseGrayInspection.evaluateColorValue(greenParam)) && red.equals(UseGrayInspection.evaluateColorValue(blueParam)) ? red : null;
    }

    @Nullable
    private static Integer evaluateColorValue(@NotNull UExpression expression) {
        Object evaluatedExpression;
        if (expression == null) {
            UseGrayInspection.$$$reportNull$$$0(4);
        }
        if ((evaluatedExpression = expression.evaluate()) instanceof Integer) {
            Integer value = (Integer)evaluatedExpression;
            return value;
        }
        return null;
    }

    @NotNull
    public String getShortName() {
        return "InspectionUsingGrayColors";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/UseGrayInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/UseGrayInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAwtRgbColorConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGrayValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateColorValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ConvertToGrayQuickFix
    implements LocalQuickFix {
        private final int myGrayValue;

        private ConvertToGrayQuickFix(int grayValue) {
            this.myGrayValue = grayValue;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = DevKitBundle.message("inspections.use.gray.fix.convert.name", this.myGrayValue);
            if (string == null) {
                ConvertToGrayQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.use.gray.fix.convert.family.name", new Object[0]);
            if (string == null) {
                ConvertToGrayQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String grayConstant;
            PsiElement element;
            UCallExpression awtGrayColorConstructor;
            if (project == null) {
                ConvertToGrayQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ConvertToGrayQuickFix.$$$reportNull$$$0(3);
            }
            if ((awtGrayColorConstructor = (UCallExpression)UastContextKt.toUElement((PsiElement)(element = descriptor.getPsiElement()), UCallExpression.class)) == null) {
                return;
            }
            UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)element.getLanguage());
            if (generationPlugin == null) {
                return;
            }
            UastElementFactory pluginElementFactory = generationPlugin.getElementFactory(project);
            UQualifiedReferenceExpression grayConstantReference = pluginElementFactory.createQualifiedReference(grayConstant = Gray.class.getName() + "._" + this.myGrayValue, element);
            if (grayConstantReference == null) {
                return;
            }
            generationPlugin.replace((UElement)awtGrayColorConstructor, (UElement)grayConstantReference, UQualifiedReferenceExpression.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/UseGrayInspection$ConvertToGrayQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/UseGrayInspection$ConvertToGrayQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

