/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

final class FileEqualsUsageInspection
extends DevKitUastInspectionBase {
    private static final Set<String> METHOD_NAMES = Set.of("equals", "compareTo", "hashCode");
    private static final Set<UastBinaryOperator> SUPPORTED_OPERATORS = Set.of(UastBinaryOperator.EQUALS, UastBinaryOperator.NOT_EQUALS, UastBinaryOperator.GREATER, UastBinaryOperator.GREATER_OR_EQUALS, UastBinaryOperator.LESS, UastBinaryOperator.LESS_OR_EQUALS);
    private static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class, UBinaryExpression.class};

    FileEqualsUsageInspection() {
    }

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileEqualsUsageInspection.inspectCallExpression(node, holder);
                return true;
            }

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileEqualsUsageInspection.inspectBinaryExpression(node, holder);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBinaryExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Class[])HINTS);
        if (psiElementVisitor == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static void inspectCallExpression(@NotNull UCallExpression node, @NotNull ProblemsHolder holder) {
        if (node == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(3);
        }
        if (!node.isMethodNameOneOf(METHOD_NAMES)) {
            return;
        }
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        FileEqualsUsageInspection.inspectMethodCall(psiMethod, holder, () -> {
            UIdentifier identifier = node.getMethodIdentifier();
            if (identifier == null) {
                return null;
            }
            return identifier.getSourcePsi();
        });
    }

    private static void inspectMethodCall(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Supplier<PsiElement> anchorSupplier) {
        PsiClass containingClass;
        if (psiMethod == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(5);
        }
        if (anchorSupplier == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(6);
        }
        if ((containingClass = psiMethod.getContainingClass()) == null) {
            return;
        }
        if (!"java.io.File".equals(containingClass.getQualifiedName())) {
            return;
        }
        if (!DevKitInspectionUtil.isClassAvailable(holder, FileUtil.class.getName())) {
            return;
        }
        PsiElement anchor = anchorSupplier.get();
        if (anchor == null) {
            return;
        }
        holder.registerProblem(anchor, DevKitBundle.message("inspections.file.equals.method", new Object[0]), new LocalQuickFix[0]);
    }

    private static void inspectBinaryExpression(@NotNull UBinaryExpression node, @NotNull ProblemsHolder holder) {
        if (node == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(8);
        }
        if (!SUPPORTED_OPERATORS.contains(node.getOperator())) {
            return;
        }
        if (FileEqualsUsageInspection.isNull(node.getLeftOperand()) || FileEqualsUsageInspection.isNull(node.getRightOperand())) {
            return;
        }
        PsiMethod psiMethod = node.resolveOperator();
        if (psiMethod == null) {
            return;
        }
        if (!METHOD_NAMES.contains(psiMethod.getName())) {
            return;
        }
        FileEqualsUsageInspection.inspectMethodCall(psiMethod, holder, () -> {
            UIdentifier identifier = node.getOperatorIdentifier();
            return identifier != null ? identifier.getSourcePsi() : null;
        });
    }

    private static boolean isNull(UExpression expression) {
        if (expression instanceof ULiteralExpression) {
            ULiteralExpression literalExpression = (ULiteralExpression)expression;
            return literalExpression.isNull();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectCallExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inspectMethodCall";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "inspectBinaryExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

