/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

@VisibleForTesting
@ApiStatus.Internal
public final class UnsafeReturnStatementVisitorInspection
extends DevKitUastInspectionBase {
    @NonNls
    private static final String BASE_WALKING_VISITOR_NAME = JavaRecursiveElementWalkingVisitor.class.getName();
    @NonNls
    private static final String BASE_VISITOR_NAME = JavaRecursiveElementVisitor.class.getName();
    @NonNls
    private static final String EMPTY_VISIT_LAMBDA_METHOD = "public void visitLambdaExpression(PsiLambdaExpression expression) {}";
    @NonNls
    private static final String EMPTY_VISIT_CLASS_METHOD = "public void visitClass(PsiClass aClass) {}";

    public UnsafeReturnStatementVisitorInspection() {
        super(UClass.class);
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            UnsafeReturnStatementVisitorInspection.$$$reportNull$$$0(0);
        }
        return super.isAllowed(holder) && DevKitInspectionUtil.isClassAvailable(holder, BASE_VISITOR_NAME);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClass aClass;
        if (uClass == null) {
            UnsafeReturnStatementVisitorInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            UnsafeReturnStatementVisitorInspection.$$$reportNull$$$0(2);
        }
        if ((InheritanceUtil.isInheritor((PsiClass)(aClass = uClass.getJavaPsi()), (boolean)true, (String)BASE_WALKING_VISITOR_NAME) || InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_VISITOR_NAME)) && UnsafeReturnStatementVisitorInspection.hasMethod(uClass, "visitReturnStatement", PsiReturnStatement.class.getName())) {
            boolean visitClassMissing;
            boolean visitLambdaMissing = !UnsafeReturnStatementVisitorInspection.hasMethod(uClass, "visitLambdaExpression", PsiLambdaExpression.class.getName());
            boolean bl = visitClassMissing = !UnsafeReturnStatementVisitorInspection.hasMethod(uClass, "visitClass", PsiClass.class.getName());
            if (visitLambdaMissing || visitClassMissing) {
                ProblemsHolder holder = UnsafeReturnStatementVisitorInspection.createProblemsHolder((UElement)uClass, manager, isOnTheFly);
                ProblemHolderUtilKt.registerUProblem((ProblemsHolder)holder, (UDeclaration)uClass, (String)DevKitBundle.message("inspections.unsafe.return.message", new Object[0]), (LocalQuickFix[])UnsafeReturnStatementVisitorInspection.createFixes(uClass, visitLambdaMissing, visitClassMissing));
                return holder.getResultsArray();
            }
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static boolean hasMethod(UClass uClass, String visitMethodName, String argumentType) {
        return ContainerUtil.exists((Object[])uClass.getMethods(), uMethod -> visitMethodName.equals(uMethod.getName()) && UnsafeReturnStatementVisitorInspection.hasSingleParameterOfType(uMethod, argumentType));
    }

    private static boolean hasSingleParameterOfType(UMethod uMethod, String argumentType) {
        List parameters = uMethod.getUastParameters();
        return parameters.size() == 1 && ((UParameter)parameters.get(0)).getType().equalsToText(argumentType);
    }

    private static LocalQuickFix[] createFixes(@NotNull UClass uClass, boolean visitLambdaMissing, boolean visitClassMissing) {
        String[] methodsToInsert;
        String fixName;
        if (uClass == null) {
            UnsafeReturnStatementVisitorInspection.$$$reportNull$$$0(3);
        }
        if (!uClass.getLang().is((Language)JavaLanguage.INSTANCE)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (visitLambdaMissing && visitClassMissing) {
            fixName = DevKitBundle.message("inspections.unsafe.return.insert.visit.lambda.expression.and.class.methods", new Object[0]);
            methodsToInsert = new String[]{EMPTY_VISIT_LAMBDA_METHOD, EMPTY_VISIT_CLASS_METHOD};
        } else if (visitLambdaMissing) {
            fixName = DevKitBundle.message("inspections.unsafe.return.insert.visit.lambda.expression", new Object[0]);
            methodsToInsert = new String[]{EMPTY_VISIT_LAMBDA_METHOD};
        } else {
            fixName = DevKitBundle.message("inspections.unsafe.return.insert.visit.class.method", new Object[0]);
            methodsToInsert = new String[]{EMPTY_VISIT_CLASS_METHOD};
        }
        return new LocalQuickFix[]{new MySkipVisitFix(fixName, methodsToInsert)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MySkipVisitFix
    implements LocalQuickFix {
        @IntentionName
        private final String myName;
        private final String[] myMethods;

        MySkipVisitFix(@IntentionName String name, String[] methods) {
            this.myName = name;
            this.myMethods = methods;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MySkipVisitFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.unsafe.return.insert.family.name", new Object[0]);
            if (string == null) {
                MySkipVisitFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass aClass;
            if (project == null) {
                MySkipVisitFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MySkipVisitFix.$$$reportNull$$$0(3);
            }
            if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class)) != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                for (String methodText : this.myMethods) {
                    PsiMethod method = factory.createMethodFromText(methodText, (PsiElement)aClass);
                    PsiMethod overridden = aClass.findMethodBySignature(method, true);
                    if (overridden != null) {
                        OverrideImplementUtil.annotateOnOverrideImplement((PsiMethod)method, (PsiClass)aClass, (PsiMethod)overridden);
                    }
                    aClass.add((PsiElement)method);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection$MySkipVisitFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection$MySkipVisitFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

