/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.internal.AbstractUseDPIAwareBorderInspection;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastCallKind;

final class UseDPIAwareInsetsInspection
extends AbstractUseDPIAwareBorderInspection {
    private static final String AWT_INSETS_CLASS_NAME = Insets.class.getName();
    private static final String JB_INSETS_CLASS_NAME = JBInsets.class.getName();
    private static final String JB_UI_CLASS_NAME = JBUI.class.getName();

    UseDPIAwareInsetsInspection() {
    }

    @Override
    protected boolean isAllowedConstructorCall(@NotNull UCallExpression expression) {
        UCallExpression containingCall;
        UElement parent;
        if (expression == null) {
            UseDPIAwareInsetsInspection.$$$reportNull$$$0(0);
        }
        if (!((parent = expression.getUastParent()) instanceof UCallExpression) || (containingCall = (UCallExpression)parent).getKind() != UastCallKind.METHOD_CALL) {
            return false;
        }
        PsiType type = containingCall.getReturnType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass resolvedClass = classType.resolve();
        if (resolvedClass == null) {
            return false;
        }
        return JB_INSETS_CLASS_NAME.equals(resolvedClass.getQualifiedName());
    }

    @Override
    @NotNull
    protected String getFactoryMethodContainingClassName() {
        String string = JB_UI_CLASS_NAME;
        if (string == null) {
            UseDPIAwareInsetsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getFactoryMethodName() {
        return "insets";
    }

    @Override
    @NotNull
    protected String getNonDpiAwareClassName() {
        String string = AWT_INSETS_CLASS_NAME;
        if (string == null) {
            UseDPIAwareInsetsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String getCanBeSimplifiedMessage() {
        String string = DevKitBundle.message("inspections.use.dpi.aware.insets.can.be.simplified", new Object[0]);
        if (string == null) {
            UseDPIAwareInsetsInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected LocalQuickFix createSimplifyFix() {
        return new SimplifyJBUIInsetsCreationQuickFix();
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String getNonDpiAwareObjectCreatedMessage() {
        String string = DevKitBundle.message("inspections.use.dpi.aware.insets.not.dpi.aware", new Object[0]);
        if (string == null) {
            UseDPIAwareInsetsInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected LocalQuickFix createConvertToDpiAwareMethodCall() {
        return new ConvertToJBUIInsetsQuickFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseDPIAwareInsetsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseDPIAwareInsetsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryMethodContainingClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonDpiAwareClassName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanBeSimplifiedMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonDpiAwareObjectCreatedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedConstructorCall";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class SimplifyJBUIInsetsCreationQuickFix
    extends AbstractConvertToDpiAwareInsetsQuickFix {
        private SimplifyJBUIInsetsCreationQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.use.dpi.aware.insets.simplify.fix.name", new Object[0]);
            if (string == null) {
                SimplifyJBUIInsetsCreationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UseDPIAwareInsetsInspection$SimplifyJBUIInsetsCreationQuickFix", "getFamilyName"));
        }
    }

    private static class ConvertToJBUIInsetsQuickFix
    extends AbstractConvertToDpiAwareInsetsQuickFix {
        private ConvertToJBUIInsetsQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.use.dpi.aware.insets.convert.fix.name", new Object[0]);
            if (string == null) {
                ConvertToJBUIInsetsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UseDPIAwareInsetsInspection$ConvertToJBUIInsetsQuickFix", "getFamilyName"));
        }
    }

    private static abstract class AbstractConvertToDpiAwareInsetsQuickFix
    extends AbstractUseDPIAwareBorderInspection.AbstractConvertToDpiAwareCallQuickFix {
        private AbstractConvertToDpiAwareInsetsQuickFix() {
        }

        @Override
        @NotNull
        protected String getFactoryMethodContainingClassName() {
            String string = JB_UI_CLASS_NAME;
            if (string == null) {
                AbstractConvertToDpiAwareInsetsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getEmptyFactoryMethodName() {
            return "emptyInsets";
        }

        @Override
        @NotNull
        protected String getTopFactoryMethodName() {
            return "insetsTop";
        }

        @Override
        @NotNull
        protected String getBottomFactoryMethodName() {
            return "insetsBottom";
        }

        @Override
        @NotNull
        protected String getLeftFactoryMethodName() {
            return "insetsLeft";
        }

        @Override
        @NotNull
        protected String getRightFactoryMethodName() {
            return "insetsRight";
        }

        @Override
        @NotNull
        protected String getAllSameFactoryMethodName() {
            return "insets";
        }

        @Override
        @NotNull
        protected String getTopBottomAndLeftRightSameFactoryMethodName() {
            return "insets";
        }

        @Override
        @NotNull
        protected String getAllDifferentFactoryMethodName() {
            return "insets";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UseDPIAwareInsetsInspection$AbstractConvertToDpiAwareInsetsQuickFix", "getFactoryMethodContainingClassName"));
        }
    }
}

