/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.metaInformation;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.metaInformation.UtilsKt;
import org.jetbrains.idea.devkit.util.DevKitDomUtil;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/metaInformation/UnknownIdInMetaInformationInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isAllowed", "isKnownId", "id", "", "textToSearch", "getShortNameByElement", "domElement", "Lcom/intellij/util/xml/DomElement;", "intellij.devkit.core"})
public final class UnknownIdInMetaInformationInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!this.isAllowed(holder)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new JsonElementVisitor(this, holder){
            final /* synthetic */ UnknownIdInMetaInformationInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitObject(JsonObject o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                JsonProperty jsonProperty = o.findProperty("id");
                if (jsonProperty == null) {
                    return;
                }
                JsonProperty idProperty = jsonProperty;
                JsonValue jsonValue = idProperty.getValue();
                JsonStringLiteral valueElement = jsonValue instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue : null;
                Object object = valueElement;
                if (object == null || (object = object.getValue()) == null) {
                    return;
                }
                Object id = object;
                if (!UnknownIdInMetaInformationInspection.access$isKnownId(this.this$0, (String)id, this.$holder)) {
                    Object[] objectArray = new Object[]{id};
                    this.$holder.registerProblem((PsiElement)valueElement, DevKitBundle.message("inspections.meta.information.unknown.inspection.id", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAllowed(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!DevKitInspectionUtil.isAllowed(holder.getFile())) return false;
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (!UtilsKt.isMetaInformationFile(psiFile)) return false;
        return true;
    }

    private final boolean isKnownId(String id, ProblemsHolder holder) {
        String className = LocalInspectionTool.getShortName((String)id) + "Inspection";
        return this.isKnownId(id, id, holder) || this.isKnownId(id, className, holder);
    }

    private final boolean isKnownId(String id, String textToSearch, ProblemsHolder holder) {
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DomManager manager = DomManager.getDomManager((Project)project2);
        AtomicBoolean found = new AtomicBoolean(false);
        ExtensionLocatorKt.processExtensionDeclarations(textToSearch, project2, false, (Function2<? super Extension, ? super XmlTag, Boolean>)((Function2)(arg_0, arg_1) -> UnknownIdInMetaInformationInspection.isKnownId$lambda$0(manager, id, this, found, arg_0, arg_1)));
        return found.get();
    }

    private final String getShortNameByElement(DomElement domElement) {
        GenericAttributeValue<?> shortNameAttr = DevKitDomUtil.getAttribute(domElement, "shortName");
        if (shortNameAttr != null && shortNameAttr.getValue() != null) {
            return shortNameAttr.getRawText();
        }
        GenericAttributeValue<?> genericAttributeValue = DevKitDomUtil.getAttribute(domElement, "implementationClass");
        String implementationClass = genericAttributeValue != null ? genericAttributeValue.getRawText() : null;
        CharSequence charSequence = implementationClass;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return LocalInspectionTool.getShortName((String)StringUtil.getShortName((String)implementationClass));
    }

    private static final boolean isKnownId$lambda$0(DomManager $manager, String $id, UnknownIdInMetaInformationInspection this$0, AtomicBoolean $found, Extension extension, XmlTag tag) {
        String extensionName;
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        String string = extensionName = extensionPoint != null ? extensionPoint.getEffectiveQualifiedName() : null;
        if (!Intrinsics.areEqual((Object)extensionName, (Object)"com.intellij.localInspection") && !Intrinsics.areEqual((Object)extensionName, (Object)"com.intellij.globalInspection")) {
            return true;
        }
        DomElement domElement = $manager.getDomElement(tag);
        if (domElement == null) {
            return true;
        }
        DomElement domElement2 = domElement;
        if (Intrinsics.areEqual((Object)$id, (Object)this$0.getShortNameByElement(domElement2))) {
            $found.set(true);
            return false;
        }
        return true;
    }

    public static final /* synthetic */ boolean access$isKnownId(UnknownIdInMetaInformationInspection $this, String id, ProblemsHolder holder) {
        return $this.isKnownId(id, holder);
    }
}

