/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.metaInformation;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"isMetaInformationFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/idea/devkit/inspections/metaInformation/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,25:1\n1755#2,3:26\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/idea/devkit/inspections/metaInformation/UtilsKt\n*L\n21#1:26,3\n*E\n"})
public final class UtilsKt {
    public static final boolean isMetaInformationFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return UtilsKt.isMetaInformationFile(virtualFile2, project);
    }

    public static final boolean isMetaInformationFile(@NotNull VirtualFile file, @NotNull Project project) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!Intrinsics.areEqual((Object)file.getName(), (Object)"metaInformation.json")) {
                return false;
            }
            VirtualFile virtualFile = file.getParent();
            if (virtualFile == null) {
                return false;
            }
            VirtualFile descriptionDirectory = virtualFile;
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            StreamEx<PsiDirectory> descriptionDirs = DescriptionCheckerUtil.allDescriptionDirs(module, DescriptionType.INSPECTION);
            Intrinsics.checkNotNull(descriptionDirs);
            Iterable $this$any$iv = (Iterable)descriptionDirs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiDirectory it = (PsiDirectory)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getVirtualFile(), (Object)descriptionDirectory)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }
}

