/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.inspections.missingApi.BuildNumberValidator;
import org.jetbrains.idea.devkit.inspections.missingApi.MissingRecentApiUsageProcessor;
import org.jetbrains.idea.devkit.inspections.missingApi.SinceUntilRange;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

@IntellijInternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010!\u001a\u00020\"H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "sinceBuildString", "", "getSinceBuildString", "()Ljava/lang/String;", "setSinceBuildString", "(Ljava/lang/String;)V", "untilBuildString", "getUntilBuildString", "setUntilBuildString", "sinceBuild", "Lcom/intellij/openapi/util/BuildNumber;", "getSinceBuild", "()Lcom/intellij/openapi/util/BuildNumber;", "untilBuild", "getUntilBuild", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getTargetedSinceUntilRanges", "", "Lorg/jetbrains/idea/devkit/inspections/missingApi/SinceUntilRange;", "module", "Lcom/intellij/openapi/module/Module;", "getSinceUntilRange", "pluginXml", "Lcom/intellij/psi/xml/XmlFile;", "intellij.devkit.core"})
@VisibleForTesting
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMissingRecentApiInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingRecentApiInspection.kt\norg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n1#2:119\n1#2:132\n1611#3,9:109\n1863#3:118\n1864#3:120\n1620#3:121\n1611#3,9:122\n1863#3:131\n1864#3:133\n1620#3:134\n827#3:135\n855#3,2:136\n*S KotlinDebug\n*F\n+ 1 MissingRecentApiInspection.kt\norg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiInspection\n*L\n92#1:119\n93#1:132\n92#1:109,9\n92#1:118\n92#1:120\n92#1:121\n93#1:122,9\n93#1:131\n93#1:133\n93#1:134\n94#1:135\n94#1:136,2\n*E\n"})
public final class MissingRecentApiInspection
extends LocalInspectionTool {
    @Nullable
    private String sinceBuildString;
    @Nullable
    private String untilBuildString;

    @Nullable
    public final String getSinceBuildString() {
        return this.sinceBuildString;
    }

    public final void setSinceBuildString(@Nullable String string) {
        this.sinceBuildString = string;
    }

    @Nullable
    public final String getUntilBuildString() {
        return this.untilBuildString;
    }

    public final void setUntilBuildString(@Nullable String string) {
        this.untilBuildString = string;
    }

    private final BuildNumber getSinceBuild() {
        BuildNumber buildNumber;
        String string = this.sinceBuildString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            buildNumber = BuildNumber.fromStringOrNull((String)it);
        } else {
            buildNumber = null;
        }
        return buildNumber;
    }

    private final BuildNumber getUntilBuild() {
        BuildNumber buildNumber;
        String string = this.untilBuildString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            buildNumber = BuildNumber.fromStringOrNull((String)it);
        } else {
            buildNumber = null;
        }
        return buildNumber;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = holder.getFile().getVirtualFile();
        if (IntelliJProjectUtil.isIntelliJPlatformProject((Project)project2) || virtualFile != null && TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)holder.getFile()));
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        List<SinceUntilRange> targetedSinceUntilRanges = this.getTargetedSinceUntilRanges(module2);
        if (targetedSinceUntilRanges.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return ApiUsageUastVisitor.Companion.createPsiElementVisitor((ApiUsageProcessor)new MissingRecentApiUsageProcessor(holder, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, targetedSinceUntilRanges));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[1];
        OptRegularComponent[] optRegularComponentArray2 = new OptRegularComponent[]{OptPane.string((String)"sinceBuildString", (String)DevKitBundle.message("inspections.missing.recent.api.settings.since", new Object[0]), (StringValidator)new BuildNumberValidator()), OptPane.string((String)"untilBuildString", (String)DevKitBundle.message("inspections.missing.recent.api.settings.until", new Object[0]), (StringValidator)new BuildNumberValidator())};
        optRegularComponentArray[0] = OptPane.group((String)DevKitBundle.message("inspections.missing.recent.api.settings.range", new Object[0]), (OptRegularComponent[])optRegularComponentArray2);
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SinceUntilRange> getTargetedSinceUntilRanges(Module module) {
        if (this.getSinceBuild() == null && this.getUntilBuild() == null) {
            void $this$filterNotTo$iv$iv;
            Object it$iv$iv;
            boolean bl;
            Module it;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            List<Module> list = DevkitActionsUtil.getCandidatePluginModules(module);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getCandidatePluginModules(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (Module)element$iv$iv;
                boolean bl3 = false;
                if (PluginModuleType.getPluginXml(it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (XmlFile)element$iv$iv;
                boolean bl4 = false;
                if (this.getSinceUntilRange((XmlFile)it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                SinceUntilRange it2 = (SinceUntilRange)element$iv$iv2;
                boolean bl5 = false;
                if (it2.getSinceBuild() == null) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)new SinceUntilRange(this.getSinceBuild(), this.getUntilBuild()));
    }

    private final SinceUntilRange getSinceUntilRange(XmlFile pluginXml) {
        IdeaPlugin ideaPlugin = DescriptorUtil.getIdeaPlugin(pluginXml);
        if (ideaPlugin == null) {
            return null;
        }
        IdeaPlugin ideaPlugin2 = ideaPlugin;
        IdeaVersion ideaVersion = ideaPlugin2.getIdeaVersion();
        Intrinsics.checkNotNullExpressionValue((Object)ideaVersion, (String)"getIdeaVersion(...)");
        IdeaVersion ideaVersion2 = ideaVersion;
        BuildNumber sinceBuild = (BuildNumber)ideaVersion2.getSinceBuild().getValue();
        BuildNumber untilBuild = (BuildNumber)ideaVersion2.getUntilBuild().getValue();
        return new SinceUntilRange(sinceBuild, untilBuild);
    }
}

