/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.missingApi.SinceUntilRange;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J,\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J.\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u0015H\u0002J\u0018\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J&\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0003J\u000e\u0010.\u001a\u0004\u0018\u00010#*\u00020\u0010H\u0002J\u0014\u0010/\u001a\u0004\u0018\u00010#*\b\u0012\u0004\u0012\u00020&0\u0007H\u0002J\u0014\u00100\u001a\u000201*\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u000e\u00102\u001a\u0004\u0018\u00010+*\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "targetedSinceUntilRanges", "", "Lorg/jetbrains/idea/devkit/inspections/missingApi/SinceUntilRange;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/ProblemHighlightType;Ljava/util/List;)V", "processReference", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "processConstructorInvocation", "instantiatedClass", "Lcom/intellij/psi/PsiClass;", "constructor", "Lcom/intellij/psi/PsiMethod;", "subclassDeclaration", "Lorg/jetbrains/uast/UClass;", "processMethodOverriding", "method", "Lorg/jetbrains/uast/UMethod;", "overriddenMethod", "registerDefaultConstructorProblem", "constructorOwner", "elementToHighlight", "Lcom/intellij/psi/PsiElement;", "apiSinceBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "brokenRanges", "findEmptyConstructorAnnotations", "Lcom/intellij/psi/PsiAnnotation;", "psiClass", "checkApiIsRecent", "modifierListOwner", "buildDescription", "", "apiElement", "availableSince", "getApiSinceBuildNumber", "getAvailableSinceBuildNumber", "someBuildsAreNotCovered", "", "getPresentableName", "Companion", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nMissingRecentApiUsageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingRecentApiUsageProcessor.kt\norg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiUsageProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n774#2:152\n865#2,2:153\n774#2:155\n865#2,2:156\n774#2:158\n865#2,2:159\n*S KotlinDebug\n*F\n+ 1 MissingRecentApiUsageProcessor.kt\norg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiUsageProcessor\n*L\n50#1:152\n50#1:153,2\n59#1:155\n59#1:156,2\n96#1:158\n96#1:159,2\n*E\n"})
public final class MissingRecentApiUsageProcessor
implements ApiUsageProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final ProblemHighlightType highlightType;
    @NotNull
    private final List<SinceUntilRange> targetedSinceUntilRanges;
    @NotNull
    private static final String AVAILABLE_SINCE_ANNOTATION;

    public MissingRecentApiUsageProcessor(@NotNull ProblemsHolder holder, @NotNull ProblemHighlightType highlightType, @NotNull List<SinceUntilRange> targetedSinceUntilRanges) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
        Intrinsics.checkNotNullParameter(targetedSinceUntilRanges, (String)"targetedSinceUntilRanges");
        this.holder = holder;
        this.highlightType = highlightType;
        this.targetedSinceUntilRanges = targetedSinceUntilRanges;
    }

    public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        PsiElement psiElement = sourceNode.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement elementToHighlight = psiElement;
        this.checkApiIsRecent(target, elementToHighlight);
    }

    /*
     * WARNING - void declaration
     */
    public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
        Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
        Intrinsics.checkNotNullParameter((Object)instantiatedClass, (String)"instantiatedClass");
        PsiElement psiElement = sourceNode.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement elementToHighlight = psiElement;
        if (constructor != null) {
            this.checkApiIsRecent((PsiModifierListOwner)constructor, elementToHighlight);
        } else {
            void $this$filterTo$iv$iv;
            BuildNumber buildNumber = this.findEmptyConstructorAnnotations(instantiatedClass);
            if (buildNumber == null || (buildNumber = this.getAvailableSinceBuildNumber((List<? extends PsiAnnotation>)buildNumber)) == null) {
                return;
            }
            BuildNumber availableSince = buildNumber;
            Iterable $this$filter$iv = this.targetedSinceUntilRanges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SinceUntilRange it = (SinceUntilRange)element$iv$iv;
                boolean bl = false;
                if (!this.someBuildsAreNotCovered(it, availableSince)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List brokenRanges = (List)destination$iv$iv;
            if (!((Collection)brokenRanges).isEmpty()) {
                this.registerDefaultConstructorProblem(instantiatedClass, elementToHighlight, availableSince, brokenRanges);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod overriddenMethod) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)overriddenMethod, (String)"overriddenMethod");
        BuildNumber buildNumber = this.getApiSinceBuildNumber((PsiModifierListOwner)overriddenMethod);
        if (buildNumber == null) {
            return;
        }
        BuildNumber availableSince = buildNumber;
        Iterable $this$filter$iv = this.targetedSinceUntilRanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SinceUntilRange it = (SinceUntilRange)element$iv$iv;
            boolean bl = false;
            if (!this.someBuildsAreNotCovered(it, availableSince)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List brokenRanges = (List)destination$iv$iv;
        if (!((Collection)brokenRanges).isEmpty()) {
            PsiClass psiClass = overriddenMethod.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass aClass = psiClass;
            PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)method.getUastAnchor());
            if (psiElement == null) {
                return;
            }
            PsiElement methodNameElement = psiElement;
            Object[] objectArray = new Object[]{this.getPresentableName((PsiElement)aClass), availableSince.asString(), CollectionsKt.joinToString$default((Iterable)brokenRanges, null, null, null, (int)0, null, MissingRecentApiUsageProcessor::processMethodOverriding$lambda$2, (int)31, null)};
            String description = DevKitBundle.message("inspections.missing.recent.api.overriding", objectArray);
            this.holder.registerProblem(methodNameElement, description, this.highlightType, new LocalQuickFix[0]);
        }
    }

    private final void registerDefaultConstructorProblem(PsiClass constructorOwner, PsiElement elementToHighlight, BuildNumber apiSinceBuildNumber, List<SinceUntilRange> brokenRanges) {
        Object[] objectArray = new Object[]{constructorOwner.getQualifiedName(), apiSinceBuildNumber.asString(), CollectionsKt.joinToString$default((Iterable)brokenRanges, null, null, null, (int)0, null, MissingRecentApiUsageProcessor::registerDefaultConstructorProblem$lambda$3, (int)31, null)};
        String description = DevKitBundle.message("inspections.missing.recent.api.default.constructor.message", objectArray);
        this.holder.registerProblem(elementToHighlight, description, this.highlightType, new LocalQuickFix[0]);
    }

    private final List<PsiAnnotation> findEmptyConstructorAnnotations(PsiClass psiClass) {
        return ExternalAnnotationsManager.getInstance((Project)psiClass.getProject()).findDefaultConstructorExternalAnnotations(psiClass, AVAILABLE_SINCE_ANNOTATION);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkApiIsRecent(PsiModifierListOwner modifierListOwner, PsiElement elementToHighlight) {
        void $this$filterTo$iv$iv;
        BuildNumber buildNumber = this.getApiSinceBuildNumber(modifierListOwner);
        if (buildNumber == null) {
            return;
        }
        BuildNumber availableSince = buildNumber;
        Iterable $this$filter$iv = this.targetedSinceUntilRanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SinceUntilRange it = (SinceUntilRange)element$iv$iv;
            boolean bl = false;
            if (!this.someBuildsAreNotCovered(it, availableSince)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List brokenRanges = (List)destination$iv$iv;
        if (!((Collection)brokenRanges).isEmpty()) {
            String description = this.buildDescription(modifierListOwner, availableSince, brokenRanges);
            this.holder.registerProblem(elementToHighlight, description, this.highlightType, new LocalQuickFix[0]);
        }
    }

    @InspectionMessage
    private final String buildDescription(PsiModifierListOwner apiElement, BuildNumber availableSince, List<SinceUntilRange> brokenRanges) {
        String string;
        String presentableName = this.getPresentableName((PsiElement)apiElement);
        String string2 = availableSince.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String sinceString = string2;
        String rangesString = CollectionsKt.joinToString$default((Iterable)brokenRanges, null, null, null, (int)0, null, MissingRecentApiUsageProcessor::buildDescription$lambda$5, (int)31, null);
        PsiModifierListOwner psiModifierListOwner = apiElement;
        if (psiModifierListOwner instanceof PsiClass) {
            Object[] objectArray = new Object[]{presentableName, sinceString, rangesString};
            String string3 = DevKitBundle.message("inspections.missing.recent.api.class.message", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else if (psiModifierListOwner instanceof PsiMethod) {
            Object[] objectArray = new Object[]{presentableName, sinceString, rangesString};
            String string4 = DevKitBundle.message("inspections.missing.recent.api.method.message", objectArray);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else if (psiModifierListOwner instanceof PsiField) {
            Object[] objectArray = new Object[]{presentableName, sinceString, rangesString};
            String string5 = DevKitBundle.message("inspections.missing.recent.api.field.message", objectArray);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{presentableName, sinceString, rangesString};
            String string6 = DevKitBundle.message("inspections.missing.recent.api.common.message", objectArray);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        }
        return string;
    }

    private final BuildNumber getApiSinceBuildNumber(PsiModifierListOwner $this$getApiSinceBuildNumber) {
        List list = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)$this$getApiSinceBuildNumber, (Collection)CollectionsKt.listOf((Object)AVAILABLE_SINCE_ANNOTATION), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllAnnotations(...)");
        List externalAnnotations = list;
        if (externalAnnotations.isEmpty()) {
            return null;
        }
        return this.getAvailableSinceBuildNumber(externalAnnotations);
    }

    private final BuildNumber getAvailableSinceBuildNumber(List<? extends PsiAnnotation> $this$getAvailableSinceBuildNumber) {
        return (BuildNumber)SequencesKt.minOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)$this$getAvailableSinceBuildNumber), MissingRecentApiUsageProcessor::getAvailableSinceBuildNumber$lambda$7));
    }

    private final boolean someBuildsAreNotCovered(SinceUntilRange $this$someBuildsAreNotCovered, BuildNumber apiSinceBuildNumber) {
        return $this$someBuildsAreNotCovered.getSinceBuild() == null || $this$someBuildsAreNotCovered.getSinceBuild().compareTo(apiSinceBuildNumber) < 0;
    }

    private final String getPresentableName(PsiElement $this$getPresentableName) {
        return $this$getPresentableName instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)$this$getPresentableName) ? ((PsiMethod)$this$getPresentableName).getName() : HighlightMessageUtil.getSymbolName((PsiElement)$this$getPresentableName);
    }

    private static final CharSequence processMethodOverriding$lambda$2(SinceUntilRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final CharSequence registerDefaultConstructorProblem$lambda$3(SinceUntilRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final CharSequence buildDescription$lambda$5(SinceUntilRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final BuildNumber getAvailableSinceBuildNumber$lambda$7(PsiAnnotation annotation) {
        BuildNumber buildNumber;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        String string = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"value");
        if (string != null) {
            String it = string;
            boolean bl = false;
            buildNumber = BuildNumber.fromStringOrNull((String)it);
        } else {
            buildNumber = null;
        }
        return buildNumber;
    }

    static {
        String string = ApiStatus.AvailableSince.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        AVAILABLE_SINCE_ANNOTATION = string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiUsageProcessor$Companion;", "", "<init>", "()V", "AVAILABLE_SINCE_ANNOTATION", "", "getAVAILABLE_SINCE_ANNOTATION", "()Ljava/lang/String;", "intellij.devkit.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getAVAILABLE_SINCE_ANNOTATION() {
            return AVAILABLE_SINCE_ANNOTATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

