/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi.resolve;

import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.BuildNumber;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.LibrariesWithIntellijClassesSetting;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.LibraryCoordinatesState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/IdeExternalAnnotationsLocationProvider;", "Lcom/intellij/codeInsight/externalAnnotation/location/AnnotationsLocationProvider;", "<init>", "()V", "getLocations", "", "Lcom/intellij/codeInsight/externalAnnotation/location/AnnotationsLocation;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "artifactId", "", "groupId", "version", "getAnnotationsLocations", "", "ideVersion", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nIdeExternalAnnotationsLocationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeExternalAnnotationsLocationProvider.kt\norg/jetbrains/idea/devkit/inspections/missingApi/resolve/IdeExternalAnnotationsLocationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1755#2,3:49\n*S KotlinDebug\n*F\n+ 1 IdeExternalAnnotationsLocationProvider.kt\norg/jetbrains/idea/devkit/inspections/missingApi/resolve/IdeExternalAnnotationsLocationProvider\n*L\n26#1:49,3\n*E\n"})
public final class IdeExternalAnnotationsLocationProvider
implements AnnotationsLocationProvider {
    @NotNull
    public Collection<AnnotationsLocation> getLocations(@NotNull Project project, @NotNull Library library, @Nullable String artifactId, @Nullable String groupId, @Nullable String version) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            if (groupId == null || artifactId == null || version == null) {
                return CollectionsKt.emptyList();
            }
            List<LibraryCoordinatesState> libraries = LibrariesWithIntellijClassesSetting.Companion.getInstance(project).getIntellijApiContainingLibraries();
            Iterable $this$any$iv = libraries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LibraryCoordinatesState it = (LibraryCoordinatesState)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getGroupId(), (Object)groupId) && Intrinsics.areEqual((Object)it.getArtifactId(), (Object)artifactId))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return this.getAnnotationsLocations(version);
        }
        return CollectionsKt.emptyList();
    }

    private final List<AnnotationsLocation> getAnnotationsLocations(String ideVersion) {
        Object object;
        if (StringsKt.endsWith$default((String)ideVersion, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) {
            object = ideVersion;
        } else {
            BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)ideVersion);
            if (buildNumber == null) {
                return CollectionsKt.emptyList();
            }
            BuildNumber ideBuildNumber = buildNumber;
            object = ideBuildNumber.getBaselineVersion() + ".999999";
        }
        String annotationsVersion = object;
        String[] stringArray = new String[]{"https://www.jetbrains.com/intellij-repository/releases/", "https://www.jetbrains.com/intellij-repository/snapshots/"};
        return CollectionsKt.listOf((Object)new AnnotationsLocation("com.jetbrains.intellij.idea", "ideaIU", annotationsVersion, stringArray));
    }
}

