/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.quickfix.AddServiceAnnotationProvider;
import org.jetbrains.idea.devkit.inspections.quickfix.AddServiceAnnotationProviders;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/devkit/inspections/quickfix/ConvertToLightServiceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "classPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "xmlTagPointer", "Lcom/intellij/psi/xml/XmlTag;", "level", "Lcom/intellij/openapi/components/Service$Level;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/openapi/components/Service$Level;)V", "aClass", "xmlTag", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/xml/XmlTag;Lcom/intellij/openapi/components/Service$Level;)V", "getFamilyName", "", "getName", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "applyFix", "", "descriptor", "intellij.devkit.core"})
public final class ConvertToLightServiceFix
implements LocalQuickFix {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> classPointer;
    @NotNull
    private final SmartPsiElementPointer<XmlTag> xmlTagPointer;
    @NotNull
    private final Service.Level level;

    private ConvertToLightServiceFix(SmartPsiElementPointer<PsiElement> classPointer, SmartPsiElementPointer<XmlTag> xmlTagPointer, Service.Level level) {
        this.classPointer = classPointer;
        this.xmlTagPointer = xmlTagPointer;
        this.level = level;
    }

    public ConvertToLightServiceFix(@NotNull PsiElement aClass, @NotNull XmlTag xmlTag, @NotNull Service.Level level) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)xmlTag, (String)"xmlTag");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this((SmartPsiElementPointer<PsiElement>)SmartPointersKt.createSmartPointer((PsiElement)aClass), (SmartPsiElementPointer<XmlTag>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)xmlTag)), level);
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspection.light.service.migration.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getName() {
        String key = switch (WhenMappings.$EnumSwitchMapping$0[this.level.ordinal()]) {
            case 1 -> "inspection.light.service.migration.app.level.fix";
            case 2 -> "inspection.light.service.migration.project.level.fix";
            default -> throw new NoWhenBranchMatchedException();
        };
        String string = DevKitBundle.message(key, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = this.classPointer.getElement();
        if (psiElement == null) {
            return;
        }
        PsiElement aClass = psiElement;
        XmlTag xmlTag = (XmlTag)this.xmlTagPointer.getElement();
        if (xmlTag == null) {
            return;
        }
        XmlTag xmlTag2 = xmlTag;
        AddServiceAnnotationProvider addServiceAnnotationProvider = (AddServiceAnnotationProvider)AddServiceAnnotationProviders.INSTANCE.forLanguage(aClass.getLanguage());
        if (addServiceAnnotationProvider == null) {
            return;
        }
        AddServiceAnnotationProvider addServiceAnnotationProvider2 = addServiceAnnotationProvider;
        addServiceAnnotationProvider2.addServiceAnnotation(aClass, this.level);
        RemoveDomElementQuickFix.removeXmlTag((XmlTag)xmlTag2, (Project)project);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Service.Level.values().length];
            try {
                nArray[Service.Level.APP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Service.Level.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

