/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.siyeh.ig.psiutils.CommentTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

@IntellijInternalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH$\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J)\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0096\u0002J\u001d\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u00002\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u000eH\u0004\u00a2\u0006\u0002\u0010$J%\u0010%\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010)\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/devkit/inspections/quickfix/WrapInSupplierQuickFix;", "T", "Lcom/intellij/psi/PsiNamedElement;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "elementToWrap", "<init>", "(Lcom/intellij/psi/PsiNamedElement;)V", "getFamilyName", "", "getText", "startInWriteAction", "", "findElement", "startElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiNamedElement;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "invoke", "", "file", "Lcom/intellij/psi/PsiFile;", "endElement", "createSupplierElement", "element", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiNamedElement;)Lcom/intellij/psi/PsiNamedElement;", "defaultSupplierElementName", "(Lcom/intellij/psi/PsiNamedElement;)Ljava/lang/String;", "copyComments", "sourceElement", "targetElement", "excludeElement", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiElement;)V", "changeElementInitializerToSupplierCall", "supplierElement", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiNamedElement;)V", "inlineElement", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiNamedElement;)V", "intellij.devkit.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAppServiceAsStaticFinalFieldOrPropertyFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppServiceAsStaticFinalFieldOrPropertyFixProvider.kt\norg/jetbrains/idea/devkit/inspections/quickfix/WrapInSupplierQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public abstract class WrapInSupplierQuickFix<T extends PsiNamedElement>
extends LocalQuickFixOnPsiElement {
    public WrapInSupplierQuickFix(@NotNull T elementToWrap) {
        Intrinsics.checkNotNullParameter(elementToWrap, (String)"elementToWrap");
        super((PsiElement)elementToWrap);
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.wrap.application.service.in.supplier.quick.fix.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected abstract T findElement(@NotNull PsiElement var1);

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement = problemDescriptor.getStartElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getStartElement(...)");
        T element = this.findElement(psiElement);
        this.createSupplierElement(project, element);
        ((PsiElement)element).delete();
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        CommandProcessor.getInstance().runUndoTransparentAction(() -> WrapInSupplierQuickFix.invoke$lambda$1(this, startElement, file, project));
    }

    @NotNull
    protected abstract T createSupplierElement(@NotNull Project var1, @NotNull T var2);

    @NotNull
    protected final String defaultSupplierElementName(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element.getName() + "Supplier";
    }

    protected final void copyComments(@NotNull T sourceElement, @NotNull T targetElement, @Nullable PsiElement excludeElement) {
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter(targetElement, (String)"targetElement");
        CommentTracker commentTracker = new CommentTracker();
        PsiElement psiElement = excludeElement;
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            commentTracker.markUnchanged(it);
        }
        commentTracker.grabComments((PsiElement)sourceElement);
        commentTracker.insertCommentsBefore((PsiElement)targetElement);
    }

    public static /* synthetic */ void copyComments$default(WrapInSupplierQuickFix wrapInSupplierQuickFix, PsiNamedElement psiNamedElement, PsiNamedElement psiNamedElement2, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyComments");
        }
        if ((n & 4) != 0) {
            psiElement = null;
        }
        wrapInSupplierQuickFix.copyComments(psiNamedElement, psiNamedElement2, psiElement);
    }

    protected abstract void changeElementInitializerToSupplierCall(@NotNull Project var1, @NotNull T var2, @NotNull T var3);

    protected abstract void inlineElement(@NotNull Project var1, @NotNull T var2);

    private static final void invoke$lambda$1$lambda$0(WrapInSupplierQuickFix this$0, Project $project, PsiNamedElement $element) {
        PsiNamedElement supplierField = this$0.createSupplierElement($project, $element);
        this$0.changeElementInitializerToSupplierCall($project, $element, supplierField);
    }

    private static final void invoke$lambda$1(WrapInSupplierQuickFix this$0, PsiElement $startElement, PsiFile $file, Project $project) {
        Object element = this$0.findElement($startElement);
        if (!FileModificationService.getInstance().prepareFileForWrite($file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> WrapInSupplierQuickFix.invoke$lambda$1$lambda$0(this$0, $project, element));
        this$0.inlineElement($project, element);
    }
}

