/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.internal.PluginUnloadabilityStatus;
import org.jetbrains.idea.devkit.internal.UnloadabilityStatus;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J^\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/devkit/internal/AnalyzeUnloadablePluginsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showReport", "project", "Lcom/intellij/openapi/project/Project;", "result", "", "Lorg/jetbrains/idea/devkit/internal/PluginUnloadabilityStatus;", "analyzeUnloadable", "ideaPlugin", "Lorg/jetbrains/idea/devkit/dom/IdeaPlugin;", "allPlugins", "Lcom/intellij/psi/xml/XmlFile;", "resolvePluginDependency", "dependency", "Lorg/jetbrains/idea/devkit/dom/Dependency;", "analyzePluginFile", "analysisErrors", "", "", "components", "nonDynamicEPs", "", "unspecifiedDynamicEPs", "serviceOverrides", "allowOwnEPs", "", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nAnalyzeUnloadablePluginsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeUnloadablePluginsAction.kt\norg/jetbrains/idea/devkit/internal/AnalyzeUnloadablePluginsAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,307:1\n1755#2,3:308\n774#2:311\n865#2,2:312\n774#2:314\n865#2,2:315\n774#2:317\n865#2,2:318\n1062#2:320\n774#2:321\n865#2,2:322\n1062#2:324\n774#2:325\n865#2,2:326\n774#2:328\n865#2,2:329\n774#2:331\n865#2,2:332\n774#2:334\n865#2:335\n1755#2,3:336\n866#2:339\n1053#2:340\n774#2:341\n865#2,2:342\n1062#2:344\n1611#2,9:345\n1863#2:354\n1864#2:356\n1620#2:357\n1368#2:359\n1454#2,5:360\n1368#2:365\n1454#2,5:366\n1628#2,3:371\n1368#2:374\n1454#2,5:375\n1628#2,3:380\n1368#2:383\n1454#2,5:384\n1628#2,3:389\n1#3:355\n1#3:358\n4135#4,11:392\n*S KotlinDebug\n*F\n+ 1 AnalyzeUnloadablePluginsAction.kt\norg/jetbrains/idea/devkit/internal/AnalyzeUnloadablePluginsAction\n*L\n77#1:308,3\n79#1:311\n79#1:312,2\n88#1:314\n88#1:315,2\n95#1:317\n95#1:318,2\n95#1:320\n105#1:321\n105#1:322,2\n105#1:324\n112#1:325\n112#1:326,2\n122#1:328\n122#1:329,2\n132#1:331\n132#1:332,2\n144#1:334\n144#1:335\n144#1:336,3\n144#1:339\n147#1:340\n163#1:341\n163#1:342,2\n163#1:344\n204#1:345,9\n204#1:354\n204#1:356\n204#1:357\n253#1:359\n253#1:360,5\n274#1:365\n274#1:366,5\n274#1:371,3\n275#1:374\n275#1:375,5\n275#1:380,3\n276#1:383\n276#1:384,5\n276#1:389,3\n204#1:355\n52#1:392,11\n*E\n"})
public final class AnalyzeUnloadablePluginsAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean show;
        IdeView view;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        IdeView ideView = view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        PsiDirectory dir = ideView != null ? ideView.getOrChooseDirectory() : null;
        List result = new ArrayList();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable runnable = () -> AnalyzeUnloadablePluginsAction.actionPerformed$lambda$2(dir, project2, this, result);
        Object[] objectArray = new Object[1];
        Object object = dir;
        if (object == null || (object = object.getName()) == null) {
            object = objectArray[0] = "Project";
        }
        if (show = progressManager.runProcessWithProgressSynchronously(runnable, DevKitBundle.message("action.AnalyzeUnloadablePlugins.progress.title", objectArray), true, e.getProject())) {
            this.showReport(project2, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showReport(Project project, List<PluginUnloadabilityStatus> result) {
        void $this$filterTo$iv$iv;
        Iterator<Map.Entry<String, Set<String>>> $this$filterTo$iv$iv5;
        Iterator $this$sortedByDescending$iv3;
        Iterator<String> $this$filterTo$iv$iv7;
        Iterable destination$iv$iv;
        boolean bl;
        StringBuilder $this$showReport_u24lambda_u2418;
        StringBuilder stringBuilder;
        block35: {
            $this$showReport_u24lambda_u2418 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            Iterable $this$any$iv = result;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    PluginUnloadabilityStatus it2 = (PluginUnloadabilityStatus)t;
                    boolean bl3 = false;
                    boolean bl4 = !((Collection)it2.getAnalysisErrors()).isEmpty();
                    if (!bl4) continue;
                    bl = true;
                    break block35;
                }
                bl = false;
            }
        }
        if (bl) {
            StringBuilder stringBuilder2 = $this$showReport_u24lambda_u2418.append("Analysis errors:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            Iterable $this$filter$iv = result;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean bl5 = false;
            for (Object t : iterable) {
                PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)t;
                boolean bl6 = false;
                boolean bl7 = !((Collection)pluginUnloadabilityStatus.getAnalysisErrors()).isEmpty();
                if (!bl7) continue;
                destination$iv$iv.add(t);
            }
            for (PluginUnloadabilityStatus status : (List)destination$iv$iv) {
                StringBuilder stringBuilder3 = $this$showReport_u24lambda_u2418.append(status.getPluginId());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                for (String string : status.getAnalysisErrors()) {
                    StringBuilder stringBuilder4 = $this$showReport_u24lambda_u2418.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
            }
        }
        Iterable $this$filter$iv = result;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean bl8 = false;
        for (Object t : iterable) {
            PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)t;
            boolean bl9 = false;
            if (!(pluginUnloadabilityStatus.getStatus() == UnloadabilityStatus.UNLOADABLE)) continue;
            destination$iv$iv.add(t);
        }
        List unloadablePlugins = (List)destination$iv$iv;
        StringBuilder stringBuilder5 = $this$showReport_u24lambda_u2418.append("Can unload " + unloadablePlugins.size() + " plugins out of " + result.size());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        for (PluginUnloadabilityStatus status : unloadablePlugins) {
            StringBuilder stringBuilder6 = $this$showReport_u24lambda_u2418.append(status.getPluginId());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
        Iterable $this$filter$iv2 = result;
        boolean bl10 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv7.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)t;
            boolean bl11 = false;
            if (!(pluginUnloadabilityStatus.getStatus() == UnloadabilityStatus.USES_COMPONENTS)) continue;
            collection.add(t);
        }
        $this$filter$iv2 = (List)collection;
        boolean bl12 = false;
        List pluginsUsingComponents = CollectionsKt.sortedWith((Iterable)((Object)$this$sortedByDescending$iv3), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getComponents().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getComponents().size()));
            }
        });
        StringBuilder stringBuilder7 = $this$showReport_u24lambda_u2418.append("Plugins using components (" + pluginsUsingComponents.size() + "):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : pluginsUsingComponents) {
            StringBuilder stringBuilder8 = $this$showReport_u24lambda_u2418.append(pluginUnloadabilityStatus.getPluginId() + " (" + pluginUnloadabilityStatus.getComponents().size() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
            for (String string : pluginUnloadabilityStatus.getComponents()) {
                StringBuilder stringBuilder9 = $this$showReport_u24lambda_u2418.append("  " + string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
        Iterable iterable2 = result;
        boolean $i$f$filter3 = false;
        Iterable iterable3 = iterable2;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean bl13 = false;
        for (Object t : iterable3) {
            PluginUnloadabilityStatus pluginUnloadabilityStatus = (PluginUnloadabilityStatus)t;
            boolean bl9 = false;
            if (!(pluginUnloadabilityStatus.getStatus() == UnloadabilityStatus.USES_SERVICE_OVERRIDES)) continue;
            destination$iv$iv3.add(t);
        }
        Iterable iterable4 = (List)destination$iv$iv3;
        boolean $i$f$sortedByDescending2 = false;
        List pluginsUsingServiceOverrides = CollectionsKt.sortedWith((Iterable)iterable4, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getServiceOverrides().size());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getServiceOverrides().size()));
            }
        });
        StringBuilder stringBuilder10 = $this$showReport_u24lambda_u2418.append("Plugins using service overrides (" + pluginsUsingServiceOverrides.size() + "):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        for (PluginUnloadabilityStatus status : pluginsUsingServiceOverrides) {
            StringBuilder stringBuilder11 = $this$showReport_u24lambda_u2418.append(status.getPluginId() + " (" + CollectionsKt.joinToString$default((Iterable)status.getServiceOverrides(), null, null, null, (int)0, null, null, (int)63, null) + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
        Iterable $this$filter$iv4 = result;
        boolean bl14 = false;
        destination$iv$iv3 = $this$filter$iv4;
        Collection collection2 = new ArrayList();
        boolean bl15 = false;
        Iterator iterator2 = $this$filterTo$iv$iv5.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            PluginUnloadabilityStatus it5 = (PluginUnloadabilityStatus)t;
            boolean bl102 = false;
            if (!(it5.getStatus() == UnloadabilityStatus.NON_DYNAMIC_IN_DEPENDENCIES)) continue;
            collection2.add(t);
        }
        List list = (List)collection2;
        StringBuilder stringBuilder12 = $this$showReport_u24lambda_u2418.append("Plugins not unloadable because of non-dynamic EPs in optional dependencies (" + list.size() + "):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : list) {
            StringBuilder stringBuilder13 = $this$showReport_u24lambda_u2418.append(pluginUnloadabilityStatus.getPluginId());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13.append('\n'), (String)"append(...)");
            for (Map.Entry<String, Set<String>> entry : pluginUnloadabilityStatus.getNonDynamicEPsInDependencies().entrySet()) {
                String string = entry.getKey();
                Set<String> set = entry.getValue();
                StringBuilder stringBuilder14 = $this$showReport_u24lambda_u2418.append("  " + string + " - " + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14.append('\n'), (String)"append(...)");
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
        Iterable iterable5 = result;
        boolean $i$f$filter5 = false;
        Iterable iterable6 = iterable5;
        Collection collection3 = new ArrayList();
        boolean bl16 = false;
        for (Object element$iv$iv6 : iterable6) {
            PluginUnloadabilityStatus it6 = (PluginUnloadabilityStatus)element$iv$iv6;
            boolean bl11 = false;
            if (!(it6.getStatus() == UnloadabilityStatus.DEPENDENCIES_WITHOUT_SEPARATE_CLASSLOADERS)) continue;
            collection3.add(element$iv$iv6);
        }
        List pluginsWithDependenciesWithoutSeparateClassloaders = (List)collection3;
        StringBuilder stringBuilder15 = $this$showReport_u24lambda_u2418.append("Plugins not unloadable because of optional dependencies without separate classloaders (" + pluginsWithDependenciesWithoutSeparateClassloaders.size() + "):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append(...)");
        for (PluginUnloadabilityStatus status : pluginsWithDependenciesWithoutSeparateClassloaders) {
            StringBuilder stringBuilder16 = $this$showReport_u24lambda_u2418.append(status.getPluginId());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16.append('\n'), (String)"append(...)");
            for (String string : status.getDependenciesWithoutSeparateClassloaders()) {
                StringBuilder stringBuilder17 = $this$showReport_u24lambda_u2418.append("  " + string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17.append('\n'), (String)"append(...)");
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
        Iterable $this$filter$iv6 = result;
        boolean bl17 = false;
        Iterable iterable7 = $this$filter$iv6;
        Collection collection4 = new ArrayList();
        boolean bl18 = false;
        for (Object element$iv$iv7 : iterable7) {
            PluginUnloadabilityStatus it7 = (PluginUnloadabilityStatus)element$iv$iv7;
            boolean bl122 = false;
            if (!(it7.getStatus() == UnloadabilityStatus.USES_NON_DYNAMIC_EPS)) continue;
            collection4.add(element$iv$iv7);
        }
        List list2 = (List)collection4;
        if (!((Collection)list2).isEmpty()) {
            StringBuilder stringBuilder18 = $this$showReport_u24lambda_u2418.append("Plugins with EPs explicitly marked as dynamic=false:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18.append('\n'), (String)"append(...)");
            for (PluginUnloadabilityStatus pluginUnloadabilityStatus : list2) {
                StringBuilder stringBuilder19 = $this$showReport_u24lambda_u2418.append(pluginUnloadabilityStatus.getPluginId() + " (" + pluginUnloadabilityStatus.getNonDynamicEPs().size() + ")");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19.append('\n'), (String)"append(...)");
                for (String string : pluginUnloadabilityStatus.getNonDynamicEPs()) {
                    StringBuilder stringBuilder20 = $this$showReport_u24lambda_u2418.append("  " + string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20.append('\n'), (String)"append(...)");
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
        }
        Iterable iterable8 = result;
        boolean bl19 = false;
        Iterable iterable9 = iterable8;
        Collection collection5 = new ArrayList();
        boolean $i$f$filterTo7 = false;
        for (Object element$iv$iv8 : iterable9) {
            boolean bl20;
            block36: {
                PluginUnloadabilityStatus it8 = (PluginUnloadabilityStatus)element$iv$iv8;
                boolean bl142 = false;
                Iterable $this$any$iv = it8.getUnspecifiedDynamicEPs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl20 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it9 = (String)element$iv2;
                        boolean bl152 = false;
                        if (!(!StringsKt.startsWith$default((String)it9, (String)"cidr", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it9, (String)"appcode", (boolean)false, (int)2, null))) continue;
                        bl20 = true;
                        break block36;
                    }
                    bl20 = false;
                }
            }
            if (!bl20) continue;
            collection5.add(element$iv$iv8);
        }
        List closePlugins = (List)collection5;
        if (!((Collection)closePlugins).isEmpty()) {
            StringBuilder stringBuilder21 = $this$showReport_u24lambda_u2418.append("Plugins with non-dynamic EPs (" + closePlugins.size() + "):");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21.append('\n'), (String)"append(...)");
            Iterable iterable10 = closePlugins;
            boolean bl21 = false;
            for (PluginUnloadabilityStatus pluginUnloadabilityStatus : CollectionsKt.sortedWith((Iterable)iterable10, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getUnspecifiedDynamicEPs().size());
                    it = (PluginUnloadabilityStatus)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getUnspecifiedDynamicEPs().size()));
                }
            })) {
                StringBuilder stringBuilder22 = $this$showReport_u24lambda_u2418.append(pluginUnloadabilityStatus.getPluginId() + " (" + pluginUnloadabilityStatus.getUnspecifiedDynamicEPs().size() + ")");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder22.append('\n'), (String)"append(...)");
                for (String string : pluginUnloadabilityStatus.getUnspecifiedDynamicEPs()) {
                    StringBuilder stringBuilder23 = $this$showReport_u24lambda_u2418.append("  " + string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder23.append('\n'), (String)"append(...)");
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
        }
        Map map = new LinkedHashMap();
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : result) {
            for (String ep4 : pluginUnloadabilityStatus.getUnspecifiedDynamicEPs()) {
                map.put(ep4, ((Number)map.getOrDefault(ep4, 0)).intValue() + 1);
            }
        }
        Iterable iterable11 = MapsKt.toList((Map)map);
        boolean bl22 = false;
        Iterable ep4 = iterable11;
        Collection destination$iv$iv8 = new ArrayList();
        boolean $i$f$filterTo8 = false;
        for (Object element$iv$iv9 : $this$filterTo$iv$iv) {
            Pair it10 = (Pair)element$iv$iv9;
            boolean bl162 = false;
            if (!(!StringsKt.startsWith$default((String)((String)it10.getFirst()), (String)"cidr", (boolean)false, (int)2, null))) continue;
            destination$iv$iv8.add(element$iv$iv9);
        }
        Iterable iterable12 = (List)destination$iv$iv8;
        boolean bl23 = false;
        List list3 = CollectionsKt.sortedWith((Iterable)iterable12, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
            }
        });
        StringBuilder stringBuilder24 = $this$showReport_u24lambda_u2418.append("EP usage statistics (" + list3.size() + " non-dynamic EPs remaining):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder24.append('\n'), (String)"append(...)");
        for (Pair pair : list3) {
            $this$showReport_u24lambda_u2418.append(pair.getSecond() + ": " + pair.getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)$this$showReport_u24lambda_u2418.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String report = string;
        String bl2 = "AnalyzeUnloadablePlugins-Report-%s.txt";
        Object[] objectArray = new Object[]{DateFormatUtil.formatDateTime((long)System.currentTimeMillis())};
        String string2 = String.format(bl2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String fileName = string2;
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)report);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private final PluginUnloadabilityStatus analyzeUnloadable(IdeaPlugin ideaPlugin, List<? extends XmlFile> allPlugins) {
        Set unspecifiedDynamicEPs = new LinkedHashSet();
        Set nonDynamicEPs = new LinkedHashSet();
        List analysisErrors = new ArrayList();
        List serviceOverrides = new ArrayList();
        List components = new ArrayList();
        this.analyzePluginFile(ideaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, true);
        AnalyzeUnloadablePluginsAction.analyzeUnloadable$analyzeDependencies(this, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, ideaPlugin);
        List componentsInOptionalDependencies = new ArrayList();
        Map nonDynamicEPsInOptionalDependencies = new LinkedHashMap();
        List serviceOverridesInDependencies = new ArrayList();
        List dependenciesWithoutSeparateClassloaders = new ArrayList();
        Iterable $this$mapNotNull$iv = allPlugins;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IdeaPlugin it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XmlFile it = (XmlFile)element$iv$iv;
            boolean bl2 = false;
            if (DescriptorUtil.getIdeaPlugin(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (IdeaPlugin descriptor : (List)destination$iv$iv) {
            for (Dependency dependency : descriptor.getDepends()) {
                if (!Intrinsics.areEqual((Object)dependency.getOptional().getValue(), (Object)true) || !Intrinsics.areEqual((Object)dependency.getValue(), (Object)ideaPlugin)) continue;
                Intrinsics.checkNotNull((Object)dependency);
                IdeaPlugin depIdeaPlugin = this.resolvePluginDependency(dependency);
                if (depIdeaPlugin == null) {
                    if (dependency.getConfigFile().getStringValue() == null) continue;
                    analysisErrors.add("Failed to resolve dependency descriptor file " + dependency.getConfigFile().getStringValue());
                    continue;
                }
                if (descriptor.getPluginId() != null) {
                    boolean bl = false;
                    if (depIdeaPlugin.getPackage().getRawText() == null) {
                        String pluginId;
                        dependenciesWithoutSeparateClassloaders.add(pluginId);
                    }
                }
                Set nonDynamicEPsInDependency = new LinkedHashSet();
                this.analyzePluginFile(depIdeaPlugin, analysisErrors, componentsInOptionalDependencies, nonDynamicEPsInDependency, nonDynamicEPsInDependency, serviceOverridesInDependencies, false);
                if (!(!((Collection)nonDynamicEPsInDependency).isEmpty())) continue;
                Map map = nonDynamicEPsInOptionalDependencies;
                String string = descriptor.getPluginId();
                if (string == null) {
                    string = "<unknown>";
                }
                map.put(string, nonDynamicEPsInDependency);
            }
        }
        String string = ideaPlugin.getPluginId();
        if (string == null) {
            string = "?";
        }
        return new PluginUnloadabilityStatus(string, unspecifiedDynamicEPs, nonDynamicEPs, nonDynamicEPsInOptionalDependencies, dependenciesWithoutSeparateClassloaders, components, serviceOverrides, analysisErrors);
    }

    private final IdeaPlugin resolvePluginDependency(Dependency dependency) {
        IdeaPlugin ideaPlugin;
        XmlFile xmlFile = dependency.getResolvedConfigFile();
        String configFileName = dependency.getConfigFile().getStringValue();
        if (xmlFile == null && configFileName != null) {
            Project project = dependency.getManager().getProject();
            Object[] objectArray = FilenameIndex.getFilesByName((Project)project, (String)configFileName, (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getFilesByName(...)");
            Object[] matchingFiles = objectArray;
            Object object = ArraysKt.singleOrNull((Object[])matchingFiles);
            xmlFile = object instanceof XmlFile ? (XmlFile)object : null;
        }
        XmlFile xmlFile2 = xmlFile;
        if (xmlFile2 != null) {
            XmlFile it = xmlFile2;
            boolean bl = false;
            ideaPlugin = DescriptorUtil.getIdeaPlugin(it);
        } else {
            ideaPlugin = null;
        }
        return ideaPlugin;
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzePluginFile(IdeaPlugin ideaPlugin, List<String> analysisErrors, List<String> components, Set<String> nonDynamicEPs, Set<String> unspecifiedDynamicEPs, List<String> serviceOverrides, boolean allowOwnEPs) {
        Collection collection;
        void $this$mapTo$iv;
        Iterable list$iv$iv;
        Object it;
        Object element$iv$iv;
        Object $this$flatMapTo$iv$iv;
        Boolean $this$flatMapTo$iv$iv2;
        List<? extends Extensions> list = ideaPlugin.getExtensions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExtensions(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv2 = iterator.next();
            Extensions it2 = (Extensions)element$iv$iv2;
            boolean bl = false;
            List<Extension> list2 = it2.collectExtensions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"collectExtensions(...)");
            Iterable list$iv$iv2 = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        for (Extension extension : (List)destination$iv$iv) {
            ExtensionPoint ep = extension.getExtensionPoint();
            if (ep == null) {
                analysisErrors.add("Cannot resolve EP " + extension.getXmlElementName());
                continue;
            }
            if (allowOwnEPs && (Intrinsics.areEqual((Object)ep.getModule(), (Object)ideaPlugin.getModule()) || Intrinsics.areEqual((Object)ep.getModule(), (Object)extension.getModule()))) continue;
            $this$flatMapTo$iv$iv2 = (Boolean)ep.getDynamic().getValue();
            if (!Intrinsics.areEqual((Object)$this$flatMapTo$iv$iv2, (Object)true)) {
                if (Intrinsics.areEqual((Object)$this$flatMapTo$iv$iv2, (Object)false)) {
                    String string = ep.getEffectiveQualifiedName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEffectiveQualifiedName(...)");
                    nonDynamicEPs.add(string);
                } else if ($this$flatMapTo$iv$iv2 == null) {
                    String string = ep.getEffectiveQualifiedName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEffectiveQualifiedName(...)");
                    unspecifiedDynamicEPs.add(string);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (!Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.applicationService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.projectService") && !Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)"com.intellij.moduleService") || !Intrinsics.areEqual((Object)extension.getXmlTag().getAttributeValue("overrides"), (Object)"true")) continue;
            String string = extension.getXmlTag().getAttributeValue("serviceInterface");
            if (string == null) {
                string = "<unknown>";
            }
            serviceOverrides.add(string);
        }
        List<? extends ApplicationComponents> list3 = ideaPlugin.getApplicationComponents();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getApplicationComponents(...)");
        Iterable $this$flatMap$iv2 = list3;
        boolean $i$f$flatMap2 = false;
        Iterable ep = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo3 = false;
        Iterator $i$f$flatMapTo22 = $this$flatMapTo$iv$iv.iterator();
        while ($i$f$flatMapTo22.hasNext()) {
            element$iv$iv = $i$f$flatMapTo22.next();
            it = (ApplicationComponents)element$iv$iv;
            boolean bl = false;
            List<? extends Component.Application> list4 = it.getComponents();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getComponents(...)");
            list$iv$iv = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            Component.Application $i$f$flatMapTo3 = (Component.Application)item$iv;
            collection = components;
            boolean bl = false;
            String string = it3.getImplementationClass().getRawText();
            if (string == null) {
                string = "?";
            }
            collection.add(string);
        }
        List<? extends ProjectComponents> list5 = ideaPlugin.getProjectComponents();
        Intrinsics.checkNotNullExpressionValue(list5, (String)"getProjectComponents(...)");
        $this$flatMap$iv2 = list5;
        $i$f$flatMap2 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo42 = false;
        Iterator bl = $this$flatMapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (ProjectComponents)element$iv$iv;
            boolean bl2 = false;
            List<? extends Component.Project> list6 = it.getComponents();
            Intrinsics.checkNotNullExpressionValue(list6, (String)"getComponents(...)");
            list$iv$iv = list6;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it4;
            Component.Project $i$f$flatMapTo42 = (Component.Project)item$iv;
            collection = components;
            boolean bl3 = false;
            String string = it4.getImplementationClass().getRawText();
            if (string == null) {
                string = "?";
            }
            collection.add(string);
        }
        List<? extends ModuleComponents> list7 = ideaPlugin.getModuleComponents();
        Intrinsics.checkNotNullExpressionValue(list7, (String)"getModuleComponents(...)");
        $this$flatMap$iv2 = list7;
        $i$f$flatMap2 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo52 = false;
        Iterator bl3 = $this$flatMapTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            element$iv$iv = bl3.next();
            it = (ModuleComponents)element$iv$iv;
            boolean bl4 = false;
            List<? extends Component.Module> list8 = it.getComponents();
            Intrinsics.checkNotNullExpressionValue(list8, (String)"getComponents(...)");
            list$iv$iv = list8;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv2;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it5;
            Component.Module $i$f$flatMapTo52 = (Component.Module)item$iv;
            collection = components;
            boolean bl5 = false;
            String string = it5.getImplementationClass().getRawText();
            if (string == null) {
                string = "?";
            }
            collection.add(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit actionPerformed$lambda$2$lambda$1(PsiDirectory $dir, Project $project, AnalyzeUnloadablePluginsAction this$0, List $result) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        PsiFile[] psiFileArray;
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        pi.setIndeterminate(false);
        GlobalSearchScope globalSearchScope = $dir == null ? GlobalSearchScopesCore.projectProductionScope((Project)$project) : GlobalSearchScopesCore.directoryScope((PsiDirectory)$dir, (boolean)true);
        Intrinsics.checkNotNull((Object)globalSearchScope);
        GlobalSearchScope searchScope = globalSearchScope;
        PsiFile[] psiFileArray2 = FilenameIndex.getFilesByName((Project)$project, (String)"plugin.xml", (GlobalSearchScope)searchScope);
        if (psiFileArray2.length == 0) {
            boolean bl = false;
            psiFileArray = FilenameIndex.getFilesByName((Project)$project, (String)"plugin.xml", (GlobalSearchScope)GlobalSearchScopesCore.projectProductionScope((Project)$project));
        } else {
            psiFileArray = psiFileArray2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"ifEmpty(...)");
        Object object = psiFileArray;
        boolean $i$f$filterIsInstance = false;
        void bl = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XmlFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pluginXmlFiles = (List)destination$iv$iv;
        object = ((Iterable)pluginXmlFiles).iterator();
        int n = 0;
        while (object.hasNext()) {
            IdeaPlugin ideaPlugin;
            int processed = n++;
            XmlFile pluginXmlFile = (XmlFile)object.next();
            pi.checkCanceled();
            pi.setFraction((double)processed / (double)pluginXmlFiles.size());
            if (!ProjectRootManager.getInstance((Project)$project).getFileIndex().isUnderSourceRootOfType(pluginXmlFile.getVirtualFile(), JavaModuleSourceRootTypes.PRODUCTION) || DescriptorUtil.getIdeaPlugin(pluginXmlFile) == null || Intrinsics.areEqual((Object)ideaPlugin.getRequireRestart().getValue(), (Object)true)) continue;
            PluginUnloadabilityStatus status = this$0.analyzeUnloadable(ideaPlugin, pluginXmlFiles);
            $result.add(status);
            pi.setText(status.getPluginId());
        }
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$2(PsiDirectory $dir, Project $project, AnalyzeUnloadablePluginsAction this$0, List $result) {
        ActionsKt.runReadAction(() -> AnalyzeUnloadablePluginsAction.actionPerformed$lambda$2$lambda$1($dir, $project, this$0, $result));
    }

    private static final void analyzeUnloadable$analyzeDependencies(AnalyzeUnloadablePluginsAction this$0, List<String> analysisErrors, List<String> components, Set<String> nonDynamicEPs, Set<String> unspecifiedDynamicEPs, List<String> serviceOverrides, IdeaPlugin ideaPlugin) {
        for (Dependency dependency : ideaPlugin.getDepends()) {
            if (dependency.getConfigFile().getStringValue() == null) continue;
            Intrinsics.checkNotNull((Object)dependency);
            IdeaPlugin depIdeaPlugin = this$0.resolvePluginDependency(dependency);
            if (depIdeaPlugin == null) {
                String configFileName;
                analysisErrors.add("Failed to resolve dependency descriptor file " + configFileName);
                continue;
            }
            this$0.analyzePluginFile(depIdeaPlugin, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, true);
            AnalyzeUnloadablePluginsAction.analyzeUnloadable$analyzeDependencies(this$0, analysisErrors, components, nonDynamicEPs, unspecifiedDynamicEPs, serviceOverrides, depIdeaPlugin);
        }
    }
}

