/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0096\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0005H&J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/AbstractKtInsertCancellationCheckFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "cancellationCheckCallFqn", "", "loopKeyword", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "getBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "addExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bodyBlock", "cancellationCheckExpression", "intellij.kotlin.devkit"})
public abstract class AbstractKtInsertCancellationCheckFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String cancellationCheckCallFqn;

    public AbstractKtInsertCancellationCheckFix(@NotNull String cancellationCheckCallFqn, @NotNull PsiElement loopKeyword) {
        Intrinsics.checkNotNullParameter((Object)cancellationCheckCallFqn, (String)"cancellationCheckCallFqn");
        Intrinsics.checkNotNullParameter((Object)loopKeyword, (String)"loopKeyword");
        super(loopKeyword);
        this.cancellationCheckCallFqn = cancellationCheckCallFqn;
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspection.insert.cancellation.check.fix.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            KtBlockExpression ktBlockExpression = this.getBlockExpression(startElement);
            if (ktBlockExpression == null) {
                return;
            }
            KtBlockExpression bodyBlock = ktBlockExpression;
            KtExpression cancellationCheckExpression = new KtPsiFactory(project, false, 2, null).createExpression(this.cancellationCheckCallFqn + "()");
            KtExpression ktExpression = this.addExpression(bodyBlock, cancellationCheckExpression);
            if (ktExpression == null) break block1;
            KtExpression it = ktExpression;
            boolean bl = false;
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)it);
        }
    }

    @Nullable
    public abstract KtBlockExpression getBlockExpression(@NotNull PsiElement var1);

    @Nullable
    public abstract KtExpression addExpression(@NotNull KtBlockExpression var1, @NotNull KtExpression var2);
}

