/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.kotlin.DevKitKotlinBundle;
import org.jetbrains.idea.devkit.kotlin.inspections.CompanionObjectInExtensionInspection;
import org.jetbrains.idea.devkit.kotlin.inspections.CompanionObjectInExtensionInspectionKt;
import org.jetbrains.idea.devkit.kotlin.inspections.CreateObjectAndMoveProhibitedDeclarationsQuickFix;
import org.jetbrains.idea.devkit.kotlin.inspections.MoveProhibitedDeclarationsToTopLevelFix;
import org.jetbrains.idea.devkit.kotlin.inspections.RemoveEmptyCompanionObjectFix;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/CompanionObjectInExtensionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.kotlin.devkit"})
public final class CompanionObjectInExtensionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!DevKitInspectionUtil.isAllowed(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitObjectDeclaration(KtObjectDeclaration declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (!declaration.isCompanion()) {
                    return;
                }
                LocalQuickFix[] $this$getStrictParentOfType$iv = (LocalQuickFix[])declaration;
                boolean $i$f$getStrictParentOfType = false;
                KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
                if (ktClass == null || (ktClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass))) == null) {
                    return;
                }
                KtClass ktLightClass = ktClass;
                if (!ExtensionUtil.isExtensionPointImplementationCandidate((PsiClass)ktLightClass)) {
                    return;
                }
                if (!ExtensionUtil.INSTANCE.isInstantiatedExtension((PsiClass)ktLightClass, (Function1<? super Extension, Boolean>)((Function1)buildVisitor.1::visitObjectDeclaration$lambda$0))) {
                    return;
                }
                KtModifierList ktModifierList = declaration.getModifierList();
                if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.COMPANION_KEYWORD)) == null) {
                    return;
                }
                KtModifierList anchor = ktModifierList;
                if (CompanionObjectInExtensionInspectionKt.access$isEmpty(declaration)) {
                    $this$getStrictParentOfType$iv = new LocalQuickFix[]{new RemoveEmptyCompanionObjectFix(declaration)};
                    this.$holder.registerProblem((PsiElement)anchor, DevKitKotlinBundle.INSTANCE.message("inspections.empty.companion.object.in.extension.message", new Object[0]), ProblemHighlightType.WARNING, $this$getStrictParentOfType$iv);
                } else {
                    void $this$filterNotTo$iv$iv;
                    Iterable $this$filterNot$iv = CompanionObjectInExtensionInspectionKt.access$getNamedDeclarations(declaration);
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                        boolean bl = false;
                        if (CompanionObjectInExtensionInspectionKt.access$isAllowedInsideCompanionObject((KtDeclaration)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List prohibitedDeclarations = (List)destination$iv$iv;
                    if (prohibitedDeclarations.isEmpty()) {
                        return;
                    }
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new MoveProhibitedDeclarationsToTopLevelFix(declaration), new CreateObjectAndMoveProhibitedDeclarationsQuickFix(declaration)};
                    this.$holder.registerProblem((PsiElement)anchor, DevKitKotlinBundle.INSTANCE.message("inspections.companion.object.in.extension.message", new Object[0]), ProblemHighlightType.WARNING, localQuickFixArray);
                }
            }

            private static final boolean visitObjectDeclaration$lambda$0(Extension it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ExtensionUtil.INSTANCE.hasServiceBeanFqn(it);
            }
        };
    }
}

