/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldNotBePublicProvider;
import org.jetbrains.idea.devkit.kotlin.inspections.ChangeModifierFix;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J%\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0005H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ExtensionClassShouldNotBePublicProviderForKotlin;", "Lorg/jetbrains/idea/devkit/inspections/ExtensionClassShouldNotBePublicProvider;", "<init>", "()V", "isPublic", "", "aClass", "Lcom/intellij/psi/PsiClass;", "provideQuickFix", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "clazz", "Lcom/intellij/lang/jvm/JvmClass;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/lang/jvm/JvmClass;Lcom/intellij/psi/PsiFile;)[Lcom/intellij/codeInspection/LocalQuickFix;", "isApplicableForKotlin", "intellij.kotlin.devkit"})
public final class ExtensionClassShouldNotBePublicProviderForKotlin
implements ExtensionClassShouldNotBePublicProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPublic(@NotNull PsiClass aClass) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        if (!(aClass instanceof KtLightClass)) return false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)((KtLightClass)aClass).getKotlinOrigin();
        if (ktClassOrObject == null) return false;
        if (!KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)ktClassOrObject))) return false;
        return true;
    }

    @Override
    @NotNull
    public LocalQuickFix[] provideQuickFix(@NotNull JvmClass clazz, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ChangeModifierFix[] changeModifierFixArray = new ChangeModifierFix[1];
        String string = clazz.getName();
        Intrinsics.checkNotNull((Object)string);
        changeModifierFixArray[0] = new ChangeModifierFix(string);
        return changeModifierFixArray;
    }

    @Override
    public boolean isApplicableForKotlin() {
        return true;
    }
}

