/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.kotlin.DevKitKotlinBundle;
import org.jetbrains.idea.devkit.kotlin.inspections.BlockingContextFunctionBodyVisitor;
import org.jetbrains.idea.devkit.kotlin.inspections.BlockingContextKt;
import org.jetbrains.idea.devkit.kotlin.inspections.ForbiddenInSuspectContextMethodInspectionKt;
import org.jetbrains.idea.devkit.util.BlockingContextInspectionsKt;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotated;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbol;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaNamedSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.psi.imports.ImportInsertionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f\u00b2\u0006\n\u0010\r\u001a\u00020\u000eX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createFileVisitor", "BlockingContextMethodsCallsVisitor", "intellij.kotlin.devkit", "blockingContextCallsVisitor", "Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor;"})
public final class ForbiddenInSuspectContextMethodInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (BlockingContextInspectionsKt.isInspectionForBlockingContextAvailable(holder)) {
            psiElementVisitor = this.createFileVisitor(holder);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        }
        return psiElementVisitor;
    }

    private final PsiElementVisitor createFileVisitor(ProblemsHolder holder) {
        Lazy blockingContextCallsVisitor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ForbiddenInSuspectContextMethodInspection.createFileVisitor$lambda$0(holder));
        return (PsiElementVisitor)new KtTreeVisitorVoid((Lazy<BlockingContextMethodsCallsVisitor>)blockingContextCallsVisitor$delegate){
            final /* synthetic */ Lazy<BlockingContextMethodsCallsVisitor> $blockingContextCallsVisitor$delegate;
            {
                this.$blockingContextCallsVisitor$delegate = $blockingContextCallsVisitor$delegate;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            }

            public void visitNamedFunction(KtNamedFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                if (function.hasModifier(KtTokens.SUSPEND_KEYWORD) && !ForbiddenInSuspectContextMethodInspectionKt.access$isSuspensionRestricted(function)) {
                    KtExpression ktExpression = function.getBodyExpression();
                    if (ktExpression != null) {
                        ktExpression.accept((PsiElementVisitor)ForbiddenInSuspectContextMethodInspection.access$createFileVisitor$lambda$1(this.$blockingContextCallsVisitor$delegate));
                    }
                    return;
                }
                super.visitNamedFunction(function);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitLambdaExpression(KtLambdaExpression lambdaExpression) {
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
                Lazy<BlockingContextMethodsCallsVisitor> lazy = this.$blockingContextCallsVisitor$delegate;
                boolean $i$f$analyze = false;
                Project project = ((KtElement)lambdaExpression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)lambdaExpression);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)lambdaExpression);
                try {
                    Unit unit;
                    Object lock$iv$iv;
                    Object object = lock$iv$iv = new Object();
                    synchronized (object) {
                        block9: {
                            KaType type;
                            boolean bl = false;
                            KaSession $this$visitLambdaExpression_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            KaType kaType = type = $this$visitLambdaExpression_u24lambda_u240.getExpressionType((KtExpression)lambdaExpression);
                            boolean bl3 = kaType != null ? $this$visitLambdaExpression_u24lambda_u240.isSuspendFunctionType(kaType) : false;
                            if (!bl3 || ForbiddenInSuspectContextMethodInspectionKt.access$isSuspensionRestricted($this$visitLambdaExpression_u24lambda_u240, type)) break block9;
                            KtBlockExpression ktBlockExpression = lambdaExpression.getBodyExpression();
                            if (ktBlockExpression != null) {
                                ktBlockExpression.accept((PsiElementVisitor)ForbiddenInSuspectContextMethodInspection.access$createFileVisitor$lambda$1(lazy));
                            }
                            return;
                        }
                        unit = Unit.INSTANCE;
                    }
                    Unit unit2 = unit;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)lambdaExpression);
                }
                super.visitLambdaExpression(lambdaExpression);
            }
        };
    }

    private static final BlockingContextMethodsCallsVisitor createFileVisitor$lambda$0(ProblemsHolder $holder) {
        return new BlockingContextMethodsCallsVisitor($holder);
    }

    private static final BlockingContextMethodsCallsVisitor createFileVisitor$lambda$1(Lazy<BlockingContextMethodsCallsVisitor> $blockingContextCallsVisitor$delegate) {
        Lazy<BlockingContextMethodsCallsVisitor> lazy = $blockingContextCallsVisitor$delegate;
        return (BlockingContextMethodsCallsVisitor)((Object)lazy.getValue());
    }

    public static final /* synthetic */ BlockingContextMethodsCallsVisitor access$createFileVisitor$lambda$1(Lazy $blockingContextCallsVisitor$delegate) {
        return ForbiddenInSuspectContextMethodInspection.createFileVisitor$lambda$1((Lazy<BlockingContextMethodsCallsVisitor>)$blockingContextCallsVisitor$delegate);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001:\u0005\u001d\u001e\u001f !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0082\bJ\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor;", "Lorg/jetbrains/idea/devkit/kotlin/inspections/BlockingContextFunctionBodyVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitedSymbols", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "callingElement", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallExpression", "", "expression", "checkCalledFunction", "call", "calledSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "ifInSuspend", "Lcom/intellij/codeInspection/LocalQuickFix;", "fix", "Lkotlin/Function0;", "generalFixes", "", "()[Lcom/intellij/codeInspection/LocalQuickFix;", "provideFixesForInvokeLater", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "callExpression", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)[Lcom/intellij/codeInspection/LocalQuickFix;", "ReplaceProgressManagerCheckCanceledQuickFix", "ReplaceInvokeAndWaitWithWithContextQuickFix", "ReplaceInvokeLaterWithWithContextQuickFix", "ReplaceInvokeLaterWithLaunchQuickFix", "NavigateToCallInSuspendFunction", "intellij.kotlin.devkit"})
    @SourceDebugExtension(value={"SMAP\nForbiddenInSuspectContextMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenInSuspectContextMethodInspection.kt\norg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,364:1\n187#1:379\n187#1:381\n28#2,2:365\n36#3,12:367\n48#3:383\n1#4:380\n1#4:382\n1#4:384\n1755#5,3:385\n*S KotlinDebug\n*F\n+ 1 ForbiddenInSuspectContextMethodInspection.kt\norg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor\n*L\n129#1:379\n137#1:381\n106#1:365,2\n106#1:367,12\n106#1:383\n129#1:380\n137#1:382\n202#1:385,3\n*E\n"})
    private static final class BlockingContextMethodsCallsVisitor
    extends BlockingContextFunctionBodyVisitor {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final Set<KaSymbol> visitedSymbols;
        @Nullable
        private KtCallExpression callingElement;

        public BlockingContextMethodsCallsVisitor(@NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
            this.visitedSymbols = new LinkedHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            KaFunctionSymbol calledSymbol;
            Object object;
            KaSession $this$visitCallExpression_u24lambda_u242;
            KaSession analysisSession$iv$iv;
            KaSessionProvider this_$iv$iv;
            block23: {
                Object lock$iv$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                boolean $i$f$analyze = false;
                Project project = ((KtElement)expression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                boolean $i$f$analyze2 = false;
                analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression);
                Object object2 = lock$iv$iv = new Object();
                // MONITORENTER : object2
                boolean bl = false;
                $this$visitCallExpression_u24lambda_u242 = analysisSession$iv$iv;
                boolean bl2 = false;
                KaCallInfo kaCallInfo = $this$visitCallExpression_u24lambda_u242.resolveToCall((KtElement)expression);
                object = kaCallInfo != null ? KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaCallInfo) : null;
                KaFunctionCall kaFunctionCall = object;
                KaFunctionSymbol kaFunctionSymbol = kaFunctionCall != null && (kaFunctionCall = kaFunctionCall.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol((KaPartiallyAppliedSymbol)kaFunctionCall) : (calledSymbol = null);
                if (calledSymbol instanceof KaNamedSymbol) break block23;
                // MONITOREXIT : object2
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
                return;
            }
            boolean hasAnnotation = ((KaAnnotated)calledSymbol).getAnnotations().contains(BlockingContextKt.getRequiresBlockingContextAnnotationId());
            if (!hasAnnotation) {
                if (calledSymbol instanceof KaNamedFunctionSymbol) {
                    this.checkCalledFunction(expression, (KaNamedFunctionSymbol)calledSymbol);
                }
                if (calledSymbol instanceof KaNamedFunctionSymbol && ((KaNamedFunctionSymbol)calledSymbol).isInline()) {
                    this.checkInlineLambdaArguments((KaFunctionCall<?>)object);
                }
                super.visitCallExpression(expression);
                // MONITOREXIT : object2
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
                return;
            }
            try {
                FqName fqName;
                CallableId callableId = ((KaCallableSymbol)calledSymbol).getCallableId();
                Object object3 = fqName = callableId != null ? callableId.asSingleFqName() : null;
                if (Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getProgressManagerCheckedCanceledName$p())) {
                    LocalQuickFix localQuickFix;
                    LocalQuickFix[] localQuickFixArray;
                    ProblemsHolder problemsHolder = this.holder;
                    PsiElement psiElement = (PsiElement)BlockingContextKt.extractElementToHighlight(expression);
                    String string = DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.check.canceled.text", new Object[0]);
                    ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    LocalQuickFix[] localQuickFixArray2 = localQuickFixArray = new LocalQuickFix[1];
                    int n = 0;
                    BlockingContextMethodsCallsVisitor this_$iv = this;
                    boolean $i$f$ifInSuspend = false;
                    KtCallExpression ktCallExpression = this_$iv.callingElement;
                    if (ktCallExpression != null) {
                        KtCallExpression it$iv = ktCallExpression;
                        boolean bl = false;
                        localQuickFix = (LocalQuickFix)new NavigateToCallInSuspendFunction(it$iv);
                    } else {
                        int n2 = n;
                        LocalQuickFix[] localQuickFixArray3 = localQuickFixArray2;
                        ProblemHighlightType problemHighlightType2 = problemHighlightType;
                        String string2 = string;
                        PsiElement psiElement2 = psiElement;
                        ProblemsHolder problemsHolder2 = problemsHolder;
                        boolean bl = false;
                        LocalQuickFix localQuickFix2 = (LocalQuickFix)new ReplaceProgressManagerCheckCanceledQuickFix((PsiElement)expression);
                        problemsHolder = problemsHolder2;
                        psiElement = psiElement2;
                        string = string2;
                        problemHighlightType = problemHighlightType2;
                        localQuickFixArray2 = localQuickFixArray3;
                        n = n2;
                        localQuickFix = localQuickFix2;
                    }
                    localQuickFixArray2[n] = localQuickFix;
                    problemsHolder.registerProblem(psiElement, string, problemHighlightType, localQuickFixArray);
                } else if (Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getApplicationInvokeAndWaitName$p()) || Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getInvokeAndWaitIfNeeded$p())) {
                    LocalQuickFix localQuickFix;
                    LocalQuickFix[] localQuickFixArray;
                    ProblemsHolder problemsHolder = this.holder;
                    PsiElement psiElement = (PsiElement)BlockingContextKt.extractElementToHighlight(expression);
                    String string = DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.and.wait.text", new Object[0]);
                    ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    LocalQuickFix[] localQuickFixArray4 = localQuickFixArray = new LocalQuickFix[1];
                    int n = 0;
                    BlockingContextMethodsCallsVisitor this_$iv = this;
                    boolean $i$f$ifInSuspend = false;
                    KtCallExpression ktCallExpression = this_$iv.callingElement;
                    if (ktCallExpression != null) {
                        KtCallExpression it$iv = ktCallExpression;
                        boolean bl = false;
                        localQuickFix = (LocalQuickFix)new NavigateToCallInSuspendFunction(it$iv);
                    } else {
                        int n3 = n;
                        LocalQuickFix[] localQuickFixArray5 = localQuickFixArray4;
                        ProblemHighlightType problemHighlightType3 = problemHighlightType;
                        String string3 = string;
                        PsiElement psiElement3 = psiElement;
                        ProblemsHolder problemsHolder3 = problemsHolder;
                        boolean bl = false;
                        LocalQuickFix localQuickFix3 = (LocalQuickFix)new ReplaceInvokeAndWaitWithWithContextQuickFix((PsiElement)expression);
                        problemsHolder = problemsHolder3;
                        psiElement = psiElement3;
                        string = string3;
                        problemHighlightType = problemHighlightType3;
                        localQuickFixArray4 = localQuickFixArray5;
                        n = n3;
                        localQuickFix = localQuickFix3;
                    }
                    localQuickFixArray4[n] = localQuickFix;
                    problemsHolder.registerProblem(psiElement, string, problemHighlightType, localQuickFixArray);
                } else if (Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getApplicationGetDefaultModalityState$p()) || Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getModalityStateDefaultModalityState$p())) {
                    this.holder.registerProblem((PsiElement)BlockingContextKt.extractElementToHighlight(expression), DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.default.modality.state.text", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                } else if (Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getApplicationInvokeLater$p()) || Intrinsics.areEqual((Object)fqName, (Object)ForbiddenInSuspectContextMethodInspectionKt.access$getInvokeLaterKt$p())) {
                    LocalQuickFix[] localQuickFixArray = this.provideFixesForInvokeLater($this$visitCallExpression_u24lambda_u242, expression);
                    this.holder.registerProblem((PsiElement)BlockingContextKt.extractElementToHighlight(expression), DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.later.text", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                } else {
                    Object[] objectArray = new Object[]{((KaNamedSymbol)calledSymbol).getName().asString()};
                    String string = DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.text", objectArray);
                    objectArray = this.generalFixes();
                    this.holder.registerProblem((PsiElement)BlockingContextKt.extractElementToHighlight(expression), string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
                }
                Unit unit = Unit.INSTANCE;
                // MONITOREXIT : object2
                Unit unit2 = unit;
                return;
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void checkCalledFunction(KtCallExpression call, KaNamedFunctionSymbol calledSymbol) {
            PsiElement psiElement = calledSymbol.getPsi();
            if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getContainingFile() : null), (Object)this.holder.getFile()) && !calledSymbol.isSuspend() && !this.visitedSymbols.contains(calledSymbol) && this.callingElement == null) {
                try {
                    ((Collection)this.visitedSymbols).add(calledSymbol);
                    this.callingElement = call;
                    PsiElement psiElement2 = calledSymbol.getPsi();
                    KtNamedFunction ktNamedFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
                    if (ktNamedFunction != null && (ktNamedFunction = ktNamedFunction.getBodyExpression()) != null) {
                        ktNamedFunction.accept((PsiElementVisitor)this);
                    }
                }
                finally {
                    this.callingElement = null;
                }
            }
        }

        private final LocalQuickFix ifInSuspend(Function0<? extends LocalQuickFix> fix) {
            LocalQuickFix localQuickFix;
            boolean $i$f$ifInSuspend = false;
            KtCallExpression ktCallExpression = this.callingElement;
            if (ktCallExpression != null) {
                KtCallExpression it = ktCallExpression;
                boolean bl = false;
                localQuickFix = (LocalQuickFix)new NavigateToCallInSuspendFunction(it);
            } else {
                localQuickFix = (LocalQuickFix)fix.invoke();
            }
            return localQuickFix;
        }

        private final LocalQuickFix[] generalFixes() {
            LocalQuickFix[] localQuickFixArray;
            KtCallExpression ktCallExpression = this.callingElement;
            if (ktCallExpression != null) {
                KtCallExpression it = ktCallExpression;
                boolean bl = false;
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{new NavigateToCallInSuspendFunction(it)};
                localQuickFixArray = localQuickFixArray2;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            }
            return localQuickFixArray;
        }

        private final LocalQuickFix[] provideFixesForInvokeLater(KaSession $this$provideFixesForInvokeLater, KtCallExpression callExpression) {
            boolean hasCoroutineScope;
            Object $this$provideFixesForInvokeLater_u24lambda_u247;
            Object object;
            block5: {
                object = this.callingElement;
                if (object != null) {
                    KtCallExpression it = object;
                    boolean bl = false;
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new NavigateToCallInSuspendFunction(it)};
                    return localQuickFixArray;
                }
                $this$provideFixesForInvokeLater_u24lambda_u247 = object = CollectionsKt.createListBuilder();
                boolean bl = false;
                $this$provideFixesForInvokeLater_u24lambda_u247.add(new ReplaceInvokeLaterWithWithContextQuickFix((PsiElement)callExpression));
                List implicitReceiverTypesAtPosition = $this$provideFixesForInvokeLater.collectImplicitReceiverTypes((KtElement)callExpression);
                ClassId coroutineScopeClassId = ClassId.Companion.topLevel(new FqName("kotlinx.coroutines.CoroutineScope"));
                Iterable $this$any$iv = implicitReceiverTypesAtPosition;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KaType it = (KaType)element$iv;
                        boolean bl2 = false;
                        if (!KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)((KaTypeRelationChecker)$this$provideFixesForInvokeLater), (KaType)it, (ClassId)coroutineScopeClassId, null, (int)2, null)) continue;
                        v0 = true;
                        break block5;
                    }
                    v0 = hasCoroutineScope = false;
                }
            }
            if (hasCoroutineScope) {
                $this$provideFixesForInvokeLater_u24lambda_u247.add(new ReplaceInvokeLaterWithLaunchQuickFix((PsiElement)callExpression));
            }
            Collection collection = CollectionsKt.build((List)object);
            Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return (LocalQuickFix[])UtilKt.toArray((Collection)collection, (Object[])LocalQuickFix.EMPTY_ARRAY);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$NavigateToCallInSuspendFunction;", "Lcom/intellij/codeInspection/IntentionAndQuickFixAction;", "callingElement", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getFamilyName", "", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "applyFix", "", "startInWriteAction", "getName", "intellij.kotlin.devkit"})
        private static final class NavigateToCallInSuspendFunction
        extends IntentionAndQuickFixAction {
            @NotNull
            private final SmartPsiElementPointer<KtCallExpression> pointer;

            public NavigateToCallInSuspendFunction(@NotNull KtCallExpression callingElement) {
                Intrinsics.checkNotNullParameter((Object)callingElement, (String)"callingElement");
                SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)callingElement));
                Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
                this.pointer = smartPsiElementPointer;
            }

            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.navigate.to.suspend.context", new Object[0]);
            }

            public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return editor != null && this.pointer.getElement() != null;
            }

            public void applyFix(@NotNull Project project, @Nullable PsiFile file, @Nullable Editor editor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PsiElement psiElement = this.pointer.getElement();
                Intrinsics.checkNotNull((Object)psiElement);
                BlockingContextKt.extractElementToHighlight((KtCallExpression)psiElement).navigate(true);
            }

            public boolean startInWriteAction() {
                return false;
            }

            @NotNull
            public String getName() {
                return this.getFamilyName();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J3\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceInvokeAndWaitWithWithContextQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.kotlin.devkit"})
        private static class ReplaceInvokeAndWaitWithWithContextQuickFix
        extends LocalQuickFixAndIntentionActionOnPsiElement {
            public ReplaceInvokeAndWaitWithWithContextQuickFix(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super(element);
            }

            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.and.wait.fix.text", new Object[0]);
            }

            @NotNull
            public String getText() {
                return this.getFamilyName();
            }

            public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                if (ktCallExpression == null) {
                    return false;
                }
                KtCallExpression callExpression = ktCallExpression;
                return ForbiddenInSuspectContextMethodInspectionKt.access$getLambdaArgumentExpression(callExpression) != null;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                Intrinsics.checkNotNull((Object)ktCallExpression);
                KtCallExpression callExpression = ktCallExpression;
                KtFile ktFile = callExpression.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                KtFile ktFile2 = ktFile;
                if (!ForbiddenInSuspectContextMethodInspectionKt.access$isImported(ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p(), ktFile2)) {
                    ImportInsertionKt.addImport$default((KtFile)ktFile2, (FqName)ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p(), (boolean)false, null, null, (int)14, null);
                }
                ForbiddenInSuspectContextMethodInspectionKt.access$replaceMethodInCallWithLambda(callExpression, "kotlinx.coroutines.withContext(kotlinx.coroutines.Dispatchers." + ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p().shortName().asString() + ") {}");
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J3\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceInvokeLaterWithLaunchQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.kotlin.devkit"})
        private static final class ReplaceInvokeLaterWithLaunchQuickFix
        extends LocalQuickFixAndIntentionActionOnPsiElement {
            public ReplaceInvokeLaterWithLaunchQuickFix(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super(element);
            }

            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.later.fix.launch.text", new Object[0]);
            }

            @NotNull
            public String getText() {
                return this.getFamilyName();
            }

            public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                if (ktCallExpression == null) {
                    return false;
                }
                KtCallExpression callExpression = ktCallExpression;
                return ForbiddenInSuspectContextMethodInspectionKt.access$getLambdaArgumentExpression(callExpression) != null;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                Intrinsics.checkNotNull((Object)ktCallExpression);
                KtCallExpression callExpression = ktCallExpression;
                KtFile ktFile = callExpression.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                KtFile ktFile2 = ktFile;
                if (!ForbiddenInSuspectContextMethodInspectionKt.access$isImported(ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p(), ktFile2)) {
                    ImportInsertionKt.addImport$default((KtFile)ktFile2, (FqName)ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p(), (boolean)false, null, null, (int)14, null);
                }
                FqName fqName = ForbiddenInSuspectContextMethodInspectionKt.access$getCoroutinesLaunch$p();
                KtFile ktFile3 = callExpression.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"getContainingKtFile(...)");
                if (!ForbiddenInSuspectContextMethodInspectionKt.access$isImported(fqName, ktFile3)) {
                    ImportInsertionKt.addImport$default((KtFile)ktFile2, (FqName)ForbiddenInSuspectContextMethodInspectionKt.access$getCoroutinesLaunch$p(), (boolean)false, null, null, (int)14, null);
                }
                ForbiddenInSuspectContextMethodInspectionKt.access$replaceMethodInCallWithLambda(callExpression, ForbiddenInSuspectContextMethodInspectionKt.access$getCoroutinesLaunch$p().shortName() + "(kotlinx.coroutines.Dispatchers." + ForbiddenInSuspectContextMethodInspectionKt.access$getIntelliJEdtDispatcher$p().shortName() + ") {}");
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceInvokeLaterWithWithContextQuickFix;", "Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceInvokeAndWaitWithWithContextQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "intellij.kotlin.devkit"})
        private static final class ReplaceInvokeLaterWithWithContextQuickFix
        extends ReplaceInvokeAndWaitWithWithContextQuickFix {
            public ReplaceInvokeLaterWithWithContextQuickFix(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super(element);
            }

            @Override
            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.invoke.later.fix.with.context.text", new Object[0]);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J3\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ForbiddenInSuspectContextMethodInspection$BlockingContextMethodsCallsVisitor$ReplaceProgressManagerCheckCanceledQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.kotlin.devkit"})
        private static final class ReplaceProgressManagerCheckCanceledQuickFix
        extends LocalQuickFixAndIntentionActionOnPsiElement {
            public ReplaceProgressManagerCheckCanceledQuickFix(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super(element);
            }

            @NotNull
            public String getFamilyName() {
                return DevKitKotlinBundle.INSTANCE.message("inspections.forbidden.method.in.suspend.context.check.canceled.fix.text", new Object[0]);
            }

            @NotNull
            public String getText() {
                return this.getFamilyName();
            }

            public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                return ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement) != null;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                KtQualifiedExpression qualifiedExpression;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                KtCallExpression ktCallExpression = ForbiddenInSuspectContextMethodInspectionKt.access$getCallExpression(startElement);
                Intrinsics.checkNotNull((Object)ktCallExpression);
                KtCallExpression callExpression = ktCallExpression;
                KtPsiFactory factory = new KtPsiFactory(project, false, 2, null);
                KtExpression suspendAwareCheckCanceled = factory.createExpression("com.intellij.openapi.progress.checkCancelled()");
                KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)callExpression));
                KtExpression expressionToReplace = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)callExpression;
                PsiElement resultExpression = expressionToReplace.replace((PsiElement)suspendAwareCheckCanceled);
                ShortenReferencesFacility shortenReferencesFacility = ShortenReferencesFacility.Companion.getInstance();
                Intrinsics.checkNotNull((Object)resultExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                shortenReferencesFacility.shorten((KtElement)resultExpression);
            }
        }
    }
}

