/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.AddServiceAnnotationProvider;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationFix;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/KotlinAddServiceAnnotationProvider;", "Lorg/jetbrains/idea/devkit/inspections/quickfix/AddServiceAnnotationProvider;", "<init>", "()V", "addServiceAnnotation", "", "aClass", "Lcom/intellij/psi/PsiElement;", "level", "Lcom/intellij/openapi/components/Service$Level;", "intellij.kotlin.devkit"})
public final class KotlinAddServiceAnnotationProvider
implements AddServiceAnnotationProvider {
    @Override
    public void addServiceAnnotation(@NotNull PsiElement aClass, @NotNull Service.Level level) {
        KtClassOrObject ktClass;
        KtClassOrObject ktClassOrObject;
        KtClassOrObject ktClassOrObject2;
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        PsiElement psiElement = aClass;
        if (psiElement instanceof KtClass) {
            ktClassOrObject2 = (KtClassOrObject)aClass;
        } else if (psiElement instanceof KtLightClass) {
            ktClassOrObject2 = (KtClassOrObject)((KtLightClass)aClass).getKotlinOrigin();
        } else {
            return;
        }
        if ((ktClassOrObject = (ktClass = ktClassOrObject2)) == null || (ktClassOrObject = ktClassOrObject.getContainingFile()) == null) {
            return;
        }
        KtClassOrObject file = ktClassOrObject;
        String string = Service.class.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        ClassId annotationClassId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)string, (boolean)false, (int)2, null);
        AddAnnotationFix fix = switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1 -> new AddAnnotationFix((KtElement)ktClass, annotationClassId, (AddAnnotationFix.Kind)AddAnnotationFix.Kind.Self.INSTANCE, null, null, 24, null);
            case 2 -> new AddAnnotationFix((KtElement)ktClass, annotationClassId, (AddAnnotationFix.Kind)AddAnnotationFix.Kind.Self.INSTANCE, CollectionsKt.listOf((Object)ServiceUtil.getProjectLevelFQN()), null, 16, null);
            default -> throw new NoWhenBranchMatchedException();
        };
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        fix.invoke(project, null, (PsiFile)file);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Service.Level.values().length];
            try {
                nArray[Service.Level.APP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Service.Level.PROJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

