/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.kotlin.DevKitKotlinBundle;
import org.jetbrains.idea.devkit.kotlin.inspections.KotlinObjectExtensionRegistrationInspectionKt;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u000eH\u0002J\f\u0010\u000f\u001a\u00020\r*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/KotlinObjectExtensionRegistrationInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitPluginXmlInspectionBase;", "<init>", "()V", "checkDomElement", "", "element", "Lcom/intellij/util/xml/DomElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "helper", "Lcom/intellij/util/xml/highlighting/DomHighlightingHelper;", "isKotlinObjectReference", "", "Lcom/intellij/util/xml/GenericDomValue;", "isValidIdentifier", "Lorg/jetbrains/kotlin/name/FqName;", "intellij.kotlin.devkit"})
@SourceDebugExtension(value={"SMAP\nKotlinObjectExtensionRegistrationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinObjectExtensionRegistrationInspection.kt\norg/jetbrains/idea/devkit/kotlin/inspections/KotlinObjectExtensionRegistrationInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class KotlinObjectExtensionRegistrationInspection
extends DevKitPluginXmlInspectionBase {
    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Extension extension = element instanceof Extension ? (Extension)element : null;
        if (extension == null) {
            return;
        }
        Extension extension2 = extension;
        if (!this.isAllowed(holder)) {
            return;
        }
        if (KotlinObjectExtensionRegistrationInspectionKt.access$isAllowed(extension2)) {
            return;
        }
        for (GenericDomValue<?> classNameDomValue : ExtensionUtil.INSTANCE.getClassNameDomValues(extension2)) {
            if (!this.isKotlinObjectReference(classNameDomValue)) continue;
            holder.createProblem((DomElement)classNameDomValue, DevKitKotlinBundle.INSTANCE.message("inspections.plugin.extension.registers.kotlin.object", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private final boolean isKotlinObjectReference(GenericDomValue<?> $this$isKotlinObjectReference) {
        FqName fqName;
        Module module = $this$isKotlinObjectReference.getModule();
        if (module == null || (module = module.getProject()) == null) {
            return false;
        }
        Module project = module;
        String className = $this$isKotlinObjectReference.getStringValue();
        CharSequence charSequence = className;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String string = ExtensionUtil.INSTANCE.getNormalizedClassName(className);
        if (string == null) {
            return false;
        }
        String normalizedClassName = string;
        FqName it = fqName = new FqName(normalizedClassName);
        boolean bl = false;
        Object object = this.isValidIdentifier(it) ? fqName : null;
        if (object == null) {
            return false;
        }
        FqName fqName2 = object;
        KotlinAsJavaSupport kotlinAsJavaSupport = (KotlinAsJavaSupport)project.getService(KotlinAsJavaSupport.class);
        if (kotlinAsJavaSupport == null) {
            return false;
        }
        KotlinAsJavaSupport kotlinAsJavaSupport2 = kotlinAsJavaSupport;
        GlobalSearchScope globalSearchScope = $this$isKotlinObjectReference.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
        Collection classOrObjectDeclarations = kotlinAsJavaSupport2.findClassOrObjectDeclarations(fqName2, globalSearchScope);
        return classOrObjectDeclarations.size() == 1 && CollectionsKt.firstOrNull((Iterable)classOrObjectDeclarations) instanceof KtObjectDeclaration;
    }

    private final boolean isValidIdentifier(FqName $this$isValidIdentifier) {
        Name name;
        Object object;
        Name it = object = $this$isValidIdentifier.shortName();
        boolean bl = false;
        Object object2 = name = !it.isSpecial() ? object : null;
        return name != null && (object = name.getIdentifier()) != null ? ((CharSequence)object).length() > 0 : false;
    }
}

