/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.kotlin.inspections.AbstractKtInsertCancellationCheckFix;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.AddBracesIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.RedundantSemicolonUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/KtInsertCancellationCheckInLoopFix;", "Lorg/jetbrains/idea/devkit/kotlin/inspections/AbstractKtInsertCancellationCheckFix;", "cancellationCheckCallFqn", "", "loopKeyword", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "startElement", "addExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bodyBlock", "cancellationCheckExpression", "getOrCreateBodyBlock", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "project", "Lcom/intellij/openapi/project/Project;", "deleteRedundantSemicolon", "", "loop", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "endElement", "intellij.kotlin.devkit"})
@SourceDebugExtension(value={"SMAP\nKtCancellationCheckInLoopsFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtCancellationCheckInLoopsFixProvider.kt\norg/jetbrains/idea/devkit/kotlin/inspections/KtInsertCancellationCheckInLoopFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,119:1\n66#2,2:120\n66#2,2:122\n*S KotlinDebug\n*F\n+ 1 KtCancellationCheckInLoopsFixProvider.kt\norg/jetbrains/idea/devkit/kotlin/inspections/KtInsertCancellationCheckInLoopFix\n*L\n39#1:120,2\n76#1:122,2\n*E\n"})
public final class KtInsertCancellationCheckInLoopFix
extends AbstractKtInsertCancellationCheckFix {
    public KtInsertCancellationCheckInLoopFix(@NotNull String cancellationCheckCallFqn, @NotNull PsiElement loopKeyword) {
        Intrinsics.checkNotNullParameter((Object)cancellationCheckCallFqn, (String)"cancellationCheckCallFqn");
        Intrinsics.checkNotNullParameter((Object)loopKeyword, (String)"loopKeyword");
        super(cancellationCheckCallFqn, loopKeyword);
    }

    @Override
    @Nullable
    public KtBlockExpression getBlockExpression(@NotNull PsiElement startElement) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        PsiElement $this$parentOfType_u24default$iv = startElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtLoopExpression ktLoopExpression = (KtLoopExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtLoopExpression.class, (boolean)true);
        if (ktLoopExpression == null) {
            return null;
        }
        KtLoopExpression loopStatement = ktLoopExpression;
        Project project = startElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getOrCreateBodyBlock(loopStatement, project);
    }

    @Override
    @Nullable
    public KtExpression addExpression(@NotNull KtBlockExpression bodyBlock, @NotNull KtExpression cancellationCheckExpression) {
        Intrinsics.checkNotNullParameter((Object)bodyBlock, (String)"bodyBlock");
        Intrinsics.checkNotNullParameter((Object)cancellationCheckExpression, (String)"cancellationCheckExpression");
        Project project = bodyBlock.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)bodyBlock);
        PsiElement psiElement = bodyBlock.addAfter((PsiElement)cancellationCheckExpression, bodyBlock.getLBrace());
        return psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
    }

    private final KtBlockExpression getOrCreateBodyBlock(KtLoopExpression $this$getOrCreateBodyBlock, Project project) {
        KtBlockExpression ktBlockExpression;
        KtExpression loopBody = $this$getOrCreateBodyBlock.getBody();
        if (loopBody instanceof KtBlockExpression) {
            ktBlockExpression = (KtBlockExpression)loopBody;
        } else if (loopBody != null) {
            AddBracesIntention.Util.INSTANCE.addBraces((KtElement)$this$getOrCreateBodyBlock, loopBody);
            KtExpression ktExpression = $this$getOrCreateBodyBlock.getBody();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            ktBlockExpression = (KtBlockExpression)ktExpression;
        } else {
            PsiElement psiElement = KtPsiUtil.findChildByType((PsiElement)((PsiElement)$this$getOrCreateBodyBlock), (IElementType)KtNodeTypes.BODY);
            if (psiElement == null) {
                return null;
            }
            PsiElement containerNode = psiElement;
            containerNode.add((PsiElement)new KtPsiFactory(project, false, 2, null).createEmptyBody());
            this.deleteRedundantSemicolon($this$getOrCreateBodyBlock);
            KtExpression ktExpression = $this$getOrCreateBodyBlock.getBody();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            ktBlockExpression = (KtBlockExpression)ktExpression;
        }
        return ktBlockExpression;
    }

    private final void deleteRedundantSemicolon(KtLoopExpression loop) {
        PsiElement nextSibling = loop.getNextSibling();
        if (Intrinsics.areEqual((Object)nextSibling.getNode().getElementType(), (Object)KtTokens.SEMICOLON)) {
            Intrinsics.checkNotNull((Object)nextSibling);
            if (RedundantSemicolonUtilsKt.isRedundantSemicolon((PsiElement)nextSibling)) {
                nextSibling.delete();
            }
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement $this$parentOfType_u24default$iv = startElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtLoopExpression.class, (boolean)true) != null;
    }
}

