/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.kotlin.DevKitKotlinBundle;
import org.jetbrains.idea.devkit.kotlin.inspections.CompanionObjectInExtensionInspectionKt;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/RemoveEmptyCompanionObjectFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "companionObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.kotlin.devkit"})
final class RemoveEmptyCompanionObjectFix
extends LocalQuickFixOnPsiElement {
    public RemoveEmptyCompanionObjectFix(@NotNull KtObjectDeclaration companionObject) {
        Intrinsics.checkNotNullParameter((Object)companionObject, (String)"companionObject");
        super((PsiElement)companionObject);
    }

    @NotNull
    public String getFamilyName() {
        return DevKitKotlinBundle.INSTANCE.message("inspections.remove.empty.companion.object.fix.text", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        KtObjectDeclaration objectDeclaration = (KtObjectDeclaration)startElement;
        if (objectDeclaration.isCompanion() && CompanionObjectInExtensionInspectionKt.access$isEmpty(objectDeclaration)) {
            objectDeclaration.delete();
        }
    }
}

