/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationEnumFieldValue;
import com.intellij.openapi.components.Service;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.ServiceLevelExtractor;
import org.jetbrains.idea.devkit.inspections.ServiceUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/ServiceLevelExtractorForKotlin;", "Lorg/jetbrains/idea/devkit/inspections/ServiceLevelExtractor;", "<init>", "()V", "extractLevels", "", "Lcom/intellij/openapi/components/Service$Level;", "attributeValue", "Lcom/intellij/lang/jvm/annotation/JvmAnnotationArrayValue;", "isApplicableForKotlin", "", "intellij.kotlin.devkit"})
@SourceDebugExtension(value={"SMAP\nServiceLevelExtractorForKotlin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceLevelExtractorForKotlin.kt\norg/jetbrains/idea/devkit/kotlin/inspections/ServiceLevelExtractorForKotlin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class ServiceLevelExtractorForKotlin
implements ServiceLevelExtractor {
    @Override
    @NotNull
    public Collection<Service.Level> extractLevels(@NotNull JvmAnnotationArrayValue attributeValue) {
        Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
        List list = attributeValue.getValues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)list), ServiceLevelExtractorForKotlin::extractLevels$lambda$1));
    }

    @Override
    public boolean isApplicableForKotlin() {
        return true;
    }

    private static final Iterable extractLevels$lambda$1(JvmAnnotationAttributeValue value) {
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = value;
        if (jvmAnnotationAttributeValue instanceof JvmAnnotationConstantValue) {
            Object object = ((JvmAnnotationConstantValue)value).getConstantValue();
            Pair pair = object instanceof Pair ? (Pair)object : null;
            if (pair == null) {
                return SetsKt.emptySet();
            }
            Pair constantValue = pair;
            if (Intrinsics.areEqual((Object)((ClassId)constantValue.getFirst()).asFqNameString(), (Object)Service.Level.class.getCanonicalName())) {
                String string = ((Name)constantValue.getSecond()).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Service.Level level = ServiceUtil.toLevel(string);
                if (level != null) {
                    Service.Level it = level;
                    boolean bl = false;
                    return SetsKt.setOf((Object)it);
                }
            }
        } else if (jvmAnnotationAttributeValue instanceof JvmAnnotationEnumFieldValue) {
            return ServiceUtil.getLevels((JvmAnnotationEnumFieldValue)value);
        }
        return SetsKt.emptySet();
    }
}

