/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.projectView.actions.MarkRootsManager;
import com.intellij.ide.starters.local.DependencyConfig;
import com.intellij.ide.starters.local.GeneratorAsset;
import com.intellij.ide.starters.local.GeneratorEmptyDirectory;
import com.intellij.ide.starters.local.GeneratorResourceFile;
import com.intellij.ide.starters.local.GeneratorTemplateFile;
import com.intellij.ide.starters.local.StandardAssetsProvider;
import com.intellij.ide.starters.local.Starter;
import com.intellij.ide.starters.local.StarterContextProvider;
import com.intellij.ide.starters.local.StarterModuleBuilder;
import com.intellij.ide.starters.local.StarterPack;
import com.intellij.ide.starters.local.wizard.StarterInitialStep;
import com.intellij.ide.starters.shared.FormUiUtilKt;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.ide.starters.shared.StarterSettings;
import com.intellij.ide.starters.shared.StarterTestRunner;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SegmentedButton;
import com.intellij.util.lang.JavaVersion;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0002CDB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00102\u0006\u00100\u001a\u000201H\u0014J\f\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0016J\u0010\u00104\u001a\u00020+2\u0006\u00105\u001a\u000206H\u0016J&\u00107\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<H\u0014J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0014J\u0010\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\bH\u0002J\u000e\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020\u0006J\b\u0010B\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder;", "Lcom/intellij/ide/starters/local/StarterModuleBuilder;", "<init>", "()V", "PLUGIN_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder$PluginType;", "getBuilderId", "", "getPresentableName", "getWeight", "", "getNodeIcon", "Ljavax/swing/Icon;", "getDescription", "getProjectTypes", "", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getTestFrameworks", "Lcom/intellij/ide/starters/shared/StarterTestRunner;", "getMinJavaVersion", "Lcom/intellij/util/lang/JavaVersion;", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getStarterPack", "Lcom/intellij/ide/starters/local/StarterPack;", "createWizardSteps", "", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "modulesProvider", "Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;)[Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "createOptionsStep", "Lcom/intellij/ide/starters/local/wizard/StarterInitialStep;", "contextProvider", "Lcom/intellij/ide/starters/local/StarterContextProvider;", "isSuitableSdkType", "", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "setupModule", "", "module", "Lcom/intellij/openapi/module/Module;", "getAssets", "Lcom/intellij/ide/starters/local/GeneratorAsset;", "starter", "Lcom/intellij/ide/starters/local/Starter;", "getModuleType", "Lcom/intellij/openapi/module/ModuleType;", "setupRootModel", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "getGeneratorContextProperties", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "dependencyConfig", "Lcom/intellij/ide/starters/local/DependencyConfig;", "getFilePathsToOpen", "sanitizeThemeFilename", "title", "setPluginType", "pluginType", "getPluginType", "IdePluginInitialStep", "PluginType", "intellij.devkit.core"})
public final class IdePluginModuleBuilder
extends StarterModuleBuilder {
    @NotNull
    private final Key<PluginType> PLUGIN_TYPE_KEY;

    public IdePluginModuleBuilder() {
        Key key = Key.create((String)"ide.plugin.type");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.PLUGIN_TYPE_KEY = key;
    }

    @NotNull
    public String getBuilderId() {
        return "idea-plugin";
    }

    @NotNull
    public String getPresentableName() {
        String string = DevKitBundle.message("module.builder.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public int getWeight() {
        return 1000;
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = AllIcons.Nodes.Plugin;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Plugin");
        return icon;
    }

    @NotNull
    public String getDescription() {
        String string = DevKitBundle.message("module.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<StarterTestRunner> getTestFrameworks() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected JavaVersion getMinJavaVersion() {
        JavaVersion javaVersion = LanguageLevel.JDK_17.toJavaVersion();
        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"toJavaVersion(...)");
        return javaVersion;
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        return CollectionsKt.listOf((Object)StarterSettings.getKOTLIN_STARTER_LANGUAGE());
    }

    @NotNull
    protected StarterPack getStarterPack() {
        return new StarterPack("devkit", CollectionsKt.listOf((Object)new Starter("devkit", "DevKit", this.getDependencyConfig("/starters/devkit.pom"), CollectionsKt.emptyList())));
    }

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modulesProvider, (String)"modulesProvider");
        return new ModuleWizardStep[0];
    }

    @NotNull
    protected StarterInitialStep createOptionsStep(@NotNull StarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new IdePluginInitialStep(contextProvider);
    }

    public boolean isSuitableSdkType(@NotNull SdkTypeId sdkType) {
        Intrinsics.checkNotNullParameter((Object)sdkType, (String)"sdkType");
        if (this.getPluginType() == PluginType.PLUGIN) {
            return super.isSuitableSdkType(sdkType);
        }
        return Intrinsics.areEqual((Object)sdkType, (Object)IdeaJdk.getInstance());
    }

    protected void setupModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.getStarterContext().setStarter((Starter)CollectionsKt.first((List)this.getStarterContext().getStarterPack().getStarters()));
        Map map = this.loadDependencyConfig();
        Starter starter = this.getStarterContext().getStarter();
        this.getStarterContext().setStarterDependencyConfig((DependencyConfig)map.get(starter != null ? starter.getId() : null));
        super.setupModule(module);
    }

    @NotNull
    protected List<GeneratorAsset> getAssets(@NotNull Starter starter) {
        Intrinsics.checkNotNullParameter((Object)starter, (String)"starter");
        FileTemplateManager ftManager = FileTemplateManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        List assets = new ArrayList();
        if (this.getPluginType() == PluginType.PLUGIN) {
            StandardAssetsProvider standardAssetsProvider = new StandardAssetsProvider();
            URL uRL = ((Object)((Object)this)).getClass().getResource("/assets/devkit-pluginIcon.svg");
            Intrinsics.checkNotNull((Object)uRL);
            assets.add(new GeneratorResourceFile("src/main/resources/META-INF/pluginIcon.svg", uRL));
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("devkit-plugin.xml");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("src/main/resources/META-INF/plugin.xml", fileTemplate));
            FileTemplate fileTemplate2 = ftManager.getJ2eeTemplate("devkit-gradle.properties");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate2, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("gradle.properties", fileTemplate2));
            FileTemplate fileTemplate3 = ftManager.getJ2eeTemplate("devkit-build.gradle.kts");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate3, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("build.gradle.kts", fileTemplate3));
            FileTemplate fileTemplate4 = ftManager.getJ2eeTemplate("devkit-settings.gradle.kts");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate4, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("settings.gradle.kts", fileTemplate4));
            String string = standardAssetsProvider.getGradleWrapperPropertiesLocation();
            FileTemplate fileTemplate5 = ftManager.getJ2eeTemplate("devkit-gradle-wrapper.properties");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate5, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile(string, fileTemplate5));
            assets.addAll(standardAssetsProvider.getGradlewAssets());
            if (this.getStarterContext().isCreatingNewProject()) {
                assets.addAll(standardAssetsProvider.getGradleIgnoreAssets());
            }
            String packagePath = this.getPackagePath(this.getStarterContext().getGroup(), this.getStarterContext().getArtifact());
            if (Intrinsics.areEqual((Object)this.getStarterContext().getLanguage(), (Object)StarterSettings.getJAVA_STARTER_LANGUAGE())) {
                assets.add(new GeneratorEmptyDirectory("src/main/java/" + packagePath));
            } else if (Intrinsics.areEqual((Object)this.getStarterContext().getLanguage(), (Object)StarterSettings.getKOTLIN_STARTER_LANGUAGE())) {
                assets.add(new GeneratorEmptyDirectory("src/main/kotlin/" + packagePath));
            }
            URL uRL2 = ((Object)((Object)this)).getClass().getResource("/assets/devkit-Run_IDE_with_Plugin_run.xml");
            Intrinsics.checkNotNull((Object)uRL2);
            v8 = assets.add(new GeneratorResourceFile(".run/Run IDE with Plugin.run.xml", uRL2));
        } else {
            URL uRL = ((Object)((Object)this)).getClass().getResource("/assets/devkit-theme.gitignore.txt");
            Intrinsics.checkNotNull((Object)uRL);
            assets.add(new GeneratorResourceFile(".gitignore", uRL));
            URL uRL3 = ((Object)((Object)this)).getClass().getResource("/assets/devkit-pluginIcon.svg");
            Intrinsics.checkNotNull((Object)uRL3);
            assets.add(new GeneratorResourceFile("resources/META-INF/pluginIcon.svg", uRL3));
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("devkit-theme-plugin.xml");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
            assets.add(new GeneratorTemplateFile("resources/META-INF/plugin.xml", fileTemplate));
            String string = "resources/theme/" + this.sanitizeThemeFilename(this.getStarterContext().getArtifact()) + ".theme.json";
            FileTemplate fileTemplate6 = ftManager.getJ2eeTemplate("devkit-theme.json");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate6, (String)"getJ2eeTemplate(...)");
            v8 = assets.add(new GeneratorTemplateFile(string, fileTemplate6));
        }
        return assets;
    }

    @NotNull
    public ModuleType<?> getModuleType() {
        if (this.getPluginType() == PluginType.THEME) {
            PluginModuleType pluginModuleType = PluginModuleType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)pluginModuleType), (String)"getInstance(...)");
            return pluginModuleType;
        }
        return super.getModuleType();
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) {
        block3: {
            ContentEntry contentEntry;
            Intrinsics.checkNotNullParameter((Object)modifiableRootModel, (String)"modifiableRootModel");
            super.setupRootModel(modifiableRootModel);
            if (this.getPluginType() != PluginType.THEME) break block3;
            String string = this.getContentEntryPath();
            if (string == null) {
                return;
            }
            String contentEntryPath = string;
            String resourceRootPath = contentEntryPath + "/resources";
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(contentEntryPath);
            if (virtualFile == null) {
                return;
            }
            VirtualFile contentRoot = virtualFile;
            ContentEntry contentEntry2 = contentEntry = MarkRootsManager.findContentEntry((ModuleRootModel)((ModuleRootModel)modifiableRootModel), (VirtualFile)contentRoot);
            if (contentEntry2 != null) {
                contentEntry2.addSourceFolder(VfsUtilCore.pathToUrl((String)resourceRootPath), (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
            }
        }
    }

    @NotNull
    protected Map<String, String> getGeneratorContextProperties(@Nullable Sdk sdk, @NotNull DependencyConfig dependencyConfig) {
        Intrinsics.checkNotNullParameter((Object)dependencyConfig, (String)"dependencyConfig");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pluginTitle", (Object)Strings.capitalize((String)this.getStarterContext().getArtifact())), TuplesKt.to((Object)"themeName", (Object)this.sanitizeThemeFilename(this.getStarterContext().getArtifact()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        if (this.getPluginType() == PluginType.THEME) {
            Object[] objectArray = new String[]{"resources/META-INF/plugin.xml", "resources/theme/" + this.sanitizeThemeFilename(this.getStarterContext().getArtifact()) + ".theme.json"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        Object[] objectArray = new String[]{"src/main/resources/META-INF/plugin.xml", "build.gradle.kts"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String sanitizeThemeFilename(String title) {
        CharSequence charSequence = StringsKt.replace$default((String)title, (String)"-", (String)"", (boolean)false, (int)4, null);
        Regex regex = StarterModuleBuilder.INVALID_PACKAGE_NAME_SYMBOL_PATTERN;
        String string = "_";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\\s");
        string = "";
        return regex.replace(charSequence, string);
    }

    public final void setPluginType(@NotNull PluginType pluginType) {
        Intrinsics.checkNotNullParameter((Object)((Object)pluginType), (String)"pluginType");
        this.getStarterContext().putUserData(this.PLUGIN_TYPE_KEY, (Object)pluginType);
    }

    private final PluginType getPluginType() {
        PluginType pluginType = (PluginType)((Object)this.getStarterContext().getUserData(this.PLUGIN_TYPE_KEY));
        if (pluginType == null) {
            pluginType = PluginType.PLUGIN;
        }
        return pluginType;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder$IdePluginInitialStep;", "Lcom/intellij/ide/starters/local/wizard/StarterInitialStep;", "contextProvider", "Lcom/intellij/ide/starters/local/StarterContextProvider;", "<init>", "(Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder;Lcom/intellij/ide/starters/local/StarterContextProvider;)V", "typeProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder$PluginType;", "addFieldsBefore", "", "layout", "Lcom/intellij/ui/dsl/builder/Panel;", "addFieldsAfter", "intellij.devkit.core"})
    private final class IdePluginInitialStep
    extends StarterInitialStep {
        @NotNull
        private final GraphProperty<PluginType> typeProperty;

        public IdePluginInitialStep(StarterContextProvider contextProvider) {
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            super(contextProvider);
            this.typeProperty = this.getPropertyGraph().property((Object)PluginType.PLUGIN);
        }

        protected void addFieldsBefore(@NotNull Panel layout) {
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            String string = DevKitBundle.message("module.builder.type", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            layout.row(string, arg_0 -> IdePluginInitialStep.addFieldsBefore$lambda$1(this, arg_0)).bottomGap(BottomGap.SMALL);
            IdePluginModuleBuilder.this.setPluginType(PluginType.PLUGIN);
            this.typeProperty.afterChange(arg_0 -> IdePluginInitialStep.addFieldsBefore$lambda$2(IdePluginModuleBuilder.this, this, arg_0));
        }

        protected void addFieldsAfter(@NotNull Panel layout) {
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            Panel.row$default((Panel)layout, null, IdePluginInitialStep::addFieldsAfter$lambda$3, (int)1, null);
            Panel.row$default((Panel)layout, null, IdePluginInitialStep::addFieldsAfter$lambda$4, (int)1, null);
            PluginId scalaPluginId = PluginId.findId((String)"org.intellij.scala");
            if (scalaPluginId != null && PluginManager.isPluginInstalled((PluginId)scalaPluginId)) {
                Panel.row$default((Panel)layout, null, IdePluginInitialStep::addFieldsAfter$lambda$5, (int)1, null);
            }
        }

        private static final Unit addFieldsBefore$lambda$1$lambda$0(SegmentedButton.ItemPresentation $this$segmentedButton, PluginType it) {
            Intrinsics.checkNotNullParameter((Object)$this$segmentedButton, (String)"$this$segmentedButton");
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            $this$segmentedButton.setText(it.getMessagePointer().get());
            return Unit.INSTANCE;
        }

        private static final Unit addFieldsBefore$lambda$1(IdePluginInitialStep this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            PluginType[] pluginTypeArray = new PluginType[]{PluginType.PLUGIN, PluginType.THEME};
            $this$row.segmentedButton((Collection)CollectionsKt.listOf((Object[])pluginTypeArray), IdePluginInitialStep::addFieldsBefore$lambda$1$lambda$0).bind((ObservableMutableProperty)this$0.typeProperty);
            return Unit.INSTANCE;
        }

        private static final Unit addFieldsBefore$lambda$2(IdePluginModuleBuilder this$0, IdePluginInitialStep this$1, PluginType pluginType) {
            Intrinsics.checkNotNullParameter((Object)((Object)pluginType), (String)"pluginType");
            this$0.setPluginType(pluginType);
            this$1.getGroupRow().visible(pluginType == PluginType.PLUGIN);
            this$1.getArtifactRow().visible(pluginType == PluginType.PLUGIN);
            this$1.getSdkComboBox().setSelectedJdk(null);
            this$1.getSdkComboBox().reloadModel();
            ProjectWizardUtil.preselectJdkForNewModule((Project)this$1.getWizardContext().getProject(), null, (JdkComboBox)this$1.getSdkComboBox(), this$0::isSuitableSdkType);
            return Unit.INSTANCE;
        }

        private static final Unit addFieldsAfter$lambda$3(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = DevKitBundle.message("module.builder.how.to.link", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            FormUiUtilKt.hyperLink((Row)$this$row, (String)string, (String)"https://plugins.jetbrains.com/docs/intellij/intellij-platform.html");
            return Unit.INSTANCE;
        }

        private static final Unit addFieldsAfter$lambda$4(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = DevKitBundle.message("module.builder.github.template.link", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            FormUiUtilKt.hyperLink((Row)$this$row, (String)string, (String)"https://jb.gg/plugin-template");
            return Unit.INSTANCE;
        }

        private static final Unit addFieldsAfter$lambda$5(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String string = DevKitBundle.message("module.builder.scala.github.template.link", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            FormUiUtilKt.hyperLink((Row)$this$row, (String)string, (String)"https://github.com/JetBrains/sbt-idea-plugin");
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder$PluginType;", "", "messagePointer", "Ljava/util/function/Supplier;", "", "<init>", "(Ljava/lang/String;ILjava/util/function/Supplier;)V", "getMessagePointer", "()Ljava/util/function/Supplier;", "PLUGIN", "THEME", "intellij.devkit.core"})
    public static final class PluginType
    extends Enum<PluginType> {
        @NotNull
        private final Supplier<String> messagePointer;
        public static final /* enum */ PluginType PLUGIN;
        public static final /* enum */ PluginType THEME;
        private static final /* synthetic */ PluginType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PluginType(Supplier<String> messagePointer) {
            this.messagePointer = messagePointer;
        }

        @NotNull
        public final Supplier<String> getMessagePointer() {
            return this.messagePointer;
        }

        public static PluginType[] values() {
            return (PluginType[])$VALUES.clone();
        }

        public static PluginType valueOf(String value) {
            return Enum.valueOf(PluginType.class, value);
        }

        @NotNull
        public static EnumEntries<PluginType> getEntries() {
            return $ENTRIES;
        }

        static {
            Supplier<String> supplier = DevKitBundle.messagePointer("module.builder.type.plugin", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            PLUGIN = new PluginType(supplier);
            Supplier<String> supplier2 = DevKitBundle.messagePointer("module.builder.type.theme", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier2, (String)"messagePointer(...)");
            THEME = new PluginType(supplier2);
            $VALUES = pluginTypeArray = new PluginType[]{PluginType.PLUGIN, PluginType.THEME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

