/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.DevKitIcons;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ActionCandidate;
import org.jetbrains.idea.devkit.util.ComponentCandidate;
import org.jetbrains.idea.devkit.util.ListenerCandidate;
import org.jetbrains.idea.devkit.util.PointableCandidate;

final class LineMarkerInfoHelper {
    private static final NotNullFunction<PointableCandidate, Collection<? extends PsiElement>> CONVERTER = candidate -> ContainerUtil.createMaybeSingletonList((Object)((XmlTag)candidate.pointer.getElement()));

    private LineMarkerInfoHelper() {
    }

    @NotNull
    private static String getExtensionPointName(DomElement element) {
        if (!(element instanceof ExtensionPoint)) {
            return "?";
        }
        String string = ((ExtensionPoint)element).getEffectiveQualifiedName();
        if (string == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    static RelatedItemLineMarkerInfo<PsiElement> createExtensionLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element) {
        if (targets == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(1);
        }
        if (element == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(2);
        }
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.extension", new Object[0]), extension -> LineMarkerInfoHelper.getExtensionPointName(extension.getExtensionPoint()));
    }

    @NotNull
    static RelatedItemLineMarkerInfo<PsiElement> createExtensionPointLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element) {
        if (targets == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(3);
        }
        if (element == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(4);
        }
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.extension.point", new Object[0]), extensionPoint -> LineMarkerInfoHelper.getExtensionPointName(extensionPoint));
    }

    static RelatedItemLineMarkerInfo<PsiElement> createListenerLineMarkerInfo(@NotNull List<? extends ListenerCandidate> targets, @NotNull PsiElement element) {
        if (targets == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(5);
        }
        if (element == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(6);
        }
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.listener", new Object[0]), listener -> listener.getTopicClassName().getStringValue());
    }

    static RelatedItemLineMarkerInfo<PsiElement> createListenerTopicLineMarkerInfo(@NotNull List<? extends ListenerCandidate> targets, @NotNull PsiElement element) {
        if (targets == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(7);
        }
        if (element == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(8);
        }
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.listener", new Object[0]), listener -> listener.getListenerClassName().getStringValue());
    }

    static RelatedItemLineMarkerInfo<?> createActionLineMarkerInfo(List<? extends ActionCandidate> targets, PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.action", new Object[0]), action -> (String)ObjectUtils.chooseNotNull((Object)action.getId().getStringValue(), (Object)action.getClazz().getStringValue()));
    }

    static RelatedItemLineMarkerInfo<?> createActionGroupLineMarkerInfo(List<? extends ActionCandidate> targets, PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.action.group", new Object[0]), group -> (String)ObjectUtils.chooseNotNull((Object)group.getId().getStringValue(), (Object)group.getClazz().getStringValue()));
    }

    static RelatedItemLineMarkerInfo<?> createComponentLineMarkerInfo(List<? extends ComponentCandidate> targets, PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.component", new Object[0]), component -> component.getImplementationClass().getStringValue());
    }

    @NotNull
    private static <T extends DomElement> RelatedItemLineMarkerInfo<PsiElement> createPluginLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element, @Nls(capitalization=Nls.Capitalization.Title) String popup, final NullableFunction<T, @NlsSafe String> namer) {
        if (targets == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(9);
        }
        if (element == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(10);
        }
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = NavigationGutterIconBuilder.create((Icon)DevKitIcons.Gutter.Plugin, CONVERTER, target -> {
            final DomElement domElement = DomUtil.getDomElement((PsiElement)target.pointer.getElement());
            return Collections.singletonList(new DomGotoRelatedItem(domElement, "DevKit"){

                public String getCustomName() {
                    return LineMarkerInfoHelper.getDomElementName(domElement, namer);
                }

                @Nls
                @Nullable
                public String getCustomContainerName() {
                    PsiElement psiElement = this.getElement();
                    if (psiElement == null) {
                        return null;
                    }
                    return UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(psiElement.getProject(), psiElement.getContainingFile().getVirtualFile());
                }
            });
        }).setTargets(targets).setPopupTitle(popup).setNamer(candidate -> {
            DomElement domElement = DomUtil.getDomElement((PsiElement)candidate.pointer.getElement());
            return LineMarkerInfoHelper.getDomElementName(domElement, namer);
        }).setTargetRenderer(() -> new PsiTargetPresentationRenderer<PsiElement>(){

            @Nls
            @NotNull
            public String getElementText(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                DomElement domElement = DomUtil.getDomElement((PsiElement)element);
                String string = LineMarkerInfoHelper.getDomElementName(domElement, namer);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nls
            public String getContainerText(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(2);
                }
                return UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(element.getProject(), element.getContainingFile().getVirtualFile());
            }

            @Nullable
            protected Icon getIcon(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(3);
                }
                DomElement domElement = DomUtil.getDomElement((PsiElement)element);
                assert (domElement != null);
                return (Icon)ObjectUtils.chooseNotNull((Object)domElement.getPresentation().getIcon(), (Object)element.getIcon(0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/navigation/LineMarkerInfoHelper$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/navigation/LineMarkerInfoHelper$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElementText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getElementText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getContainerText";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(element);
        if (relatedItemLineMarkerInfo == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(11);
        }
        return relatedItemLineMarkerInfo;
    }

    @NlsSafe
    private static <T extends DomElement> String getDomElementName(T domElement, NullableFunction<T, @NlsSafe String> namer) {
        return StringUtil.defaultIfEmpty((String)((String)namer.fun(domElement)), (String)"?");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/navigation/LineMarkerInfoHelper";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/navigation/LineMarkerInfoHelper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginLineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createExtensionLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExtensionPointLineMarkerInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createListenerLineMarkerInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createListenerTopicLineMarkerInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPluginLineMarkerInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

