/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.navigation.structure.PluginDescriptorStructureUtil;

public class PluginDescriptorTreeElement
extends PsiTreeElementBase<XmlTag>
implements DumbAware {
    private final boolean myIsRoot;
    private final boolean myIsTopLevelNode;

    public PluginDescriptorTreeElement(@NotNull XmlTag psiElement, boolean isRootTag, boolean isTopLevelNode) {
        if (psiElement == null) {
            PluginDescriptorTreeElement.$$$reportNull$$$0(0);
        }
        super((PsiElement)psiElement);
        this.myIsRoot = isRootTag;
        this.myIsTopLevelNode = isTopLevelNode;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null || !tag.isValid()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                PluginDescriptorTreeElement.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = ContainerUtil.map((Object[])tag.getSubTags(), psiElement -> new PluginDescriptorTreeElement((XmlTag)psiElement, false, this.myIsRoot));
        if (list == null) {
            PluginDescriptorTreeElement.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public String getPresentableText() {
        XmlTag element = (XmlTag)this.getElement();
        try {
            return PluginDescriptorStructureUtil.getTagDisplayText(element);
        }
        catch (IndexNotReadyException ignore) {
            return PluginDescriptorStructureUtil.safeGetTagDisplayText(element);
        }
    }

    public String getLocationString() {
        try {
            return PluginDescriptorStructureUtil.getTagLocationString((XmlTag)this.getElement());
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }

    public Icon getIcon(boolean open) {
        try {
            return PluginDescriptorStructureUtil.getTagIcon((XmlTag)this.getElement());
        }
        catch (IndexNotReadyException ignore) {
            return PluginDescriptorStructureUtil.DEFAULT_ICON;
        }
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    public boolean isTopLevelNode() {
        return this.myIsTopLevelNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/navigation/structure/PluginDescriptorTreeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/navigation/structure/PluginDescriptorTreeElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

