/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaDependentSdkType;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdkConfigurable;
import org.jetbrains.idea.devkit.projectRoots.IntelliJPlatformProduct;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.run.ProductInfo;
import org.jetbrains.idea.devkit.run.ProductInfoKt;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public final class IdeaJdk
extends JavaDependentSdkType
implements JavaSdkType {
    private static final Logger LOG = Logger.getInstance(IdeaJdk.class);
    private static final String LIB_DIR_NAME = "lib";
    private static final String LIB_SRC_DIR_NAME = "lib/src";
    private static final String PLUGINS_DIR = "plugins";

    public IdeaJdk() {
        super("IDEA JDK");
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Plugin;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.idea";
    }

    public String suggestHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        File home;
        if (homePath == null) {
            IdeaJdk.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isMac && (home = new File(homePath, "Contents")).exists()) {
            String string = home.getPath();
            if (string == null) {
                IdeaJdk.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = super.adjustSelectedSdkHome(homePath);
        if (string == null) {
            IdeaJdk.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isValidSdkHome(@NotNull String path) {
        if (path == null) {
            IdeaJdk.$$$reportNull$$$0(3);
        }
        if (PsiUtil.isPathToIntelliJIdeaSources(path)) {
            return true;
        }
        File home = new File(path);
        return home.exists() && IdeaJdk.getBuildNumber(path) != null && IdeaJdk.getPlatformApiJar(path) != null;
    }

    @Nullable
    private static Path getPlatformApiJar(String home) {
        Path libDir = Path.of(home, LIB_DIR_NAME);
        for (String name : List.of("app-client.jar", "app.jar", "platform-api.jar", "openapi.jar")) {
            Path result = libDir.resolve(name);
            if (!Files.exists(result, new LinkOption[0])) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(4);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) != null ? internalJavaSdk.getVersionString() : null;
    }

    @Nullable
    public static Sdk getInternalJavaSdk(Sdk sdk) {
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof Sandbox) {
            return ((Sandbox)data).getJavaSdk();
        }
        return null;
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        if (sdkHome == null) {
            IdeaJdk.$$$reportNull$$$0(5);
        }
        if (PsiUtil.isPathToIntelliJIdeaSources(sdkHome)) {
            String string = "Local IDEA [" + sdkHome + "]";
            if (string == null) {
                IdeaJdk.$$$reportNull$$$0(6);
            }
            return string;
        }
        String buildNumber = IdeaJdk.getBuildNumber(sdkHome);
        String string = IntelliJPlatformProduct.fromBuildNumber(buildNumber).getName() + " " + (buildNumber != null ? buildNumber : "");
        if (string == null) {
            IdeaJdk.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getBuildNumber(String ideaHome) {
        try {
            @NonNls String buildTxt = SystemInfo.isMac ? "Resources/build.txt" : "build.txt";
            File file = new File(ideaHome, buildTxt);
            if (SystemInfo.isMac && !file.exists()) {
                file = new File(ideaHome, "build.txt");
            }
            return FileUtil.loadFile((File)file).trim();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static VirtualFile[] getIdeaLibrary(String home) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        IdeaJdk.appendIdeaLibrary(home, result, "junit.jar", "junit4.jar");
        ProductInfo productInfo = ProductInfoKt.loadProductInfo(home);
        if (productInfo != null) {
            JarFileSystem jfs = JarFileSystem.getInstance();
            for (String productModuleJarPath : productInfo.getProductModuleJarPaths()) {
                VirtualFile vf = jfs.findFileByPath(home + File.separator + productModuleJarPath + "!/");
                LOG.assertTrue(vf != null, (Object)(productModuleJarPath + " not found in " + home));
                result.add(vf);
            }
        }
        String plugins = home + File.separator + PLUGINS_DIR + File.separator;
        IdeaJdk.appendIdeaLibrary(plugins + "java", result, new String[0]);
        IdeaJdk.appendIdeaLibrary(plugins + "JavaEE", result, "javaee-impl.jar", "jpa-javax-console.jar", "jpa-jakarta-console.jar", "jpa-console-common.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "PersistenceSupport", result, "persistence-impl.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "DatabaseTools", result, "grid.jar", "grid-core.jar", "database-impl.jar", "jdbc-console.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "css", result, "css.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "uml", result, "uml-support.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "Spring", result, "spring.jar", "spring-el.jar", "spring-jsf.jar", "spring-persistence-integration.jar");
        return VfsUtilCore.toVirtualFileArray(result);
    }

    private static void appendIdeaLibrary(@NonNls @NotNull String libDirPath, @NotNull List<VirtualFile> result, String ... forbidden) {
        File[] jars;
        if (libDirPath == null) {
            IdeaJdk.$$$reportNull$$$0(8);
        }
        if (result == null) {
            IdeaJdk.$$$reportNull$$$0(9);
        }
        if (forbidden == null) {
            IdeaJdk.$$$reportNull$$$0(10);
        }
        Arrays.sort(forbidden);
        String path = libDirPath + File.separator + LIB_DIR_NAME;
        JarFileSystem jfs = JarFileSystem.getInstance();
        File lib = new File(path);
        if (lib.isDirectory() && (jars = lib.listFiles()) != null) {
            for (File jar : jars) {
                @NonNls String name = jar.getName();
                if (!jar.isFile() || Arrays.binarySearch(forbidden, name) >= 0 || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                VirtualFile file = jfs.findFileByPath(jar.getPath() + "!/");
                LOG.assertTrue(file != null, (Object)(jar.getPath() + " not found"));
                result.add(file);
            }
        }
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        SdkModificator sdkModificator;
        boolean result;
        Sandbox additionalData;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(11);
        }
        if (sdkModel == null) {
            IdeaJdk.$$$reportNull$$$0(12);
        }
        if ((additionalData = (Sandbox)sdk.getSdkAdditionalData()) != null) {
            additionalData.cleanupWatchedRoots();
        }
        if ((result = IdeaJdk.setupSdkPaths(sdk, sdkModificator = sdk.getSdkModificator(), sdkModel)) && sdkModificator.getSdkAdditionalData() == null) {
            Sdk[] sdks;
            ArrayList<String> javaSdks = new ArrayList<String>();
            for (Sdk jdk : sdks = sdkModel.getSdks()) {
                if (!IdeaJdk.isValidInternalJdk(sdk, jdk)) continue;
                javaSdks.add(jdk.getName());
            }
            if (javaSdks.isEmpty()) {
                JavaSdkVersion requiredVersion = IdeaJdk.getRequiredJdkVersion(sdk);
                if (requiredVersion != null) {
                    Messages.showErrorDialog((String)DevKitBundle.message("sdk.no.java.sdk.for.idea.sdk.found", requiredVersion), (String)DevKitBundle.message("sdk.no.java.sdk.for.idea.sdk.found.title", new Object[0]));
                } else {
                    Messages.showErrorDialog((String)DevKitBundle.message("sdk.no.idea.sdk.version.found", new Object[0]), (String)DevKitBundle.message("sdk.no.java.sdk.for.idea.sdk.found.title", new Object[0]));
                }
                return false;
            }
            @NlsSafe String firstSdkName = (String)javaSdks.get(0);
            Ref choice = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> choice.set((Object)Messages.showChooseDialog((String)DevKitBundle.message("sdk.select.java.sdk", new Object[0]), (String)DevKitBundle.message("sdk.select.java.sdk.title", new Object[0]), (String[])ArrayUtilRt.toStringArray((Collection)javaSdks), (String)firstSdkName, (Icon)Messages.getQuestionIcon())));
            if ((Integer)choice.get() != -1) {
                String name = (String)javaSdks.get((Integer)choice.get());
                Sdk internalJava = Objects.requireNonNull(sdkModel.findSdk(name));
                IdeaJdk.setInternalJdk(sdk, sdkModificator, internalJava);
            } else {
                result = false;
            }
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> sdkModificator.commitChanges()));
        return result;
    }

    private static void setInternalJdk(@NotNull Sdk sdk, @NotNull SdkModificator sdkModificator, @NotNull Sdk internalJava) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(13);
        }
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(14);
        }
        if (internalJava == null) {
            IdeaJdk.$$$reportNull$$$0(15);
        }
        IdeaJdk.addClasses(sdkModificator, internalJava);
        IdeaJdk.addDocs(sdkModificator, internalJava);
        IdeaJdk.addSources(sdkModificator, internalJava);
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)new Sandbox(IdeaJdk.getDefaultSandbox(), internalJava, sdk));
        sdkModificator.setVersionString(internalJava.getVersionString());
    }

    static boolean isValidInternalJdk(@NotNull Sdk ideaSdk, @NotNull Sdk sdk) {
        SdkTypeId sdkType;
        if (ideaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(16);
        }
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(17);
        }
        if ((sdkType = sdk.getSdkType()) instanceof JavaSdk) {
            JavaSdkVersion version = JavaSdk.getInstance().getVersion(sdk);
            JavaSdkVersion requiredVersion = IdeaJdk.getRequiredJdkVersion(ideaSdk);
            if (version != null && requiredVersion != null) {
                return version.isAtLeast(requiredVersion);
            }
        }
        return false;
    }

    @Nullable
    private static JavaSdkVersion getRequiredJdkVersion(Sdk ideaSdk) {
        if (PsiUtil.isPathToIntelliJIdeaSources(ideaSdk.getHomePath())) {
            return JavaSdkVersion.JDK_1_8;
        }
        Path apiJar = IdeaJdk.getPlatformApiJar(ideaSdk.getHomePath());
        return apiJar != null ? ClsParsingUtil.getJdkVersionByBytecode((int)IdeaJdk.getIdeaClassFileVersion(apiJar)) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getIdeaClassFileVersion(Path apiJar) {
        try (ZipFile zipFile = new ZipFile(apiJar.toFile());){
            ZipEntry entry = zipFile.getEntry(ApplicationStarter.class.getName().replace('.', '/') + ".class");
            if (entry == null) return -1;
            try (DataInputStream stream = new DataInputStream(zipFile.getInputStream(entry));){
                if (stream.skip(6L) != 6L) return -1;
                int n = stream.readUnsignedShort();
                return n;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return -1;
    }

    private static boolean setupSdkPaths(Sdk sdk, SdkModificator sdkModificator, SdkModel sdkModel) {
        String sdkHome = Objects.requireNonNull(sdk.getHomePath());
        if (PsiUtil.isPathToIntelliJIdeaSources(sdkHome)) {
            try {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    IdeaJdk.setupSdkPathsFromIDEAProject(sdk, sdkModificator, sdkModel);
                    return null;
                }, DevKitBundle.message("sdk.from.sources.scanning.roots", new Object[0]), true, null);
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                Messages.showErrorDialog((String)e.toString(), (String)DevKitBundle.message("sdk.title", new Object[0]));
                return false;
            }
        } else {
            VirtualFile[] ideaLib;
            for (VirtualFile aIdeaLib : ideaLib = IdeaJdk.getIdeaLibrary(sdkHome)) {
                sdkModificator.addRoot(aIdeaLib, OrderRootType.CLASSES);
            }
            IdeaJdk.addSources(new File(sdkHome), sdkModificator);
        }
        return true;
    }

    private static void setupSdkPathsFromIDEAProject(Sdk sdk, SdkModificator sdkModificator, SdkModel sdkModel) throws IOException {
        Sdk internalJava;
        ProgressIndicator indicator = Objects.requireNonNull(ProgressManager.getInstance().getProgressIndicator());
        String sdkHome = Objects.requireNonNull(sdk.getHomePath());
        JpsModel model = JpsSerializationManager.getInstance().loadModel(sdkHome, PathManager.getOptionsPath());
        JpsSdkReference sdkRef = model.getProject().getSdkReferencesTable().getSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE);
        Sdk sdk2 = internalJava = sdkRef == null ? null : sdkModel.findSdk(sdkRef.getSdkName());
        if (internalJava != null && IdeaJdk.isValidInternalJdk(sdk, internalJava)) {
            IdeaJdk.setInternalJdk(sdk, sdkModificator, internalJava);
        }
        Map moduleByName = model.getProject().getModules().stream().collect(Collectors.toMap(JpsNamedElement::getName, Function.identity()));
        Object[] mainModuleCandidates = new String[]{"intellij.idea.ultimate.main", "intellij.idea.community.main", "main", "community-main"};
        JpsModule mainModule = Arrays.stream(mainModuleCandidates).map(moduleByName::get).filter(Objects::nonNull).findFirst().orElse(null);
        if (mainModule == null) {
            LOG.error("Cannot find main module (" + Arrays.toString(mainModuleCandidates) + ") in IntelliJ IDEA sources at " + sdkHome);
            return;
        }
        LinkedHashSet modules = new LinkedHashSet();
        JpsJavaExtensionService.dependencies((JpsModule)mainModule).recursively().processModules(modules::add);
        indicator.setIndeterminate(false);
        double delta = 1.0 / (2.0 * Math.max(0.5, (double)modules.size()));
        JpsJavaExtensionService javaService = JpsJavaExtensionService.getInstance();
        VirtualFileManager vfsManager = VirtualFileManager.getInstance();
        HashSet<VirtualFile> addedRoots = new HashSet<VirtualFile>();
        for (JpsModule o : modules) {
            indicator.setFraction(indicator.getFraction() + delta);
            for (JpsDependencyElement dep : o.getDependenciesList().getDependencies()) {
                VirtualFile root;
                JpsLibrary library;
                ProgressManager.checkCanceled();
                JpsLibrary jpsLibrary = library = dep instanceof JpsLibraryDependency ? ((JpsLibraryDependency)dep).getLibrary() : null;
                if (library == null) continue;
                for (JpsLibraryRoot jps : library.getRoots(JpsOrderRootType.COMPILED)) {
                    root = vfsManager.findFileByUrl(jps.getUrl());
                    if (root == null || !addedRoots.add(root)) continue;
                    sdkModificator.addRoot(root, OrderRootType.CLASSES);
                }
                for (JpsLibraryRoot jps : library.getRoots(JpsOrderRootType.SOURCES)) {
                    root = vfsManager.findFileByUrl(jps.getUrl());
                    if (root == null || !addedRoots.add(root)) continue;
                    sdkModificator.addRoot(root, OrderRootType.SOURCES);
                }
            }
        }
        for (JpsModule o : modules) {
            VirtualFile outputRoot;
            indicator.setFraction(indicator.getFraction() + delta);
            String outputUrl = javaService.getOutputUrl(o, false);
            VirtualFile virtualFile = outputRoot = outputUrl == null ? null : vfsManager.findFileByUrl(outputUrl);
            if (outputRoot == null) continue;
            sdkModificator.addRoot(outputRoot, OrderRootType.CLASSES);
            for (JpsModuleSourceRoot jps : o.getSourceRoots()) {
                ProgressManager.checkCanceled();
                VirtualFile root = vfsManager.findFileByUrl(jps.getUrl());
                if (root == null || !addedRoots.add(root)) continue;
                sdkModificator.addRoot(root, OrderRootType.SOURCES);
            }
        }
        indicator.setFraction(1.0);
    }

    static String getDefaultSandbox() {
        @NonNls Object defaultSandbox = "";
        try {
            defaultSandbox = new File(PathManager.getSystemPath()).getCanonicalPath() + File.separator + "plugins-sandbox";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaultSandbox;
    }

    private static void addSources(File file, SdkModificator sdkModificator) {
        File[] files = new File(file, LIB_SRC_DIR_NAME).listFiles();
        if (files != null) {
            JarFileSystem fs = JarFileSystem.getInstance();
            for (File child : files) {
                VirtualFile vFile;
                String path = child.getAbsolutePath();
                if (path.contains("generics") || !path.endsWith(".jar") && !path.endsWith(".zip") || (vFile = fs.refreshAndFindFileByPath(path + "!/")) == null) continue;
                sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
            }
        }
    }

    private static void addClasses(@NotNull SdkModificator sdkModificator, @NotNull Sdk javaSdk) {
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(18);
        }
        if (javaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(19);
        }
        IdeaJdk.addOrderEntries(OrderRootType.CLASSES, javaSdk, sdkModificator);
    }

    private static void addDocs(@NotNull SdkModificator sdkModificator, @NotNull Sdk javaSdk) {
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(20);
        }
        if (javaSdk == null) {
            IdeaJdk.$$$reportNull$$$0(21);
        }
        if (!IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), javaSdk, sdkModificator) && SystemInfo.isMac) {
            Sdk[] jdks;
            for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), jdk, sdkModificator);
                break;
            }
        }
    }

    private static void addSources(SdkModificator sdkModificator, Sdk javaSdk) {
        if (javaSdk != null && !IdeaJdk.addOrderEntries(OrderRootType.SOURCES, javaSdk, sdkModificator)) {
            if (SystemInfo.isMac) {
                Sdk[] jdks;
                for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                    if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                    IdeaJdk.addOrderEntries(OrderRootType.SOURCES, jdk, sdkModificator);
                    break;
                }
            } else {
                String path;
                JarFileSystem jarFileSystem;
                VirtualFile vFile;
                String homePath = javaSdk.getHomePath();
                if (homePath == null) {
                    return;
                }
                File jarFile = new File(new File(homePath).getParentFile(), "src.zip");
                if (jarFile.exists() && (vFile = (jarFileSystem = JarFileSystem.getInstance()).refreshAndFindFileByPath((path = jarFile.getAbsolutePath()) + "!/")) != null) {
                    sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
                }
            }
        }
    }

    private static boolean addOrderEntries(@NotNull OrderRootType orderRootType, @NotNull Sdk sdk, @NotNull SdkModificator toModificator) {
        String[] entries;
        if (orderRootType == null) {
            IdeaJdk.$$$reportNull$$$0(22);
        }
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(23);
        }
        if (toModificator == null) {
            IdeaJdk.$$$reportNull$$$0(24);
        }
        boolean wasSmthAdded = false;
        for (String entry : entries = sdk.getRootProvider().getUrls(orderRootType)) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(entry);
            if (virtualFile == null) continue;
            toModificator.addRoot(virtualFile, orderRootType);
            wasSmthAdded = true;
        }
        return wasSmthAdded;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            IdeaJdk.$$$reportNull$$$0(25);
        }
        if (sdkModificator == null) {
            IdeaJdk.$$$reportNull$$$0(26);
        }
        return new IdeaJdkConfigurable(sdkModel, sdkModificator);
    }

    @Nullable
    public String getBinPath(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(27);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) == null ? null : JavaSdk.getInstance().getBinPath(internalJavaSdk);
    }

    @Nullable
    public String getToolsPath(@NotNull Sdk sdk) {
        Sdk jdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(28);
        }
        if ((jdk = IdeaJdk.getInternalJavaSdk(sdk)) != null && jdk.getVersionString() != null) {
            return JavaSdk.getInstance().getToolsPath(jdk);
        }
        return null;
    }

    @Nullable
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        Sdk internalJavaSdk;
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(29);
        }
        return (internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk)) == null ? null : JavaSdk.getInstance().getVMExecutablePath(internalJavaSdk);
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            IdeaJdk.$$$reportNull$$$0(30);
        }
        if (additional == null) {
            IdeaJdk.$$$reportNull$$$0(31);
        }
        if (additionalData instanceof Sandbox) {
            try {
                ((Sandbox)additionalData).writeExternal(additional);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk sdk, @NotNull Element additional) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(32);
        }
        if (additional == null) {
            IdeaJdk.$$$reportNull$$$0(33);
        }
        Sandbox sandbox = new Sandbox(sdk);
        try {
            sandbox.readExternal(additional);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return sandbox;
    }

    @NotNull
    public String getPresentableName() {
        String string = DevKitBundle.message("sdk.title", new Object[0]);
        if (string == null) {
            IdeaJdk.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Nullable
    public static Sdk findIdeaJdk(@Nullable Sdk jdk) {
        if (jdk == null) {
            return null;
        }
        if (jdk.getSdkType() instanceof IdeaJdk) {
            return jdk;
        }
        return null;
    }

    public static SdkType getInstance() {
        return SdkType.findInstance(IdeaJdk.class);
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            IdeaJdk.$$$reportNull$$$0(35);
        }
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance() || type == AnnotationOrderRootType.getInstance();
    }

    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            IdeaJdk.$$$reportNull$$$0(36);
        }
        return JavaSdk.getInstance().getDefaultDocumentationUrl(sdk);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 7, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/projectRoots/IdeaJdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 17: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forbidden";
                break;
            }
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalJava";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaSdk";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdk";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModificator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/projectRoots/IdeaJdk";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendIdeaLibrary";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setInternalJdk";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidInternalJdk";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addDocs";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addOrderEntries";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 7, 34 -> new IllegalStateException(string);
        };
    }
}

