/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum IntelliJPlatformProduct {
    IDEA("IU", "IntelliJ IDEA", null, "com.jetbrains.intellij.idea:ideaIU", "idea:ideaIU"),
    IDEA_IC("IC", "IntelliJ IDEA Community Edition", "Idea", "com.jetbrains.intellij.idea:ideaIC", "idea:ideaIC"),
    IDEA_IE("IE", "IntelliJ IDEA Educational Edition", "IdeaEdu", null, null),
    RUBYMINE("RM", "RubyMine", "Ruby", null, "ruby:RubyMine"),
    PYCHARM("PY", "PyCharm", "Python", "com.jetbrains.intellij.pycharm:pycharmPY", "python:pycharm-professional"),
    PYCHARM_PC("PC", "PyCharm Community Edition", "PyCharmCore", "com.jetbrains.intellij.pycharm:pycharmPC", "python:pycharm-community"),
    DATASPELL("DS", "DataSpell", "DataSpell", null, "python:dataspell"),
    PYCHARM_EDU("PE", "PyCharm Educational Edition", "PyCharmEdu", null, null),
    PHPSTORM("PS", "PhpStorm", "PhpStorm", "com.jetbrains.intellij.phpstorm:phpstorm", "webide:PhpStorm"),
    WEBSTORM("WS", "WebStorm", "WebStorm", "com.jetbrains.intellij.webstorm:webstorm", "webstorm:WebStorm"),
    APPCODE("OC", "AppCode", "AppCode", null, null),
    CLION("CL", "CLion", "CLion", "com.jetbrains.intellij.clion:clion", "cpp:CLion"),
    DBE("DB", "DataGrip", "DataGrip", null, "datagrip:datagrip"),
    RIDER("RD", "Rider", "Rider", "com.jetbrains.intellij.rider:riderRD", "rider:JetBrains.Rider"),
    GOIDE("GO", "GoLand", "GoLand", "com.jetbrains.intellij.goland:goland", "go:goland"),
    ANDROID_STUDIO("AI", "Android Studio", "AndroidStudio", null, "com.google.android.studio:android-studio"),
    CWM_GUEST("CWMG", "Code With Me Guest", "CodeWithMeGuest", null, null),
    JETBRAINS_CLIENT("JBC", "JetBrains Client", "JetBrainsClient", null, null),
    GATEWAY("GW", "Gateway", "Gateway", "com.jetbrains.intellij.gateway:gateway", "idea/gateway:JetBrainsGateway"),
    FLEET_BACKEND("FLIJ", "Fleet Backend", "FleetBackend", "com.jetbrains.intellij.fleetBackend:fleetBackend", null),
    AQUA("QA", "Aqua", "Aqua", null, "aqua:aqua"),
    RUSTROVER("RR", "RustRover", "RustRover", "com.jetbrains.intellij.rustrover:RustRover", "rustrover:RustRover"),
    WRITERSIDE("WRS", "Writerside", "Writerside", "com.jetbrains.intellij.idea:writerside", "writerside:writerside");

    private final String myProductCode;
    private final String myName;
    private final String myPlatformPrefix;
    private final String myMavenCoordinates;
    private final String myCdnCoordinates;

    @NonNls
    public String getName() {
        return this.myName;
    }

    @NonNls
    public String getPlatformPrefix() {
        return this.myPlatformPrefix;
    }

    @Nullable
    public String getMavenCoordinates() {
        return this.myMavenCoordinates;
    }

    @Nullable
    public String getCdnCoordinates() {
        return this.myCdnCoordinates;
    }

    private IntelliJPlatformProduct(@NonNls String productCode, @Nullable String name, @Nullable String platformPrefix, String mavenCoordinates, String cdnCoordinates) {
        this.myProductCode = productCode;
        this.myName = name;
        this.myPlatformPrefix = platformPrefix;
        this.myMavenCoordinates = mavenCoordinates;
        this.myCdnCoordinates = cdnCoordinates;
    }

    public static IntelliJPlatformProduct fromBuildNumber(String buildNumber) {
        for (IntelliJPlatformProduct product : IntelliJPlatformProduct.values()) {
            if (!buildNumber.startsWith(product.myProductCode)) continue;
            return product;
        }
        return IDEA;
    }

    @Nullable
    public static IntelliJPlatformProduct fromProductCode(@Nullable String productCode) {
        return (IntelliJPlatformProduct)((Object)ContainerUtil.find((Object[])IntelliJPlatformProduct.values(), product -> product.myProductCode.equals(productCode)));
    }

    @Nullable
    public static IntelliJPlatformProduct fromMavenCoordinates(@NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            IntelliJPlatformProduct.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            IntelliJPlatformProduct.$$$reportNull$$$0(1);
        }
        return (IntelliJPlatformProduct)((Object)ContainerUtil.find((Object[])IntelliJPlatformProduct.values(), product -> Objects.equals(product.getMavenCoordinates(), groupId + ":" + artifactId)));
    }

    @Nullable
    public static IntelliJPlatformProduct fromCdnCoordinates(@NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            IntelliJPlatformProduct.$$$reportNull$$$0(2);
        }
        if (artifactId == null) {
            IntelliJPlatformProduct.$$$reportNull$$$0(3);
        }
        return (IntelliJPlatformProduct)((Object)ContainerUtil.find((Object[])IntelliJPlatformProduct.values(), product -> Objects.equals(product.getCdnCoordinates(), groupId + ":" + artifactId)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/projectRoots/IntelliJPlatformProduct";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fromMavenCoordinates";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fromCdnCoordinates";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

