/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.OverrideText;
import org.jetbrains.idea.devkit.dom.impl.ActionOrGroupResolveConverter;
import org.jetbrains.idea.devkit.dom.index.IdeaPluginRegistrationIndex;
import org.jetbrains.idea.devkit.references.PluginConfigReference;

final class ActionOrGroupIdReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements PluginConfigReference {
    private final String myId;
    private final ThreeState myIsAction;

    ActionOrGroupIdReference(@NotNull PsiElement element, TextRange range, String id, ThreeState isAction) {
        if (element == null) {
            ActionOrGroupIdReference.$$$reportNull$$$0(0);
        }
        super(element, range);
        this.myIsAction = isAction;
        this.myId = id;
    }

    @NotNull
    public @NotNull ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        Project project = this.getElement().getProject();
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project).union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
        CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
        this.collectResults(this.myId, scope, (CommonProcessors.CollectUniquesProcessor<ActionOrGroup>)processor);
        if (processor.getResults().isEmpty()) {
            String place = StringUtil.substringAfterLast((String)this.myId, (String)".");
            if (StringUtil.isEmpty((String)place)) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    ActionOrGroupIdReference.$$$reportNull$$$0(1);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            String idWithoutPlaceSuffix = StringUtil.substringBeforeLast((String)this.myId, (String)".");
            this.collectResults(idWithoutPlaceSuffix, scope, (CommonProcessors.CollectUniquesProcessor<ActionOrGroup>)processor);
            for (ActionOrGroup result : processor.getResults()) {
                for (OverrideText overrideText : result.getOverrideTexts()) {
                    if (!place.equals(overrideText.getPlace().getStringValue())) continue;
                    DomTarget overrideTarget = DomTarget.getTarget((DomElement)overrideText, overrideText.getPlace());
                    assert (overrideTarget != null);
                    ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{PomService.convertToPsi((PsiTarget)overrideTarget)});
                    if (resolveResultArray == null) {
                        ActionOrGroupIdReference.$$$reportNull$$$0(2);
                    }
                    return resolveResultArray;
                }
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                ActionOrGroupIdReference.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List psiElements = JBIterable.from((Iterable)processor.getResults()).map(actionOrGroup -> {
            DomTarget target = DomTarget.getTarget((DomElement)actionOrGroup);
            return target == null ? null : PomService.convertToPsi((Project)project, (PomTarget)target);
        }).filter(Objects::nonNull).toList();
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)psiElements);
        if (resolveResultArray == null) {
            ActionOrGroupIdReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    public Object @NotNull [] getVariants() {
        ActionOrGroupResolveConverter converter = this.myIsAction == ThreeState.YES ? new ActionOrGroupResolveConverter.OnlyActions() : (this.myIsAction == ThreeState.NO ? new ActionOrGroupResolveConverter.OnlyGroups() : new ActionOrGroupResolveConverter());
        List<ActionOrGroup> variants = converter.getVariants(this.getElement().getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()));
        Object[] objectArray = ContainerUtil.map2Array(variants, LookupElement.class, actionOrGroup -> converter.createLookupElement((ActionOrGroup)actionOrGroup));
        if (objectArray == null) {
            ActionOrGroupIdReference.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    private void collectResults(String id, GlobalSearchScope scope, CommonProcessors.CollectUniquesProcessor<ActionOrGroup> processor) {
        Project project = this.getElement().getProject();
        if (this.myIsAction != ThreeState.NO) {
            IdeaPluginRegistrationIndex.processAction(project, id, scope, processor);
        }
        if (this.myIsAction != ThreeState.YES) {
            IdeaPluginRegistrationIndex.processGroup(project, id, scope, processor);
        }
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = DevKitBundle.message("plugin.xml.action.cannot.resolve", this.myId);
        if (string == null) {
            ActionOrGroupIdReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/references/ActionOrGroupIdReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/references/ActionOrGroupIdReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

