/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ProjectIconsAccessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;

final class IconsReferencesQueryExecutor
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    @NonNls
    static final String ALL_ICONS_FQN = "com.intellij.icons.AllIcons";
    @NonNls
    static final String ALL_ICONS_NAME = "AllIcons";
    @NonNls
    static final String PLATFORM_ICONS_MODULE = "intellij.platform.icons";
    @NonNls
    static final String ICONS_MODULE = "icons";
    @NonNls
    static final String ICONS_PACKAGE_PREFIX = "icons.";
    @NonNls
    static final String COM_INTELLIJ_ICONS_PREFIX = "com.intellij.icons.";
    @NonNls
    static final String ICONS_CLASSNAME_SUFFIX = "Icons";

    IconsReferencesQueryExecutor() {
    }

    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement file;
        if (queryParameters == null) {
            IconsReferencesQueryExecutor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            IconsReferencesQueryExecutor.$$$reportNull$$$0(1);
        }
        if ((file = queryParameters.getElementToSearch()) instanceof PsiBinaryFile) {
            Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
            VirtualFile image = ((PsiBinaryFile)file).getVirtualFile();
            if (IconsReferencesQueryExecutor.isImage(image) && IconsReferencesQueryExecutor.isIconsModule(module)) {
                Project project = file.getProject();
                FindModel model = new FindModel();
                String path = IconsReferencesQueryExecutor.getPathToImage(image, module);
                model.setStringToFind(path);
                model.setCaseSensitive(true);
                model.setFindAll(true);
                model.setWholeWordsOnly(true);
                FindInProjectUtil.findUsages((FindModel)model, (Project)project, usage -> {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement element = usage.getElement();
                        ProperTextRange textRange = usage.getRangeInElement();
                        if (element != null && textRange != null) {
                            PsiElement start = element.findElementAt(textRange.getStartOffset());
                            PsiElement end = element.findElementAt(textRange.getEndOffset());
                            if (start != null && end != null) {
                                PsiFileReference reference;
                                PsiElement value = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
                                if (value instanceof PsiJavaToken) {
                                    value = value.getParent();
                                }
                                if (value != null && (reference = FileReferenceUtil.findFileReference((PsiElement)value)) != null) {
                                    consumer.process((Object)reference);
                                }
                            }
                        }
                    });
                    return true;
                }, (FindUsagesProcessPresentation)new FindUsagesProcessPresentation(new UsageViewPresentation()));
            }
        }
        return true;
    }

    @NotNull
    @NonNls
    private static String getPathToImage(VirtualFile image, Module module) {
        String path = ModuleRootManager.getInstance((Module)module).getSourceRoots()[0].getPath();
        String string = "/" + FileUtil.getRelativePath((String)path, (String)image.getPath(), (char)'/');
        if (string == null) {
            IconsReferencesQueryExecutor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static boolean isIconsModule(Module module) {
        return module != null && (ICONS_MODULE.equals(module.getName()) || PLATFORM_ICONS_MODULE.equals(module.getName())) && ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 1;
    }

    private static boolean isImage(VirtualFile image) {
        FileTypeManager mgr = FileTypeManager.getInstance();
        return image != null && mgr.getFileTypeByFile(image) == mgr.getFileTypeByExtension("png");
    }

    @Nullable
    public static PsiField resolveIconPath(@NonNls @Nullable String path, PsiElement element) {
        if (path == null) {
            return null;
        }
        @NonNls List pathElements = StringUtil.split((String)path, (String)".");
        if (pathElements.size() < 2) {
            return null;
        }
        int iconsClassNameIdx = ContainerUtil.lastIndexOf((List)pathElements, s -> s.endsWith(ICONS_CLASSNAME_SUFFIX));
        if (iconsClassNameIdx == -1) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        PsiClass iconClass = IconsReferencesQueryExecutor.findIconClass(module, StringUtil.join((Collection)ContainerUtil.getFirstItems((List)pathElements, (int)(iconsClassNameIdx + 1)), (String)"."), iconsClassNameIdx != 0);
        if (iconClass == null) {
            return null;
        }
        for (int i = iconsClassNameIdx + 1; i < pathElements.size() - 1; ++i) {
            if ((iconClass = iconClass.findInnerClassByName((String)pathElements.get(i), false)) != null) continue;
            return null;
        }
        return iconClass.findFieldByName((String)pathElements.get(pathElements.size() - 1), false);
    }

    @Nullable
    private static PsiClass findIconClass(Module module, @NonNls @NotNull String iconClass, boolean isQualifiedFqn) {
        if (iconClass == null) {
            IconsReferencesQueryExecutor.$$$reportNull$$$0(3);
        }
        Object adjustedIconClassFqn = isQualifiedFqn ? iconClass : (ALL_ICONS_NAME.equals(iconClass) ? ALL_ICONS_FQN : ICONS_PACKAGE_PREFIX + iconClass);
        GlobalSearchScope iconSearchScope = isQualifiedFqn ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false) : GlobalSearchScope.allScope((Project)module.getProject());
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass((String)adjustedIconClassFqn, iconSearchScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesQueryExecutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesQueryExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findIconClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static abstract class IconPsiReferenceBase
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        IconPsiReferenceBase(@NotNull PsiElement element) {
            if (element == null) {
                IconPsiReferenceBase.$$$reportNull$$$0(0);
            }
            super(element, true);
        }

        public Object @NotNull [] getVariants() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    IconPsiReferenceBase.$$$reportNull$$$0(1);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            Project project = module.getProject();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            GlobalSearchScope productionScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
            ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
            IconPsiReferenceBase.addIconVariants(variants, javaPsiFacade.findClass(IconsReferencesQueryExecutor.ALL_ICONS_FQN, productionScope), false, Collections.emptyList());
            PsiPackage iconsPackage = javaPsiFacade.findPackage(IconsReferencesQueryExecutor.ICONS_MODULE);
            if (iconsPackage != null) {
                for (PsiClass psiClass2 : iconsPackage.getClasses(productionScope)) {
                    String className = psiClass2.getName();
                    if (className == null || !StringUtil.endsWith((CharSequence)className, (CharSequence)IconsReferencesQueryExecutor.ICONS_CLASSNAME_SUFFIX)) continue;
                    IconPsiReferenceBase.addIconVariants(variants, psiClass2, false, Collections.emptyList());
                }
            }
            GlobalSearchScope notIconsPackageScope = iconsPackage != null ? PackageScope.packageScope((PsiPackage)iconsPackage, (boolean)false) : GlobalSearchScope.EMPTY_SCOPE;
            Query allIconsSearch = AllClassesSearch.search((SearchScope)productionScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)notIconsPackageScope)), (Project)project, s -> StringUtil.endsWith((CharSequence)s, (CharSequence)IconsReferencesQueryExecutor.ICONS_CLASSNAME_SUFFIX) && !s.equals(IconsReferencesQueryExecutor.ICONS_CLASSNAME_SUFFIX));
            allIconsSearch.forEach(psiClass -> {
                if (IconsReferencesQueryExecutor.ALL_ICONS_FQN.equals(psiClass.getQualifiedName()) || psiClass.isInterface() || psiClass.getContainingClass() != null || !psiClass.hasModifier(JvmModifier.PUBLIC)) {
                    return;
                }
                IconPsiReferenceBase.addIconVariants(variants, psiClass, true, Collections.emptyList());
            });
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                IconPsiReferenceBase.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private static void addIconVariants(List<LookupElement> variants, @Nullable PsiClass iconClass, boolean useFqn, List<PsiClass> containingClasses) {
            if (iconClass == null) {
                return;
            }
            Object classNamePrefix = useFqn ? (containingClasses.isEmpty() ? iconClass.getQualifiedName() : ((PsiClass)ContainerUtil.getLastItem(containingClasses)).getQualifiedName() + "." + iconClass.getName()) : (containingClasses.isEmpty() ? iconClass.getName() : StringUtil.join(containingClasses, aClass -> aClass.getName(), (String)".") + "." + iconClass.getName());
            for (PsiField field : iconClass.getFields()) {
                if (!ProjectIconsAccessor.isIconClassType((PsiType)field.getType())) continue;
                String iconPath = (String)classNamePrefix + "." + field.getName();
                LookupElementBuilder builder = LookupElementBuilder.create((Object)field, (String)iconPath).withRenderer((LookupElementRenderer)IconPathLookupElementRenderer.INSTANCE);
                variants.add((LookupElement)builder);
            }
            SmartList parents = new SmartList(containingClasses);
            parents.add(iconClass);
            for (PsiClass innerClass : iconClass.getInnerClasses()) {
                IconPsiReferenceBase.addIconVariants(variants, innerClass, useFqn, (List<PsiClass>)parents);
            }
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = DevKitBundle.message("inspections.presentation.cannot.resolve.icon", new Object[0]);
            if (string == null) {
                IconPsiReferenceBase.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesQueryExecutor$IconPsiReferenceBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesQueryExecutor$IconPsiReferenceBase";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }

        private static class IconPathLookupElementRenderer
        extends LookupElementRenderer<LookupElement> {
            private static final IconPathLookupElementRenderer INSTANCE = new IconPathLookupElementRenderer();

            private IconPathLookupElementRenderer() {
            }

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                PsiField field = (PsiField)ObjectUtils.tryCast((Object)element.getPsiElement(), PsiField.class);
                assert (field != null);
                String iconPath = element.getLookupString();
                presentation.setItemText(iconPath);
                presentation.setStrikeout(field.isDeprecated());
                Icon resolveIcon = IconPathLookupElementRenderer.resolveIcon(field, iconPath);
                if (resolveIcon != null) {
                    if (ProjectIconsAccessor.hasProperSize((Icon)resolveIcon)) {
                        presentation.setIcon(resolveIcon);
                    } else {
                        presentation.setTailText(" (" + resolveIcon.getIconWidth() + "x" + resolveIcon.getIconHeight() + ")", true);
                    }
                }
            }

            @Nullable
            private static Icon resolveIcon(PsiField field, @NotNull String iconPath) {
                if (iconPath == null) {
                    IconPathLookupElementRenderer.$$$reportNull$$$0(0);
                }
                UField uField = (UField)UastContextKt.toUElement((PsiElement)field, UField.class);
                assert (uField != null);
                UExpression expression = uField.getUastInitializer();
                if (expression == null) {
                    return IconLoader.findIcon((String)iconPath, IconPsiReferenceBase.class, (boolean)false, (boolean)false);
                }
                ProjectIconsAccessor iconsAccessor = ProjectIconsAccessor.getInstance((Project)field.getProject());
                VirtualFile iconFile = iconsAccessor.resolveIconFile((UElement)expression);
                return iconFile == null ? null : iconsAccessor.getIcon(iconFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconPath", "org/jetbrains/idea/devkit/references/IconsReferencesQueryExecutor$IconPsiReferenceBase$IconPathLookupElementRenderer", "resolveIcon"));
            }
        }
    }
}

