/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.references.IconsReferencesQueryExecutor;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

final class IconsUastReferencesContributor
extends PsiReferenceContributor {
    IconsUastReferencesContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsUastReferencesContributor.$$$reportNull$$$0(0);
        }
        IconsUastReferencesContributor.registerForPresentationAnnotation(registrar);
        IconsUastReferencesContributor.registerForIconLoaderMethods(registrar);
    }

    private static void registerForIconLoaderMethods(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsUastReferencesContributor.$$$reportNull$$$0(1);
        }
        PsiMethodPattern method = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("load")).definedInClass("com.intellij.icons.AllIcons");
        PsiJavaElementPattern.Capture findGetIconPattern = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)method));
        registrar.registerReferenceProvider((ElementPattern)findGetIconPattern, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!IntelliJProjectUtil.isIntelliJPlatformProject((Project)element.getProject())) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                FileReference[] fileReferenceArray = new FileReferenceSet(element){

                    @NotNull
                    public Collection<PsiFileSystemItem> getDefaultContexts() {
                        ModuleManager moduleManager = ModuleManager.getInstance((Project)element.getProject());
                        Module iconsModule = moduleManager.findModuleByName("intellij.platform.icons");
                        if (iconsModule == null) {
                            iconsModule = moduleManager.findModuleByName("icons");
                        }
                        if (iconsModule == null) {
                            Collection collection = super.getDefaultContexts();
                            if (collection == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return collection;
                        }
                        SmartList result = new SmartList();
                        VirtualFile[] roots = ModuleRootManager.getInstance((Module)iconsModule).getSourceRoots();
                        PsiManager psiManager = element.getManager();
                        for (VirtualFile root : roots) {
                            PsiDirectory directory = psiManager.findDirectory(root);
                            ContainerUtil.addIfNotNull((Collection)result, (Object)directory);
                        }
                        SmartList smartList = result;
                        if (smartList == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return smartList;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsUastReferencesContributor$1$1", "getDefaultContexts"));
                    }
                }.getAllReferences();
                if (fileReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return fileReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsUastReferencesContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsUastReferencesContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }, 100.0);
    }

    private static void registerForPresentationAnnotation(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsUastReferencesContributor.$$$reportNull$$$0(2);
        }
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((UExpressionPattern)UastPatterns.injectionHostUExpression().sourcePsiFilter(psi -> PsiUtil.isPluginProject(psi.getProject()))).annotationParam(Presentation.class.getName(), "icon"), (UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((uElement, referencePsiElement) -> new PsiReference[]{new IconsReferencesQueryExecutor.IconPsiReferenceBase((PsiElement)referencePsiElement, (UExpression)uElement, (PsiLanguageInjectionHost)referencePsiElement){
            final /* synthetic */ UExpression val$uElement;
            final /* synthetic */ PsiLanguageInjectionHost val$referencePsiElement;
            {
                this.val$uElement = uExpression;
                this.val$referencePsiElement = psiLanguageInjectionHost;
                super(element);
            }

            public PsiElement resolve() {
                String value = UastUtils.evaluateString((UExpression)this.val$uElement);
                return IconsReferencesQueryExecutor.resolveIconPath(value, (PsiElement)this.val$referencePsiElement);
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                PsiElement field;
                PsiElement result;
                if (newElementName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((result = this.handleElement(field = this.resolve(), newElementName)) != null) {
                    return result;
                }
                return super.handleElementRename(newElementName);
            }

            @Nullable
            private PsiElement handleElement(PsiElement element, @Nullable String newElementName) {
                String classQualifiedName;
                PsiClass containingClass;
                if (element instanceof PsiField && (containingClass = ((PsiField)element).getContainingClass()) != null && (classQualifiedName = containingClass.getQualifiedName()) != null) {
                    if (newElementName == null) {
                        newElementName = ((PsiField)element).getName();
                    }
                    if (classQualifiedName.startsWith("com.intellij.icons.")) {
                        return this.replace(newElementName, classQualifiedName, "com.intellij.icons.");
                    }
                    if (classQualifiedName.startsWith("icons.")) {
                        return this.replace(newElementName, classQualifiedName, "icons.");
                    }
                    return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)(classQualifiedName + "." + newElementName));
                }
                return null;
            }

            private PsiElement replace(@NonNls String newElementName, @NonNls String fqn, @NonNls String packageName) {
                String newValue = fqn.substring(packageName.length()) + "." + newElementName;
                return ElementManipulators.handleContentChange((PsiElement)this.getElement(), (String)newValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "org/jetbrains/idea/devkit/references/IconsUastReferencesContributor$2", "handleElementRename"));
            }
        }}), (double)100.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "registrar";
        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsUastReferencesContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerForIconLoaderMethods";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerForPresentationAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

