/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.components.State;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.VirtualFilePattern;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.references.ActionOrGroupIdReference;
import org.jetbrains.idea.devkit.references.AdvancedSettingsIdContributor;
import org.jetbrains.idea.devkit.references.ExtensionReferenceBase;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

final class MessageBundleReferenceContributor
extends PsiReferenceContributor {
    @NonNls
    private static final String ACTION = "action.";
    @NonNls
    private static final String GROUP = "group.";
    @NonNls
    private static final String TEXT = ".text";
    @NonNls
    private static final String DESCRIPTION = ".description";
    @NonNls
    private static final String TRAILING_LABEL = ".trailingLabel";
    @NonNls
    public static final String ADVANCED_SETTING = "advanced.setting.";
    @NonNls
    public static final String BUNDLE_PROPERTIES = "Bundle.properties";
    @NonNls
    private static final String TOOLWINDOW_STRIPE_PREFIX = "toolwindow.stripe.";
    @NonNls
    private static final String EXPORTABLE_PREFIX = "exportable.";
    @NonNls
    private static final String EXPORTABLE_SUFFIX = ".presentable.name";
    @NonNls
    private static final String PLUGIN = "plugin.";

    MessageBundleReferenceContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            MessageBundleReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyKeyImpl.class).inVirtualFile((ElementPattern)MessageBundleReferenceContributor.bundleFile()), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof PropertyKeyImpl)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (!MessageBundleReferenceContributor.isPluginProject(element)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String text = ((PropertyKeyImpl)element).getText();
                PsiReference[] psiReferenceArray = (PsiReference[])JBIterable.of((Object[])new PsiReference[]{1.createActionOrGroupIdReference(element, text), 1.createToolwindowIdReference(element, text), 1.createExportableIdReference(element, text), 1.createPluginIdReference(element, text), 1.createAdvancedSettingReference(element, text)}).filter(Objects::nonNull).toArray((Object[])PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }

            @Nullable
            private static PsiReference createActionOrGroupIdReference(@NotNull PsiElement element, String text) {
                if (element == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (!MessageBundleReferenceContributor.isActionOrGroupKey(text)) {
                    return null;
                }
                int dotAfterPrefix = text.indexOf(46);
                if (dotAfterPrefix == -1) {
                    return null;
                }
                int prefixEndIdx = dotAfterPrefix + 1;
                int dotBeforeSuffix = text.lastIndexOf(46);
                if (dotBeforeSuffix == -1) {
                    return null;
                }
                if (dotBeforeSuffix <= prefixEndIdx) {
                    return null;
                }
                String id = text.substring(prefixEndIdx, dotBeforeSuffix);
                String prefix = text.substring(0, prefixEndIdx);
                ThreeState isAction = prefix.equals(MessageBundleReferenceContributor.ACTION) ? ThreeState.YES : ThreeState.NO;
                return new ActionOrGroupIdReference(element, TextRange.allOf((String)id).shiftRight(prefix.length()), id, isAction);
            }

            @Nullable
            private static PsiReference createToolwindowIdReference(@NotNull PsiElement element, String text) {
                if (element == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (!MessageBundleReferenceContributor.isToolwindowKey(text)) {
                    return null;
                }
                String id = StringUtil.notNullize((String)StringUtil.substringAfter((String)text, (String)MessageBundleReferenceContributor.TOOLWINDOW_STRIPE_PREFIX)).replace('_', ' ');
                return new ToolwindowIdReference(element, id);
            }

            @Nullable
            private static PsiReference createExportableIdReference(@NotNull PsiElement element, String text) {
                if (element == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!MessageBundleReferenceContributor.isExportableKey(text)) {
                    return null;
                }
                String id = text.replace(MessageBundleReferenceContributor.EXPORTABLE_PREFIX, "").replace(MessageBundleReferenceContributor.EXPORTABLE_SUFFIX, "");
                return new ExportableIdReference(element, id);
            }

            @Nullable
            private static PsiReference createPluginIdReference(@NotNull PsiElement element, String text) {
                if (element == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (!MessageBundleReferenceContributor.isPluginDescriptionKey(text)) {
                    return null;
                }
                String id = StringUtil.substringAfter((String)StringUtil.notNullize((String)StringUtil.substringBefore((String)text, (String)MessageBundleReferenceContributor.DESCRIPTION)), (String)MessageBundleReferenceContributor.PLUGIN);
                return new PluginIdReference(element, id);
            }

            @Nullable
            private static PsiReference createAdvancedSettingReference(@NotNull PsiElement element, String text) {
                if (element == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (!MessageBundleReferenceContributor.isAdvancedSettingKey(text)) {
                    return null;
                }
                String s = StringUtil.notNullize((String)StringUtil.substringAfter((String)text, (String)MessageBundleReferenceContributor.ADVANCED_SETTING));
                String id = s.endsWith(MessageBundleReferenceContributor.DESCRIPTION) ? StringUtil.trimEnd((String)s, (String)MessageBundleReferenceContributor.DESCRIPTION) : (s.endsWith(MessageBundleReferenceContributor.TRAILING_LABEL) ? StringUtil.trimEnd((String)s, (String)MessageBundleReferenceContributor.TRAILING_LABEL) : s);
                TextRange range = TextRange.allOf((String)id).shiftRight(MessageBundleReferenceContributor.ADVANCED_SETTING.length());
                return new AdvancedSettingsIdContributor.AdvancedSettingReference(element, range);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createActionOrGroupIdReference";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "createToolwindowIdReference";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "createExportableIdReference";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginIdReference";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "createAdvancedSettingReference";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static VirtualFilePattern bundleFile() {
        return PlatformPatterns.virtualFile().ofType((FileType)PropertiesFileType.INSTANCE).withName((ElementPattern)StandardPatterns.string().endsWith(BUNDLE_PROPERTIES));
    }

    private static boolean isPluginProject(PsiElement property) {
        return PsiUtil.isPluginProject(property.getProject());
    }

    private static boolean isActionOrGroupKey(String name) {
        return !(!name.startsWith(ACTION) && !name.startsWith(GROUP) || !name.endsWith(TEXT) && !name.endsWith(DESCRIPTION));
    }

    private static boolean isExportableKey(String name) {
        return name.startsWith(EXPORTABLE_PREFIX) && name.endsWith(EXPORTABLE_SUFFIX);
    }

    private static boolean isToolwindowKey(String name) {
        return name.startsWith(TOOLWINDOW_STRIPE_PREFIX);
    }

    private static boolean isPluginDescriptionKey(String name) {
        return name.startsWith(PLUGIN) && name.endsWith(DESCRIPTION);
    }

    private static boolean isAdvancedSettingKey(String name) {
        return name.startsWith(ADVANCED_SETTING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor", "registerReferenceProviders"));
    }

    static final class ImplicitUsageProvider
    implements ImplicitPropertyUsageProvider {
        @NonNls
        private static final String ICON_TOOLTIP_PREFIX = "icon.";
        @NonNls
        private static final String ICON_TOOLTIP_SUFFIX = ".tooltip";

        ImplicitUsageProvider() {
        }

        public boolean isUsed(@NotNull Property property) {
            PsiFile file;
            String fileName;
            if (property == null) {
                ImplicitUsageProvider.$$$reportNull$$$0(0);
            }
            if (!(fileName = (file = property.getContainingFile()).getName()).endsWith(MessageBundleReferenceContributor.BUNDLE_PROPERTIES)) {
                return false;
            }
            String name = property.getName();
            if (name == null) {
                return false;
            }
            if (MessageBundleReferenceContributor.isActionOrGroupKey(name) || MessageBundleReferenceContributor.isExportableKey(name) || MessageBundleReferenceContributor.isToolwindowKey(name) || MessageBundleReferenceContributor.isPluginDescriptionKey(name) || MessageBundleReferenceContributor.isAdvancedSettingKey(name)) {
                PsiElement key = property.getFirstChild();
                Object[] references = key == null ? PsiReference.EMPTY_ARRAY : key.getReferences();
                boolean hasResolve = ContainerUtil.exists((Object[])references, reference -> {
                    boolean unresolved = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : reference.resolve() == null;
                    return !unresolved;
                });
                return hasResolve && MessageBundleReferenceContributor.isPluginProject((PsiElement)property);
            }
            return ImplicitUsageProvider.isIconTooltipKey(name) && MessageBundleReferenceContributor.isPluginProject((PsiElement)property);
        }

        private static boolean isIconTooltipKey(String name) {
            return name.startsWith(ICON_TOOLTIP_PREFIX) && name.endsWith(ICON_TOOLTIP_SUFFIX);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor$ImplicitUsageProvider", "isUsed"));
        }
    }

    private static class ExportableIdReference
    extends PsiReferenceBase.Poly<PsiElement> {
        private ExportableIdReference(PsiElement element, String id) {
            super(element, TextRange.allOf((String)id).shiftRight(MessageBundleReferenceContributor.EXPORTABLE_PREFIX.length()), false);
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            String id = this.getValue();
            SmartList resolves = new SmartList();
            this.processStateAnnoClasses((PairProcessor<PsiClass, String>)((PairProcessor)(arg_0, arg_1) -> ExportableIdReference.lambda$multiResolve$0(id, (List)resolves, arg_0, arg_1)));
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)resolves);
            if (resolveResultArray == null) {
                ExportableIdReference.$$$reportNull$$$0(0);
            }
            return resolveResultArray;
        }

        public Object @NotNull [] getVariants() {
            SmartList variants = new SmartList();
            PairProcessor variantProcessor = (arg_0, arg_1) -> ExportableIdReference.lambda$getVariants$1((List)variants, arg_0, arg_1);
            this.processStateAnnoClasses((PairProcessor<PsiClass, String>)variantProcessor);
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                ExportableIdReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        private void processStateAnnoClasses(PairProcessor<PsiClass, String> processor) {
            Project project = this.myElement.getProject();
            GlobalSearchScope searchScope = IntelliJProjectUtil.isIntelliJPlatformProject((Project)project) ? GlobalSearchScopesCore.projectProductionScope((Project)project) : this.getElement().getResolveScope();
            PsiClass statePsiClass = JavaPsiFacade.getInstance((Project)project).findClass(State.class.getName(), searchScope);
            if (statePsiClass == null) {
                return;
            }
            Query query = AnnotatedElementsSearch.searchPsiClasses((PsiClass)statePsiClass, (SearchScope)searchScope);
            query.forEach(psiClass -> {
                PsiAnnotation stateAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (boolean)true, (String[])new String[]{State.class.getName()});
                assert (stateAnnotation != null) : psiClass;
                if (AnnotationUtil.findDeclaredAttribute((PsiAnnotation)stateAnnotation, (String)"presentableName") != null) {
                    return true;
                }
                String nameAttributeValue = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)stateAnnotation, (String)"name");
                if (StringUtil.isEmpty((String)nameAttributeValue)) {
                    return true;
                }
                return processor.process(psiClass, (Object)nameAttributeValue);
            });
        }

        private static /* synthetic */ boolean lambda$getVariants$1(List variants, PsiClass psiClass, String id) {
            variants.add(LookupElementBuilder.create((Object)psiClass, (String)id).withTypeText(psiClass.getQualifiedName()));
            return true;
        }

        private static /* synthetic */ boolean lambda$multiResolve$0(String id, List resolves, PsiClass psiClass, String name) {
            if (StringUtil.equals((CharSequence)id, (CharSequence)name)) {
                resolves.add(psiClass);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor$ExportableIdReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ToolwindowIdReference
    extends ExtensionReferenceBase {
        private ToolwindowIdReference(@NotNull PsiElement element, String id) {
            if (element == null) {
                ToolwindowIdReference.$$$reportNull$$$0(0);
            }
            super(element, TextRange.allOf((String)id).shiftRight(MessageBundleReferenceContributor.TOOLWINDOW_STRIPE_PREFIX.length()));
        }

        @Override
        protected String getExtensionPointFqn() {
            return "com.intellij.toolWindow";
        }

        @InspectionMessage
        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = DevKitBundle.message("message.bundle.convert.toolwindow.id.cannot.resolve", this.getValue());
            if (string == null) {
                ToolwindowIdReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        @NlsSafe
        protected String getResolveValue() {
            String string = super.getResolveValue().replace('_', ' ');
            if (string == null) {
                ToolwindowIdReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Object @NotNull [] getVariants() {
            List<LookupElement> variants = Collections.synchronizedList(new SmartList());
            this.processCandidates((Processor<? super Extension>)((Processor)extension -> {
                GenericAttributeValue<String> id = extension.getId();
                if (id == null || extension.getXmlElement() == null) {
                    return true;
                }
                String value = id.getStringValue();
                if (value == null) {
                    return true;
                }
                variants.add((LookupElement)LookupElementBuilder.create((Object)extension.getXmlElement(), (String)value.replace(' ', '_')).withTypeText(ToolwindowIdReference.getAttributeValue(extension, "factoryClass")));
                return true;
            }));
            Object[] objectArray = variants.toArray(LookupElement.EMPTY_ARRAY);
            if (objectArray == null) {
                ToolwindowIdReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor$ToolwindowIdReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor$ToolwindowIdReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolveValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class PluginIdReference
    extends PsiPolyVariantReferenceBase<PsiElement> {
        private PluginIdReference(@NotNull PsiElement element, String id) {
            if (element == null) {
                PluginIdReference.$$$reportNull$$$0(0);
            }
            super(element, TextRange.allOf((String)id).shiftRight(MessageBundleReferenceContributor.PLUGIN.length()));
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            SmartList psiElements = new SmartList();
            String id = this.getValue();
            Project project = this.getElement().getProject();
            for (IdeaPlugin plugin : this.getRelevantPlugins()) {
                if (!id.equals(plugin.getPluginId())) continue;
                DomTarget target = DomTarget.getTarget((DomElement)plugin);
                assert (target != null);
                psiElements.add(PomService.convertToPsi((Project)project, (PomTarget)target));
            }
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)psiElements);
            if (resolveResultArray == null) {
                PluginIdReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array(this.getRelevantPlugins(), LookupElement.class, plugin -> LookupElementBuilder.create((String)Objects.requireNonNull(plugin.getPluginId())).withPsiElement((PsiElement)plugin.getXmlElement()).withTailText(" " + StringUtil.notNullize((String)((String)plugin.getName().getValue()))).withIcon(ElementPresentationManager.getIcon((Object)plugin)));
            if (objectArray == null) {
                PluginIdReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private Collection<IdeaPlugin> getRelevantPlugins() {
            return ContainerUtil.filter(DescriptorUtil.getPlugins(this.getElement().getProject(), this.getElement().getResolveScope()), plugin -> plugin.hasRealPluginId() && Boolean.TRUE != plugin.getImplementationDetail().getValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor$PluginIdReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/MessageBundleReferenceContributor$PluginIdReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

