/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.util.PsiUtil;

public final class ExtensionPointBinding {
    private final PsiClass myPsiClass;

    public ExtensionPointBinding(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ExtensionPointBinding.$$$reportNull$$$0(0);
        }
        this.myPsiClass = psiClass;
    }

    public void visit(BindingVisitor visitor) {
        NotNullLazyValue hasClassLevelPropertyAnnotation = NotNullLazyValue.lazy(() -> this.hasClassLevelPropertyAnnotation());
        for (PsiField field : this.myPsiClass.getAllFields()) {
            String tagName;
            PsiAnnotation attributeAnnotation;
            if (field.hasModifierProperty("static") || field.hasModifierProperty("volatile")) continue;
            NullableLazyValue getter = NullableLazyValue.lazyNullable(() -> PropertyUtilBase.findGetterForField((PsiField)field));
            NullableLazyValue setter = NullableLazyValue.lazyNullable(() -> PropertyUtilBase.findSetterForField((PsiField)field));
            if (!field.hasModifierProperty("public") && (getter.getValue() == null || setter.getValue() == null)) continue;
            PsiAnnotation requiredAnnotation = ExtensionPointBinding.findAnnotationForField(RequiredElement.class, field, (NullableLazyValue<PsiMethod>)getter, (NullableLazyValue<PsiMethod>)setter);
            BindingVisitor.RequiredFlag required = BindingVisitor.RequiredFlag.NOT_REQUIRED;
            if (requiredAnnotation != null) {
                BindingVisitor.RequiredFlag requiredFlag = required = PsiUtil.getAnnotationBooleanAttribute(requiredAnnotation, "allowEmpty") ? BindingVisitor.RequiredFlag.REQUIRED_ALLOW_EMPTY : BindingVisitor.RequiredFlag.REQUIRED;
            }
            if ((attributeAnnotation = ExtensionPointBinding.findAnnotationForField(Attribute.class, field, (NullableLazyValue<PsiMethod>)getter, (NullableLazyValue<PsiMethod>)setter)) != null) {
                String fieldName = PsiUtil.getAnnotationStringAttribute(attributeAnnotation, "value", field.getName());
                if (fieldName == null) continue;
                visitor.visitAttribute(field, fieldName, required);
                continue;
            }
            if (((Boolean)hasClassLevelPropertyAnnotation.get()).booleanValue()) {
                visitor.visitAttribute(field, field.getName(), required);
                continue;
            }
            PsiAnnotation tagAnno = ExtensionPointBinding.findAnnotationForField(Tag.class, field, (NullableLazyValue<PsiMethod>)getter, (NullableLazyValue<PsiMethod>)setter);
            PsiAnnotation collectionAnnotation = ExtensionPointBinding.findAnnotationForField(XCollection.class, field, (NullableLazyValue<PsiMethod>)getter, (NullableLazyValue<PsiMethod>)setter);
            String fieldName = field.getName();
            if (tagAnno != null) {
                tagName = PsiUtil.getAnnotationStringAttribute(tagAnno, "value", fieldName);
            } else {
                PsiAnnotation propAnno = ExtensionPointBinding.findAnnotationForField(Property.class, field, (NullableLazyValue<PsiMethod>)getter, (NullableLazyValue<PsiMethod>)setter);
                String string = tagName = propAnno != null && PsiUtil.getAnnotationBooleanAttribute(propAnno, "surroundWithTag") ? "option" : null;
            }
            if (tagName != null && collectionAnnotation == null) {
                visitor.visitTagOrProperty(field, tagName, required);
                continue;
            }
            if (collectionAnnotation == null) continue;
            visitor.visitXCollection(field, tagName, collectionAnnotation, required);
        }
    }

    @Nullable
    private static PsiAnnotation findAnnotationForField(Class<?> annotationClass, PsiField field, NullableLazyValue<PsiMethod> fieldGetter, NullableLazyValue<PsiMethod> fieldSetter) {
        PsiAnnotation annotation = PsiUtil.findAnnotation(annotationClass, new PsiMember[]{field});
        if (annotation != null) {
            return annotation;
        }
        annotation = PsiUtil.findAnnotation(annotationClass, (PsiMember)fieldGetter.getValue());
        if (annotation != null) {
            return annotation;
        }
        return PsiUtil.findAnnotation(annotationClass, (PsiMember)fieldSetter.getValue());
    }

    private boolean hasClassLevelPropertyAnnotation() {
        PsiAnnotation propertyAnnotation = this.myPsiClass.getAnnotation(Property.class.getName());
        if (propertyAnnotation == null) {
            return false;
        }
        PsiNameValuePair style = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)propertyAnnotation, (String)"style");
        if (style == null) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)style.getDetachedValue(), PsiReferenceExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        PsiEnumConstant enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiEnumConstant.class);
        return enumConstant != null && enumConstant.getName().equals(Property.Style.ATTRIBUTE.name());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/idea/devkit/references/extensions/ExtensionPointBinding", "<init>"));
    }

    @ApiStatus.OverrideOnly
    public static interface BindingVisitor {
        public void visitAttribute(@NotNull PsiField var1, @NotNull @NonNls String var2, RequiredFlag var3);

        public void visitTagOrProperty(@NotNull PsiField var1, @NotNull @NonNls String var2, RequiredFlag var3);

        public void visitXCollection(@NotNull PsiField var1, @Nullable @NonNls String var2, @NotNull PsiAnnotation var3, RequiredFlag var4);

        public static enum RequiredFlag {
            NOT_REQUIRED,
            REQUIRED,
            REQUIRED_ALLOW_EMPTY;

        }
    }
}

