/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.requestHandlers;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.project.ProjectKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.idea.devkit.requestHandlers.BuildHttpRequestHandlerKt;
import org.jetbrains.idea.devkit.requestHandlers.BuildRequestAsyncHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/requestHandlers/BuildHttpRequestHandler;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nBuildHttpRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHttpRequestHandler.kt\norg/jetbrains/idea/devkit/requestHandlers/BuildHttpRequestHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,148:1\n31#2,2:149\n*S KotlinDebug\n*F\n+ 1 BuildHttpRequestHandler.kt\norg/jetbrains/idea/devkit/requestHandlers/BuildHttpRequestHandler\n*L\n84#1:149,2\n*E\n"})
final class BuildHttpRequestHandler
extends HttpRequestHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/devkit/build", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map query = urlDecoder.parameters();
        List list = (List)query.get("project-hash");
        String projectHash = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
        Project project = null;
        if (projectHash == null) {
            Object object;
            block6: {
                List list2 = (List)query.get("project-path");
                String projectPath = list2 != null ? (String)CollectionsKt.firstOrNull((List)list2) : null;
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                for (Object object2 : (Object[])projectArray) {
                    Project it = (Project)object2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    Path path = ProjectKt.getStateStore((Project)it).getProjectBasePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getProjectBasePath(...)");
                    if (!Intrinsics.areEqual((Object)PathsKt.getInvariantSeparatorsPathString((Path)path), (Object)projectPath)) continue;
                    object = object2;
                    break block6;
                }
                object = null;
            }
            project = (Project)object;
        } else {
            project = ProjectManager.getInstance().findOpenProjectByHash(projectHash);
        }
        if (project == null) {
            BuildHttpRequestHandlerKt.access$getLOG$p().info("Project is not found (query=" + query + ")");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        if (!IntelliJProjectUtil.isIntelliJPlatformProject((Project)project)) {
            BuildHttpRequestHandlerKt.access$getLOG$p().info("Build requests are currently handled for 'intellij' project only, so request won't be processed (query=" + query + ")");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<BuildRequestAsyncHandler> serviceClass$iv = BuildRequestAsyncHandler.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildRequestAsyncHandler buildRequestAsyncHandler = (BuildRequestAsyncHandler)object;
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        buildRequestAsyncHandler.handle(request, channel);
        return true;
    }
}

