/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.requestHandlers;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.protobuf.ProtoBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.idea.devkit.requestHandlers.CompileHttpRequestHandlerKt;
import org.jetbrains.idea.devkit.requestHandlers.CompileHttpRequestHandlerToken;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/requestHandlers/CompileHttpRequestHandler;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nCompileHttpRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileHttpRequestHandler.kt\norg/jetbrains/idea/devkit/requestHandlers/CompileHttpRequestHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,115:1\n40#2,3:116\n196#3:119\n1557#4:120\n1628#4,3:121\n37#5,2:124\n*S KotlinDebug\n*F\n+ 1 CompileHttpRequestHandler.kt\norg/jetbrains/idea/devkit/requestHandlers/CompileHttpRequestHandler\n*L\n65#1:116,3\n85#1:119\n96#1:120\n96#1:121,3\n96#1:124,2\n*E\n"})
final class CompileHttpRequestHandler
extends HttpRequestHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/devkit/make", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        List $this$decodeFromByteArray$iv;
        Map query;
        Channel channel;
        block10: {
            block9: {
                String token;
                Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                channel = context.channel();
                query = urlDecoder.parameters();
                List list = (List)query.get("token");
                String string = token = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
                if (token == null) break block9;
                boolean $i$f$service = false;
                Class<CompileHttpRequestHandlerToken> serviceClass$iv = CompileHttpRequestHandlerToken.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                if (((CompileHttpRequestHandlerToken)object).hasToken(token)) break block10;
            }
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.FORBIDDEN;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"FORBIDDEN");
            Intrinsics.checkNotNull((Object)channel);
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        List list = (List)query.get("project-hash");
        String projectHash = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
        Project project = ProjectManager.getInstance().findOpenProjectByHash(projectHash);
        if (project == null) {
            CompileHttpRequestHandlerKt.access$getLOG$p().info("Project is not found (query=" + query + ")");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Intrinsics.checkNotNull((Object)channel);
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        if (!IntelliJProjectUtil.isIntelliJPlatformProject((Project)project)) {
            CompileHttpRequestHandlerKt.access$getLOG$p().info("Build requests are currently handled for 'intellij' project only, so request won't be processed (query=" + query + ")");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.FORBIDDEN;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"FORBIDDEN");
            Intrinsics.checkNotNull((Object)channel);
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        try {
            BinaryFormat binaryFormat = (BinaryFormat)ProtoBuf.Default;
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)request.content());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] bytes$iv = byArray;
            boolean $i$f$decodeFromByteArray = false;
            $this$decodeFromByteArray$iv.getSerializersModule();
            $this$decodeFromByteArray$iv = (List)$this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), bytes$iv);
        }
        catch (SerializationException e) {
            CompileHttpRequestHandlerKt.access$getLOG$p().info((Throwable)e);
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_REQUEST");
            Intrinsics.checkNotNull((Object)channel);
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        List modules = $this$decodeFromByteArray$iv;
        ProjectTaskManager projectTaskManager = ProjectTaskManager.getInstance((Project)project);
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        Iterable iterable = modules;
        ProjectTaskManager projectTaskManager2 = projectTaskManager;
        boolean $i$f$map = false;
        void var15_19 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(moduleManager.findModuleByName((String)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ProjectTask projectTask = projectTaskManager2.createModulesBuildTask(thisCollection$iv.toArray(new Module[0]), true, false, false, false);
        projectTaskManager.run(projectTask).onSuccess(arg_0 -> CompileHttpRequestHandler.process$lambda$2(arg_0 -> CompileHttpRequestHandler.process$lambda$1(channel, request, arg_0), arg_0)).onError(arg_0 -> CompileHttpRequestHandler.process$lambda$4(arg_0 -> CompileHttpRequestHandler.process$lambda$3(channel, request, arg_0), arg_0));
        return true;
    }

    private static final Unit process$lambda$1(Channel $channel, FullHttpRequest $request, ProjectTaskManager.Result taskResult) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)("{hasErrors: " + taskResult.hasErrors() + ", isAborted: " + taskResult.isAborted() + "}"), (Charset)Charsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        HttpResponse httpResponse = (HttpResponse)response;
        Intrinsics.checkNotNull((Object)$channel);
        Responses.send$default((HttpResponse)httpResponse, (Channel)$channel, (HttpRequest)((HttpRequest)$request), null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit process$lambda$3(Channel $channel, FullHttpRequest $request, Throwable error) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
        Intrinsics.checkNotNull((Object)$channel);
        Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)$channel, (HttpRequest)((HttpRequest)$request), (String)"Build cancelled", null, (int)8, null);
        CompileHttpRequestHandlerKt.access$getLOG$p().warn(error);
        return Unit.INSTANCE;
    }

    private static final void process$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

