/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.requestHandlers;

import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/devkit/requestHandlers/HttpDebugListener;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "isAccessible", "Lio/netty/handler/codec/http/HttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "Companion", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nHttpDebugListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpDebugListener.kt\norg/jetbrains/idea/devkit/requestHandlers/HttpDebugListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,62:1\n12574#2,2:63\n*S KotlinDebug\n*F\n+ 1 HttpDebugListener.kt\norg/jetbrains/idea/devkit/requestHandlers/HttpDebugListener\n*L\n48#1:63,2\n*E\n"})
public final class HttpDebugListener
extends HttpRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NonNls
    @NotNull
    private static final String PREFIX = "/debug/attachToTestProcess";

    public HttpDebugListener() {
        Logger logger = Logger.getInstance(HttpDebugListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!Intrinsics.areEqual((Object)request.method(), (Object)HttpMethod.POST)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String content = request.content().toString(Charset.defaultCharset());
        Object[] objectArray = StringUtil.splitByLines((String)content);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"splitByLines(...)");
        Object[] contentLines = objectArray;
        String port = contentLines[0];
        String name = (String)ArraysKt.getOrNull((Object[])contentLines, (int)1);
        this.logger.info("Debugger attach request to a test process by port '" + port + "' as '" + name + "'");
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            boolean bl;
            Project project2;
            block2: {
                Intrinsics.checkNotNull((Object)project);
                project2 = project;
                if (!IntelliJProjectUtil.isIntelliJPlatformProject((Project)project2)) continue;
                ExecutionManager executionManager = ExecutionManager.Companion.getInstance(project2);
                ProcessHandler[] $this$any$iv = executionManager.getRunningProcesses();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    ProcessHandler element$iv;
                    ProcessHandler it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!(!it.isProcessTerminated())) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            ApplicationManager.getApplication().invokeAndWait(() -> HttpDebugListener.process$lambda$1(port, name, project2));
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
            return true;
        }
        this.logger.info("No IDEA projects with active test session were found");
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_REQUEST");
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
        return true;
    }

    private static final void process$lambda$1(String $port, String $name, Project $project) {
        JavaAttachDebuggerProvider.attach((String)"dt_socket", (String)$port, (String)$name, (Project)$project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/devkit/requestHandlers/HttpDebugListener$Companion;", "", "<init>", "()V", "PREFIX", "", "intellij.devkit.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

