/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.codeWithMe.ClientId;
import com.intellij.compiler.options.MakeProjectStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaRunConfigurationBase;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.platform.ijent.community.buildConstants.IjentBuildScriptsConstantsKt;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.idea.devkit.requestHandlers.BuiltInServerConnectionData;
import org.jetbrains.idea.devkit.requestHandlers.CompileHttpRequestHandlerToken;
import org.jetbrains.idea.devkit.run.DevKitApplicationPatcherKt;
import org.jetbrains.idea.devkit.run.JUnitDevKitPatcher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u0005\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/devkit/run/DevKitApplicationPatcher;", "Lcom/intellij/execution/RunConfigurationExtension;", "<init>", "()V", "updateJavaParameters", "", "T", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "configuration", "javaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "enableIjentDefaultFsProvider", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/execution/JavaRunConfigurationBase;", "vmParameters", "Lcom/intellij/execution/configurations/ParametersList;", "updateParametersForDevBuild", "isApplicableFor", "", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nDevKitApplicationPatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevKitApplicationPatcher.kt\norg/jetbrains/idea/devkit/run/DevKitApplicationPatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,269:1\n1755#2,3:270\n2632#2,3:273\n2632#2,3:276\n2632#2,3:279\n2632#2,3:282\n2632#2,3:285\n40#3,3:288\n*S KotlinDebug\n*F\n+ 1 DevKitApplicationPatcher.kt\norg/jetbrains/idea/devkit/run/DevKitApplicationPatcher\n*L\n77#1:270,3\n96#1:273,3\n99#1:276,3\n102#1:279,3\n105#1:282,3\n138#1:285,3\n141#1:288,3\n*E\n"})
public final class DevKitApplicationPatcher
extends RunConfigurationExtension {
    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters javaParameters, @Nullable RunnerSettings runnerSettings) {
        boolean bl;
        boolean isDevBuild;
        ParametersList vmParameters;
        Project project;
        block37: {
            boolean bl2;
            boolean $i$f$none;
            Iterable $this$none$iv;
            String it;
            List vmParametersAsList;
            block36: {
                boolean bl3;
                boolean is17;
                block34: {
                    boolean bl4;
                    String[] $this$any$iv;
                    block33: {
                        Object object;
                        String qualifiedName;
                        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
                        Intrinsics.checkNotNullParameter((Object)javaParameters, (String)"javaParameters");
                        Project project2 = configuration.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        project = project2;
                        if (!IntelliJProjectUtil.isIntelliJPlatformProject((Project)project)) {
                            return;
                        }
                        if (!(configuration instanceof JavaRunConfigurationBase)) {
                            return;
                        }
                        if (configuration instanceof JavaScratchConfiguration) {
                            return;
                        }
                        String string = ((CommonJavaRunConfigurationParameters)configuration).getRunClass();
                        if (string == null) {
                            return;
                        }
                        String mainClass = string;
                        BuiltInServerConnectionData.passDataAboutBuiltInServer(javaParameters, project);
                        vmParameters = javaParameters.getVMParametersList();
                        Module module = ((JavaRunConfigurationModule)((JavaRunConfigurationBase)configuration).getConfigurationModule()).getModule();
                        if (module == null) {
                            return;
                        }
                        Module module2 = module;
                        Sdk sdk = JavaParameters.getJdkToRunModule((Module)module2, (boolean)true);
                        if (sdk == null) {
                            return;
                        }
                        Sdk jdk = sdk;
                        if (!Boolean.parseBoolean(vmParameters.getPropertyValue("intellij.devkit.skip.automatic.add.opens"))) {
                            JUnitDevKitPatcher.appendAddOpensWhenNeeded(project, jdk, vmParameters);
                        }
                        isDevBuild = Intrinsics.areEqual((Object)mainClass, (Object)"org.jetbrains.intellij.build.devServer.DevMainKt");
                        List list = vmParameters.getList();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
                        vmParametersAsList = list;
                        if (vmParametersAsList.contains("--add-modules") || !isDevBuild && !Intrinsics.areEqual((Object)mainClass, (Object)"com.intellij.idea.Main")) {
                            return;
                        }
                        if (!vmParameters.hasProperty("java.system.class.loader") && JUnitDevKitPatcher.loaderValid(project, module2, qualifiedName = "com.intellij.util.lang.PathClassLoader")) {
                            vmParameters.addProperty("java.system.class.loader", qualifiedName);
                            vmParameters.addProperty("idea.classpath.index.enabled", "true");
                        }
                        is17 = (object = javaParameters.getJdk()) != null && (object = object.getVersionString()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"17", (boolean)false, (int)2, null) : false;
                        $this$any$iv = (String[])vmParametersAsList;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object t : $this$any$iv) {
                                it = (String)t;
                                boolean bl5 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (!(StringsKt.contains$default((CharSequence)it, (CharSequence)"CICompilerCount", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"TieredCompilation", (boolean)false, (int)2, null))) continue;
                                bl4 = true;
                                break block33;
                            }
                            bl4 = false;
                        }
                    }
                    if (!bl4) {
                        $this$any$iv = new String[]{"-XX:CICompilerCount=2"};
                        vmParameters.addAll($this$any$iv);
                        if (!is17) {
                            $this$any$iv = new String[]{"-XX:+UnlockDiagnosticVMOptions"};
                            vmParameters.addAll($this$any$iv);
                            $this$any$iv = new String[]{"-XX:TieredOldPercentage=100000"};
                            vmParameters.addAll($this$any$iv);
                        }
                    }
                    $this$any$iv = new String[]{"-XX:MaxJavaStackTraceDepth=10000", "-ea"};
                    vmParameters.addAll($this$any$iv);
                    if (runnerSettings instanceof DebuggingRunnerData) {
                        vmParameters.defineProperty("kotlinx.coroutines.debug.enable.creation.stack.trace", "true");
                    }
                    $this$none$iv = vmParametersAsList;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object t : $this$none$iv) {
                            it = (String)t;
                            boolean bl6 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!StringsKt.startsWith$default((String)it, (String)"-Xmx", (boolean)false, (int)2, null)) continue;
                            bl3 = false;
                            break block34;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    vmParameters.add("-Xmx2g");
                }
                if (is17) {
                    boolean bl5;
                    block35: {
                        $this$none$iv = vmParametersAsList;
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl5 = true;
                        } else {
                            for (Object t : $this$none$iv) {
                                it = (String)t;
                                boolean bl8 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (!StringsKt.startsWith$default((String)it, (String)"-XX:SoftRefLRUPolicyMSPerMB", (boolean)false, (int)2, null)) continue;
                                bl5 = false;
                                break block35;
                            }
                            bl5 = true;
                        }
                    }
                    if (bl5) {
                        vmParameters.add("-XX:SoftRefLRUPolicyMSPerMB=50");
                    }
                }
                $this$none$iv = vmParametersAsList;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object t : $this$none$iv) {
                        it = (String)t;
                        boolean bl9 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!StringsKt.startsWith$default((String)it, (String)"-XX:ReservedCodeCacheSize", (boolean)false, (int)2, null)) continue;
                        bl2 = false;
                        break block36;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                vmParameters.add("-XX:ReservedCodeCacheSize=512m");
            }
            $this$none$iv = vmParametersAsList;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object t : $this$none$iv) {
                    it = (String)t;
                    boolean bl10 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!StringsKt.startsWith$default((String)it, (String)"-Djava.util.zip.use.nio.for.zip.file.access", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block37;
                }
                bl = true;
            }
        }
        if (bl) {
            vmParameters.add("-Djava.util.zip.use.nio.for.zip.file.access=true");
        }
        JavaRunConfigurationBase javaRunConfigurationBase = (JavaRunConfigurationBase)configuration;
        Intrinsics.checkNotNull((Object)vmParameters);
        this.enableIjentDefaultFsProvider(project, javaRunConfigurationBase, vmParameters);
        if (isDevBuild) {
            this.updateParametersForDevBuild(javaParameters, (JavaRunConfigurationBase)configuration, project);
        }
    }

    private final void enableIjentDefaultFsProvider(Project project, JavaRunConfigurationBase configuration, ParametersList vmParameters) {
        if (JUnitDevKitPatcher.loaderValid(project, null, "com.intellij.platform.core.nio.fs.MultiRoutingFileSystemProvider")) {
            boolean isIjentWslFsEnabled = DevKitApplicationPatcherKt.access$isIjentWslFsEnabledByDefaultForProduct_Reflective(configuration.getWorkingDirectory(), vmParameters.getPropertyValue("idea.platform.prefix"));
            vmParameters.add("-Dwsl.use.remote.agent.for.nio.filesystem=" + isIjentWslFsEnabled);
            if (isIjentWslFsEnabled) {
                vmParameters.addAll(IjentBuildScriptsConstantsKt.getMULTI_ROUTING_FILE_SYSTEM_VMOPTIONS());
                vmParameters.add("-Xbootclasspath/a:" + configuration.getWorkingDirectory() + "/out/classes/production/intellij.platform.core.nio.fs");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateParametersForDevBuild(JavaParameters javaParameters, JavaRunConfigurationBase configuration, Project project) {
        String productClassifier;
        String serviceClass$iv22;
        boolean bl;
        ParametersList vmParameters;
        block12: {
            vmParameters = javaParameters.getVMParametersList();
            List list = configuration.getBeforeRunTasks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBeforeRunTasks(...)");
            Iterable $this$none$iv = list;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object object : $this$none$iv) {
                    BeforeRunTask it = (BeforeRunTask)object;
                    boolean bl2 = false;
                    if (!(it.getProviderId() == MakeProjectStepBeforeRun.ID)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            vmParameters.addProperty("compile.server.port", String.valueOf(BuiltInServerManager.Companion.getInstance().getPort()));
            vmParameters.addProperty("compile.server.project", project.getLocationHash());
            boolean $i$f$service = false;
            Class<CompileHttpRequestHandlerToken> serviceClass$iv22 = CompileHttpRequestHandlerToken.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv22);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv22.getName() + " (classloader=" + serviceClass$iv22.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            vmParameters.addProperty("compile.server.token", ((CompileHttpRequestHandlerToken)object).acquireToken());
        }
        String string = (serviceClass$iv22 = (productClassifier = vmParameters.getPropertyValue("idea.platform.prefix"))) == null ? "idea" : (productClassifier = Intrinsics.areEqual((Object)serviceClass$iv22, (Object)"Idea") ? "idea-community" : productClassifier);
        if (!vmParameters.hasProperty("idea.config.path")) {
            String string2 = configuration.getWorkingDirectory();
            String string3 = productClassifier.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String string4 = FileUtilRt.toSystemIndependentName((String)(string2 + "/out/dev-data/" + string3));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toSystemIndependentName(...)");
            String dir = string4;
            vmParameters.addProperty("idea.config.path", dir + "/config");
            vmParameters.addProperty("idea.system.path", dir + "/system");
        }
        Path runDir = Path.of(configuration.getWorkingDirectory() + "/out/dev-run/" + productClassifier + "/" + productClassifier, new String[0]);
        Intrinsics.checkNotNull((Object)runDir);
        for (Map.Entry entry : DevKitApplicationPatcherKt.access$getIdeSystemProperties(runDir).entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            vmParameters.addProperty(name, value);
        }
        if (Boolean.parseBoolean(vmParameters.getPropertyValue("idea.dev.skip.build"))) {
            void var8_16;
            vmParameters.addProperty("idea.home.path", PathsKt.getInvariantSeparatorsPathString((Path)runDir));
            try {
                List<String> list = Files.readAllLines(runDir.resolve("core-classpath.txt"));
            }
            catch (NoSuchFileException noSuchFileException) {
                Object var8_15 = null;
            }
            void files = var8_16;
            if (files != null) {
                javaParameters.getClassPath().clear();
                javaParameters.getClassPath().addAll((List)files);
                javaParameters.setMainClass("com.intellij.idea.Main");
            }
        }
        vmParameters.addProperty("idea.vendor.name", "JetBrains");
        vmParameters.addProperty("idea.use.dev.build.server", "true");
        Intrinsics.checkNotNull((Object)vmParameters);
        DevKitApplicationPatcherKt.access$setPropertyIfAbsent(vmParameters, "idea.dev.build.unpacked");
        vmParameters.addProperty("sun.io.useCanonCaches", "false");
        vmParameters.addProperty("sun.awt.disablegrab", "true");
        vmParameters.addProperty("sun.java2d.metal", "true");
        vmParameters.addProperty("idea.debug.mode", "true");
        vmParameters.addProperty("idea.is.internal", "true");
        vmParameters.addProperty("fus.internal.test.mode", "true");
        vmParameters.addProperty("jdk.attach.allowAttachSelf");
        if (!vmParameters.hasParameter("-Didea.initially.ask.config=never")) {
            vmParameters.addProperty("idea.initially.ask.config", "true");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        if (configuration instanceof ApplicationConfiguration) return true;
        ConfigurationFactory configurationFactory = configuration.getFactory();
        if (!Intrinsics.areEqual((Object)(configurationFactory != null ? configurationFactory.getId() : null), (Object)"JetRunConfigurationType")) return false;
        return true;
    }
}

