/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.system.CpuArch;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.idea.devkit.run.DevKitApplicationPatcher;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u000e"}, d2={"setPropertyIfAbsent", "", "vmParameters", "Lcom/intellij/execution/configurations/ParametersList;", "name", "", "getIdeSystemProperties", "", "runDir", "Ljava/nio/file/Path;", "isIjentWslFsEnabledByDefaultForProduct_Reflective", "", "workingDirectory", "platformPrefix", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nDevKitApplicationPatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevKitApplicationPatcher.kt\norg/jetbrains/idea/devkit/run/DevKitApplicationPatcherKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,269:1\n14#2:270\n14#2:271\n*S KotlinDebug\n*F\n+ 1 DevKitApplicationPatcher.kt\norg/jetbrains/idea/devkit/run/DevKitApplicationPatcherKt\n*L\n240#1:270\n259#1:271\n*E\n"})
public final class DevKitApplicationPatcherKt {
    private static final void setPropertyIfAbsent(ParametersList vmParameters, String name) {
        if (!vmParameters.hasProperty(name)) {
            vmParameters.addProperty(name, "true");
        }
    }

    private static final Map<String, String> getIdeSystemProperties(Path runDir) {
        Path libDir = runDir.resolve("lib");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jna.boot.library.path", (Object)(libDir + "/jna/" + (CpuArch.isArm64() ? "aarch64" : "amd64"))), TuplesKt.to((Object)"pty4j.preferred.native.folder", (Object)(libDir + "/pty4j")), TuplesKt.to((Object)"jna.nosys", (Object)"true"), TuplesKt.to((Object)"jna.noclasspath", (Object)"true"), TuplesKt.to((Object)"compose.swing.render.on.graphics", (Object)"true")};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final boolean isIjentWslFsEnabledByDefaultForProduct_Reflective(String workingDirectory, String platformPrefix) {
        if (workingDirectory == null) {
            return false;
        }
        try {
            String[] stringArray = new String[]{"out/classes/production/intellij.platform.ijent.community.buildConstants"};
            URL buildConstantsClassPath = Path.of(workingDirectory, stringArray).toUri().toURL();
            boolean bl = false;
            URL[] systemClassLoader = ClassLoader.getSystemClassLoader();
            URL uRL = systemClassLoader.getResource("kotlin/collections/CollectionsKt.class");
            Intrinsics.checkNotNull((Object)uRL);
            URI kotlinCollectionsClassUri = uRL.toURI();
            if (!Intrinsics.areEqual((Object)kotlinCollectionsClassUri.getScheme(), (Object)"jar")) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(DevKitApplicationPatcher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Kotlin stdlib is not in a JAR: " + kotlinCollectionsClassUri);
                return false;
            }
            String string = kotlinCollectionsClassUri.getSchemeSpecificPart();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSchemeSpecificPart(...)");
            String osPath = StringsKt.removePrefix((String)(StringsKt.substringBefore$default((String)string, (String)".jar!", null, (int)2, null) + ".jar"), (CharSequence)(SystemInfo.isWindows ? "file:/" : "file:"));
            URL kotlinStdlibClassPath = Path.of(osPath, new String[0]).toUri().toURL();
            systemClassLoader = new URL[]{buildConstantsClassPath, kotlinStdlibClassPath};
            URLClassLoader tmpClassLoader = new URLClassLoader(systemClassLoader, null);
            Class<?> constantsClass = tmpClassLoader.loadClass("com.intellij.platform.ijent.community.buildConstants.IjentBuildScriptsConstantsKt");
            Class[] classArray = new Class[]{String.class};
            Method method = constantsClass.getDeclaredMethod("isIjentWslFsEnabledByDefaultForProduct", classArray);
            Object[] objectArray = new Object[]{platformPrefix};
            Object object = method.invoke(null, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            return (Boolean)object;
        }
        catch (Throwable err) {
            Throwable throwable = err;
            if (throwable instanceof ClassNotFoundException || throwable instanceof NoSuchMethodException || throwable instanceof IllegalAccessException || throwable instanceof InvocationTargetException) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(DevKitApplicationPatcher.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to reflectively load IJentWslFsEnabledByDefaultForProduct from built classes. Maybe the file didn't exist in this revision, so the IJent WSL FS was disabled.", err);
                return false;
            }
            throw err;
        }
    }

    public static final /* synthetic */ boolean access$isIjentWslFsEnabledByDefaultForProduct_Reflective(String workingDirectory, String platformPrefix) {
        return DevKitApplicationPatcherKt.isIjentWslFsEnabledByDefaultForProduct_Reflective(workingDirectory, platformPrefix);
    }

    public static final /* synthetic */ Map access$getIdeSystemProperties(Path runDir) {
        return DevKitApplicationPatcherKt.getIdeSystemProperties(runDir);
    }

    public static final /* synthetic */ void access$setPropertyIfAbsent(ParametersList vmParameters, String name) {
        DevKitApplicationPatcherKt.setPropertyIfAbsent(vmParameters, name);
    }
}

