/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.JavaModuleOptions;
import com.intellij.util.system.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.requestHandlers.BuiltInServerConnectionData;
import org.jetbrains.idea.devkit.run.JUnitDevKitUnitTestingSettings;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

final class JUnitDevKitPatcher
extends JUnitPatcher {
    private static final Logger LOG = Logger.getInstance(JUnitDevKitPatcher.class);
    static final String SYSTEM_CL_PROPERTY = "java.system.class.loader";
    private static final Key<Boolean> LOADER_VALID = Key.create((String)"LOADER_VALID_9");

    JUnitDevKitPatcher() {
    }

    public void patchJavaParameters(@NotNull Project project, @Nullable Module module, JavaParameters javaParameters) {
        Path sandboxHome;
        List<String> ids;
        Sdk jdk;
        if (project == null) {
            JUnitDevKitPatcher.$$$reportNull$$$0(0);
        }
        if ((jdk = javaParameters.getJdk()) == null) {
            return;
        }
        ParametersList vm = javaParameters.getVMParametersList();
        if (IntelliJProjectUtil.isIntelliJPlatformProject((Project)project)) {
            String qualifiedName;
            BuiltInServerConnectionData.passDataAboutBuiltInServer(javaParameters, project);
            if (!vm.hasProperty(SYSTEM_CL_PROPERTY) && !vm.getList().contains("--add-modules") && JUnitDevKitPatcher.loaderValid(project, module, qualifiedName = "com.intellij.util.lang.UrlClassLoader")) {
                vm.addProperty(SYSTEM_CL_PROPERTY, qualifiedName);
                vm.addProperty("idea.classpath.index.enabled", "true");
            }
            String basePath = project.getBasePath();
            if (!vm.hasProperty("idea.system.path")) {
                assert (basePath != null);
                vm.addProperty("idea.system.path", Path.of(basePath, "system/test").toAbsolutePath().toString());
            }
            if (!vm.hasProperty("idea.config.path")) {
                assert (basePath != null);
                vm.addProperty("idea.config.path", Path.of(basePath, "config/test").toAbsolutePath().toString());
            }
            JUnitDevKitPatcher.appendAddOpensWhenNeeded(project, jdk, vm);
            if (!Boolean.parseBoolean(vm.getPropertyValue("intellij.devkit.junit.skip.settings.from.intellij.yaml"))) {
                JUnitDevKitUnitTestingSettings.getInstance(project).apply(module, javaParameters);
            }
        }
        if ((jdk = IdeaJdk.findIdeaJdk(jdk)) == null) {
            return;
        }
        if (!vm.hasProperty("idea.load.plugins.id") && module != null && PluginModuleType.isOfType(module) && !(ids = DescriptorUtil.getPluginAndOptionalDependenciesIds(module)).isEmpty()) {
            vm.defineProperty("idea.load.plugins.id", String.join((CharSequence)",", ids));
        }
        if ((sandboxHome = JUnitDevKitPatcher.getSandboxPath(jdk)) != null) {
            if (!vm.hasProperty("idea.home.path")) {
                Path homeDir = sandboxHome.resolve("test");
                try {
                    Files.createDirectories(homeDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                String buildNumber = IdeaJdk.getBuildNumber(jdk.getHomePath());
                if (buildNumber != null) {
                    try {
                        Files.writeString(homeDir.resolve("build.txt"), (CharSequence)buildNumber, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        LOG.warn("failed to create build.txt in " + homeDir + ": " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    LOG.warn("Cannot determine build number for " + jdk.getHomePath());
                }
                vm.defineProperty("idea.home.path", homeDir.toString());
            }
            if (!vm.hasProperty("idea.plugins.path")) {
                vm.defineProperty("idea.plugins.path", sandboxHome.resolve("plugins").toString());
            }
        }
        String libPath = jdk.getHomePath() + File.separator + "lib" + File.separator;
        javaParameters.getClassPath().addFirst(libPath + "idea.jar");
        javaParameters.getClassPath().addFirst(libPath + "resources.jar");
    }

    static void appendAddOpensWhenNeeded(@NotNull Project project, @NotNull Sdk jdk, @NotNull ParametersList vm) {
        JavaSdkVersion sdkVersion;
        SdkTypeId sdkTypeId;
        if (project == null) {
            JUnitDevKitPatcher.$$$reportNull$$$0(1);
        }
        if (jdk == null) {
            JUnitDevKitPatcher.$$$reportNull$$$0(2);
        }
        if (vm == null) {
            JUnitDevKitPatcher.$$$reportNull$$$0(3);
        }
        if ((sdkTypeId = jdk.getSdkType()) instanceof JavaSdk) {
            JavaSdk javaSdk = (JavaSdk)sdkTypeId;
            v0 = javaSdk.getVersion(jdk);
        } else {
            v0 = sdkVersion = null;
        }
        if (sdkVersion != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_17)) {
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
            Collection files = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((String)"OpenedPackages.txt", (GlobalSearchScope)scope));
            if (files.size() > 1) {
                String list = files.stream().map(VirtualFile::getPresentableUrl).collect(Collectors.joining("\n"));
                String message = DevKitBundle.message("notification.message.duplicate.packages.file", list);
                new Notification("DevKit Errors", message, NotificationType.ERROR).notify(project);
            } else if (!files.isEmpty()) {
                VirtualFile file = (VirtualFile)files.iterator().next();
                try (InputStream stream = file.getInputStream();){
                    JavaModuleOptions.readOptions((InputStream)stream, (OS)OS.CURRENT).forEach(arg_0 -> ((ParametersList)vm).add(arg_0));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Failed to load --add-opens list from 'OpenedPackages.txt'", e);
                }
            }
        }
    }

    static boolean loaderValid(Project project, Module module, String qualifiedName) {
        Key<Boolean> cacheKey;
        Object holder = module == null ? project : module;
        Boolean result = (Boolean)holder.getUserData(cacheKey = LOADER_VALID);
        if (result == null) {
            result = (Boolean)ReadAction.compute(() -> (Boolean)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> {
                GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)project);
                return JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, scope) != null;
            }));
            holder.putUserData(cacheKey, (Object)result);
        }
        return result;
    }

    @Nullable
    private static Path getSandboxPath(Sdk jdk) {
        String sandboxHome;
        SdkAdditionalData additionalData = jdk.getSdkAdditionalData();
        if (additionalData instanceof Sandbox && (sandboxHome = ((Sandbox)additionalData).getSandboxHome()) != null) {
            return Path.of(sandboxHome, new String[0]).normalize().toAbsolutePath();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vm";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/run/JUnitDevKitPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "patchJavaParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendAddOpensWhenNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

