/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.IntelliJProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.run.ModulePathFilterProviderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/run/ModulePathFilterProvider;", "Lcom/intellij/execution/filters/ConsoleFilterProvider;", "<init>", "()V", "getDefaultFilters", "", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/execution/filters/Filter;", "ModulePathFilter", "intellij.devkit.core"})
public final class ModulePathFilterProvider
implements ConsoleFilterProvider {
    public ModulePathFilterProvider() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment() || !application.isInternal()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    @NotNull
    public Filter[] getDefaultFilters(@NotNull Project project) {
        Filter[] filterArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (IntelliJProjectUtil.isIntelliJPlatformProject((Project)project)) {
            Filter[] filterArray2 = new Filter[]{new ModulePathFilter(project)};
            filterArray = filterArray2;
        } else {
            filterArray = new Filter[]{};
        }
        return filterArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/run/ModulePathFilterProvider$ModulePathFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.devkit.core"})
    private static final class ModulePathFilter
    implements Filter {
        @NotNull
        private final Project project;

        public ModulePathFilter(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Sequence matchResult = Regex.findAll$default((Regex)ModulePathFilterProviderKt.access$getModulePattern$p(), (CharSequence)line, (int)0, (int)2, null);
            int textStartOffset = entireLength - line.length();
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
            List items = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)matchResult, arg_0 -> ModulePathFilter.applyFilter$lambda$0(moduleManager, textStartOffset, this, arg_0)));
            return !((Collection)items).isEmpty() ? new Filter.Result(items) : null;
        }

        private static final Filter.ResultItem applyFilter$lambda$0(ModuleManager $moduleManager, int $textStartOffset, ModulePathFilter this$0, MatchResult resultItem) {
            Intrinsics.checkNotNullParameter((Object)resultItem, (String)"resultItem");
            String moduleName = resultItem.getValue();
            Module module = $moduleManager.findModuleByName(moduleName);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            VirtualFile virtualFile = module2.getModuleFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile moduleFile = virtualFile;
            IntRange textRange = resultItem.getRange();
            return new Filter.ResultItem($textStartOffset + textRange.getFirst(), $textStartOffset + textRange.getLast() + 1, (HyperlinkInfo)new OpenFileHyperlinkInfo(this$0.project, moduleFile, 0, 0, false));
        }
    }
}

