/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.symbols;

import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.symbols.IntellijModuleNavigationTargetPointer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/symbols/IntellijModuleNavigationTarget;", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;Lcom/intellij/openapi/project/Project;)V", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "findModuleDirectory", "Lcom/intellij/psi/PsiDirectory;", "findModuleImlFile", "Lcom/intellij/psi/PsiFile;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nIntellijModuleSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijModuleSymbol.kt\norg/jetbrains/idea/devkit/symbols/IntellijModuleNavigationTarget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class IntellijModuleNavigationTarget
implements NavigationTarget {
    @NotNull
    private final ModuleEntity moduleEntity;
    @NotNull
    private final Project project;

    public IntellijModuleNavigationTarget(@NotNull ModuleEntity moduleEntity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.moduleEntity = moduleEntity;
        this.project = project;
    }

    @NotNull
    public Pointer<IntellijModuleNavigationTarget> createPointer() {
        return new IntellijModuleNavigationTargetPointer(this.moduleEntity.getSymbolicId(), this.project);
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this.moduleEntity.getName()).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        PsiDirectory psiDirectory = this.findModuleDirectory();
        if (psiDirectory != null) {
            PsiDirectory psiDirectory2 = psiDirectory;
            boolean bl = false;
            return NavigationRequest.Companion.directoryNavigationRequest(psiDirectory2);
        }
        PsiFile psiFile = this.findModuleImlFile();
        if (psiFile != null) {
            PsiFile file = psiFile;
            boolean bl = false;
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            return NavigationRequest.Companion.sourceNavigationRequest(file, textRange);
        }
        return null;
    }

    @Nullable
    public final PsiDirectory findModuleDirectory() {
        VirtualFile virtualFile;
        block2: {
            for (ContentRootEntity it : (Iterable)this.moduleEntity.getContentRoots()) {
                boolean bl = false;
                VirtualFile virtualFile2 = VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getUrl());
                if (virtualFile2 == null) continue;
                virtualFile = virtualFile2;
                break block2;
            }
            virtualFile = null;
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile firstContentRoot = virtualFile;
        return PsiManager.getInstance((Project)this.project).findDirectory(firstContentRoot);
    }

    @Nullable
    public final PsiFile findModuleImlFile() {
        VirtualFile imlFile;
        EntitySource entitySource = this.moduleEntity.getEntitySource();
        JpsProjectFileEntitySource.FileInDirectory fileInDirectory = entitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)entitySource : null;
        if (fileInDirectory == null) {
            return null;
        }
        JpsProjectFileEntitySource.FileInDirectory entitySource2 = fileInDirectory;
        VirtualFile virtualFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)entitySource2.getDirectory());
        VirtualFile virtualFile2 = imlFile = virtualFile != null ? virtualFile.findChild(this.moduleEntity.getName() + ".iml") : null;
        return virtualFile2 != null ? VirtualFileUtil.findPsiFile((VirtualFile)virtualFile2, (Project)this.project) : null;
    }
}

