/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.symbols;

import com.intellij.model.Pointer;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.symbols.IntellijModuleNavigationTarget;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\u0002H\u0016J\b\u0010\n\u001a\u00020\u0000H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/devkit/symbols/IntellijModuleSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/model/Pointer;", "moduleId", "Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/ModuleId;)V", "getModuleId", "()Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "createPointer", "dereference", "getNavigationTargets", "", "Lorg/jetbrains/idea/devkit/symbols/IntellijModuleNavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "equals", "", "other", "", "hashCode", "", "intellij.devkit.core"})
public final class IntellijModuleSymbol
implements NavigatableSymbol,
Pointer<IntellijModuleSymbol> {
    @NotNull
    private final ModuleId moduleId;

    public IntellijModuleSymbol(@NotNull ModuleId moduleId) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        this.moduleId = moduleId;
    }

    @NotNull
    public final ModuleId getModuleId() {
        return this.moduleId;
    }

    @NotNull
    public Pointer<IntellijModuleSymbol> createPointer() {
        return this;
    }

    @NotNull
    public IntellijModuleSymbol dereference() {
        return this;
    }

    @NotNull
    public Collection<IntellijModuleNavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModuleEntity moduleEntity = (ModuleEntity)WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot().resolve((SymbolicEntityId)this.moduleId);
        return moduleEntity != null ? (Collection)CollectionsKt.listOf((Object)new IntellijModuleNavigationTarget(moduleEntity, project)) : (Collection)CollectionsKt.emptyList();
    }

    public boolean equals(@Nullable Object other) {
        IntellijModuleSymbol intellijModuleSymbol = other instanceof IntellijModuleSymbol ? (IntellijModuleSymbol)other : null;
        return Intrinsics.areEqual((Object)(intellijModuleSymbol != null ? intellijModuleSymbol.moduleId : null), (Object)this.moduleId);
    }

    public int hashCode() {
        return this.moduleId.hashCode();
    }
}

