/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataHighlightingPass;

final class TestDataHighlightingPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    public static final List<String> SUPPORTED_FILE_TYPES = Collections.singletonList(JavaFileType.INSTANCE.getDefaultExtension());
    public static final List<@NonNls String> SUPPORTED_IN_TEST_DATA_FILE_TYPES = List.of("js", "php", "css", "html", "xhtml", "jsp", "test", "py", "aj", "go", "mod", "work", "sum");
    private static final int MAX_HOPES = 3;
    @NonNls
    private static final String TEST_DATA = "testdata";

    TestDataHighlightingPassFactory() {
    }

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        VirtualFile virtualFile;
        if (file == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(3);
        }
        if ((virtualFile = file.getVirtualFile()) != null) {
            Project project = file.getProject();
            Document document = file.getViewProvider().getDocument();
            if (TestDataHighlightingPassFactory.isSupported(virtualFile, project) && document != null) {
                return new TestDataHighlightingPass(project, document);
            }
        }
        return null;
    }

    private static boolean isSupported(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TestDataHighlightingPassFactory.$$$reportNull$$$0(5);
        }
        if (ScratchUtil.isScratch((VirtualFile)file)) {
            return false;
        }
        String ext = file.getExtension();
        if (SUPPORTED_FILE_TYPES.contains(ext)) {
            return ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(file) == null;
        }
        if (ext != null && SUPPORTED_IN_TEST_DATA_FILE_TYPES.contains(ext)) {
            int i = 0;
            for (VirtualFile parent = file.getParent(); parent != null && i < 3; ++i, parent = parent.getParent()) {
                if (!StringUtil.toLowerCase((String)parent.getName()).contains(TEST_DATA)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataHighlightingPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

