/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.lineMarker.RunLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.TestFramework;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.testAssistant.GotoTestDataAction;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class TestDataLineMarkerProvider
extends LineMarkerProviderDescriptor {
    TestDataLineMarkerProvider() {
    }

    public String getName() {
        return DevKitBundle.message("gutter.name.test.data.line.marker", new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Folder;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            TestDataLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            TestDataLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            TestDataLineMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement psiElement : elements) {
            RunLineMarkerContributor.Info info = TestDataLineMarkerProvider.getSlowInfo(psiElement);
            if (info == null) continue;
            result.add(RunLineMarkerProvider.createLineMarker((PsiElement)psiElement, (Icon)AllIcons.Nodes.Folder, Collections.singletonList(info)));
        }
    }

    private static RunLineMarkerContributor.Info getSlowInfo(@NotNull PsiElement e) {
        Project project;
        if (e == null) {
            TestDataLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (DumbService.isDumb((Project)(project = e.getProject())) || !PsiUtil.isPluginProject(project)) {
            return null;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)e);
        if (file == null || !ProjectFileIndex.getInstance((Project)project).isInTestSourceContent(file)) {
            return null;
        }
        UElement uElement = UastUtils.getUParentForIdentifier((PsiElement)e);
        if (!(uElement instanceof UMethod) && !(uElement instanceof UClass)) {
            return null;
        }
        if (uElement instanceof UMethod) {
            UElement uParent = uElement.getUastParent();
            if (uParent != null) {
                TestFramework testFramework;
                PsiElement psiClass = uParent.getJavaPsi();
                TestFramework testFramework2 = testFramework = psiClass instanceof PsiClass && TestDataLineMarkerProvider.getTestDataBasePath((PsiClass)psiClass) != null ? TestFrameworks.detectFramework((PsiClass)((PsiClass)psiClass)) : null;
                if (testFramework != null && testFramework.isTestMethod(uElement.getJavaPsi())) {
                    return new RunLineMarkerContributor.Info(ActionManager.getInstance().getAction("TestData.Navigate"));
                }
            }
            return null;
        }
        PsiClass psiClass = ((UClass)uElement).getJavaPsi();
        String testDataBasePath = TestDataLineMarkerProvider.getTestDataBasePath(psiClass);
        if (testDataBasePath == null) {
            return null;
        }
        return new RunLineMarkerContributor.Info((AnAction)new GotoTestDataAction(testDataBasePath, psiClass.getProject(), AllIcons.Nodes.Folder));
    }

    @Nullable
    public static String getTestDataBasePath(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            ArrayList<String> pathComponents = new ArrayList<String>();
            PsiClass currentPsiClass = psiClass;
            String testMetaData = null;
            String testDataPath = null;
            while (currentPsiClass != null) {
                PsiClass containingClass;
                testMetaData = testMetaData != null ? testMetaData : (currentPsiClass.equals(psiClass) ? TestDataLineMarkerProvider.annotationValue((PsiModifierListOwner)currentPsiClass, "org.jetbrains.kotlin.test.TestMetadata") : null);
                String localTestDataPath = TestDataLineMarkerProvider.annotationValue((PsiModifierListOwner)currentPsiClass, "com.intellij.testFramework.TestDataPath");
                testDataPath = localTestDataPath != null ? localTestDataPath : testDataPath;
                currentPsiClass = containingClass = currentPsiClass.getContainingClass();
            }
            if (!StringUtil.isEmpty(testMetaData)) {
                pathComponents.add(testMetaData);
            }
            if (!StringUtil.isEmpty(testDataPath)) {
                pathComponents.add(testDataPath);
            }
            if (pathComponents.isEmpty()) {
                return null;
            }
            Collections.reverse(pathComponents);
            String path = FileUtil.toSystemIndependentName((String)Strings.join(pathComponents, (String)File.separator));
            return new CachedValueProvider.Result((Object)path, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static String annotationValue(@NotNull PsiModifierListOwner owner, String annotationFqName) {
        UExpression value;
        if (owner == null) {
            TestDataLineMarkerProvider.$$$reportNull$$$0(4);
        }
        Set<String> annotationNames = Collections.singleton(annotationFqName);
        boolean nestedClass = owner instanceof PsiClass && ((PsiClass)owner).getContainingClass() != null;
        PsiAnnotation element = nestedClass ? AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, annotationNames) : AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)owner, annotationNames);
        UAnnotation annotation = (UAnnotation)UastContextKt.toUElement((PsiElement)element, UAnnotation.class);
        if (annotation != null && (value = annotation.findAttributeValue("value")) != null) {
            Project project = owner.getProject();
            Object constantValue = value.evaluate();
            if (constantValue instanceof String) {
                String path = (String)constantValue;
                if (path.contains("$CONTENT_ROOT")) {
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    VirtualFile file = owner.getContainingFile().getVirtualFile();
                    if (file == null) {
                        return null;
                    }
                    VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
                    if (contentRoot == null) {
                        return null;
                    }
                    path = path.replace("$CONTENT_ROOT", contentRoot.getPath());
                }
                if (path.contains("$PROJECT_ROOT")) {
                    String baseDir = project.getBasePath();
                    if (baseDir == null) {
                        return null;
                    }
                    path = path.replace("$PROJECT_ROOT", baseDir);
                }
                return path;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSlowInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "annotationValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

